/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers.island;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.logs.LogEntry;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.island.IslandGrid;
import world.bentobox.bentobox.util.Util;

public class IslandCache {
    private final @NonNull Map<@NonNull String, Island> islandsById = new HashMap<String, Island>();
    private final @NonNull Map<@NonNull UUID, Set<String>> islandsByUUID = new HashMap<UUID, Set<String>>();
    private final @NonNull Map<@NonNull World, @NonNull IslandGrid> grids = new HashMap<World, IslandGrid>();
    private final @NonNull Database<Island> handler;

    public IslandCache(@NonNull Database<Island> handler) {
        this.handler = handler;
    }

    public void updateMultiLibIsland(@NonNull Island newIsland) {
        Island oldIsland = this.getIslandById(newIsland.getUniqueId());
        Set<UUID> newMembers = newIsland.getMembers().keySet();
        if (oldIsland != null) {
            Set<UUID> oldMembers = oldIsland.getMembers().keySet();
            for (UUID oldMember : oldMembers) {
                if (newMembers.contains(oldMember)) continue;
                this.islandsByUUID.computeIfAbsent(oldMember, k -> new HashSet()).remove(oldIsland.getUniqueId());
            }
        }
        for (UUID newMember : newMembers) {
            Set set = this.islandsByUUID.computeIfAbsent(newMember, k -> new HashSet());
            if (oldIsland != null) {
                set.remove(oldIsland.getUniqueId());
            }
            set.add(newIsland.getUniqueId());
            this.islandsByUUID.put(newMember, set);
        }
        if (this.setIslandById(newIsland) == null) {
            BentoBox.getInstance().logError("islandsById failed to update");
        }
    }

    public boolean addIsland(@NonNull Island island) {
        return this.addIsland(island, false);
    }

    public boolean addIsland(@NonNull Island island, boolean noCache) {
        if (island.getCenter() == null || island.getWorld() == null) {
            return false;
        }
        if (this.addToGrid(island)) {
            this.islandsById.put(island.getUniqueId().intern(), noCache ? null : island);
            if (island.isOwned()) {
                this.islandsByUUID.computeIfAbsent(island.getOwner(), k -> new HashSet()).add(island.getUniqueId());
                island.getMemberSet().forEach(member -> this.addPlayer((UUID)member, island));
            }
            return true;
        }
        return false;
    }

    public void addPlayer(@NonNull UUID uuid, @NonNull Island island) {
        this.islandsByUUID.computeIfAbsent(uuid, k -> new HashSet()).add(island.getUniqueId());
    }

    private boolean addToGrid(@NonNull Island newIsland) {
        return this.grids.computeIfAbsent(newIsland.getWorld(), k -> new IslandGrid(this)).addToGrid(newIsland);
    }

    public void clear() {
        this.islandsById.clear();
        this.islandsByUUID.clear();
    }

    public void deleteIslandFromCache(@NonNull Island island) {
        this.islandsById.remove(island.getUniqueId(), island);
        this.removeFromIslandsByUUID(island);
        if (this.grids.containsKey(island.getWorld())) {
            this.grids.get(island.getWorld()).removeFromGrid(island);
        }
    }

    private void removeFromIslandsByUUID(Island island) {
        Iterator<Map.Entry<UUID, Set<String>>> iterator = this.islandsByUUID.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Set<String>> entry = iterator.next();
            Set<String> set = entry.getValue();
            set.removeIf(island.getUniqueId()::equals);
            if (!set.isEmpty()) continue;
            iterator.remove();
        }
    }

    public void deleteIslandFromCache(@NonNull String uniqueId) {
        if (this.islandsById.containsKey(uniqueId)) {
            this.deleteIslandFromCache(this.getIslandById(uniqueId));
        }
    }

    public @Nullable Island getIsland(@NonNull World world, @NonNull UUID uuid) {
        List<Island> islands = this.getIslands(world, uuid);
        if (islands.isEmpty()) {
            return null;
        }
        for (Island island : islands) {
            if (!island.isPrimary(uuid)) continue;
            return island;
        }
        Island result = islands.getFirst();
        result.setPrimary(uuid);
        return result;
    }

    public List<Island> getIslands(@NonNull World world, @NonNull UUID uuid) {
        World w = Util.getWorld(world);
        if (w == null) {
            return new ArrayList<Island>();
        }
        return this.islandsByUUID.computeIfAbsent(uuid, k -> new HashSet()).stream().map(this::getIslandById).filter(Objects::nonNull).filter(island -> w.equals((Object)island.getWorld())).sorted(Comparator.comparingLong(Island::getCreatedDate)).collect(Collectors.toList());
    }

    public void setPrimaryIsland(@NonNull UUID uuid, @NonNull Island island) {
        if (island.getPrimaries().contains(uuid)) {
            return;
        }
        for (Island is : this.getIslands(island.getWorld(), uuid)) {
            if (is.getPrimaries().contains(uuid)) {
                is.removePrimary(uuid);
            }
            if (!is.equals(island)) continue;
            is.setPrimary(uuid);
        }
    }

    public boolean isIslandAt(@NonNull Location location) {
        World w = Util.getWorld(location.getWorld());
        if (w == null || !this.grids.containsKey(w)) {
            return false;
        }
        return this.grids.get(w).isIslandAt(location.getBlockX(), location.getBlockZ());
    }

    public @Nullable Island getIslandAt(@NonNull Location location) {
        World w = Util.getWorld(location.getWorld());
        if (w == null || !this.grids.containsKey(w)) {
            return null;
        }
        return this.grids.get(w).getIslandAt(location.getBlockX(), location.getBlockZ());
    }

    public @NonNull Collection<Island> getIslands() {
        ArrayList<Island> result = new ArrayList<Island>();
        for (Map.Entry<String, Island> entry : this.islandsById.entrySet()) {
            Island island = entry.getValue() != null ? entry.getValue() : this.loadIsland(entry.getKey());
            if (island == null) continue;
            result.add(island);
        }
        return Collections.unmodifiableCollection(result);
    }

    public @Nullable Island loadIsland(String uniqueId) {
        return this.handler.objectExists(uniqueId) ? this.handler.loadObject(uniqueId) : null;
    }

    public @NonNull Collection<Island> getCachedIslands() {
        return this.islandsById.values().stream().filter(Objects::nonNull).toList();
    }

    public @NonNull Collection<Island> getIslands(@NonNull World world) {
        World overworld = Util.getWorld(world);
        if (overworld == null) {
            return Collections.emptyList();
        }
        ArrayList<Island> result = new ArrayList<Island>();
        for (Map.Entry<String, Island> entry : this.islandsById.entrySet()) {
            Island island = entry.getValue() != null ? entry.getValue() : this.loadIsland(entry.getKey());
            if (island == null || !overworld.equals((Object)island.getWorld())) continue;
            result.add(island);
        }
        return Collections.unmodifiableCollection(result);
    }

    public boolean hasIsland(@NonNull World world, @NonNull UUID uuid) {
        if (!this.islandsByUUID.containsKey(uuid)) {
            return false;
        }
        return this.islandsByUUID.get(uuid).stream().map(this::getIslandById).filter(Objects::nonNull).filter(i -> world.equals((Object)i.getWorld())).anyMatch(i -> uuid.equals(i.getOwner()));
    }

    public Set<Island> removePlayer(@NonNull World world, @NonNull UUID uuid) {
        World resolvedWorld = Util.getWorld(world);
        Set<String> playerIslandIds = this.islandsByUUID.get(uuid);
        HashSet<Island> removedIslands = new HashSet<Island>();
        if (resolvedWorld == null || playerIslandIds == null) {
            return Collections.emptySet();
        }
        Iterator<String> iterator = playerIslandIds.iterator();
        while (iterator.hasNext()) {
            Island island = this.getIslandById(iterator.next());
            if (island == null || !resolvedWorld.equals((Object)island.getWorld())) continue;
            removedIslands.add(island);
            if (uuid.equals(island.getOwner())) {
                island.getMembers().clear();
                island.setOwner(null);
            } else {
                island.removeMember(uuid);
            }
            iterator.remove();
        }
        return removedIslands;
    }

    public void removePlayer(@NonNull Island island, @NonNull UUID uuid) {
        Set<String> islandSet = this.islandsByUUID.get(uuid);
        if (islandSet != null) {
            islandSet.remove(island.getUniqueId());
        }
        island.removeMember(uuid);
        island.removePrimary(uuid);
        island.log(new LogEntry.Builder(LogEntry.LogType.REMOVE).data(uuid.toString(), "player").build());
    }

    public int size() {
        return this.islandsById.size();
    }

    public long size(World world) {
        return this.grids.containsKey(world) ? this.grids.get(world).getSize() : 0L;
    }

    public void setOwner(@NonNull Island island, @Nullable UUID newOwnerUUID) {
        island.setOwner(newOwnerUUID);
        if (newOwnerUUID != null) {
            this.islandsByUUID.computeIfAbsent(newOwnerUUID, k -> new HashSet()).add(island.getUniqueId());
        }
        island.setRank(newOwnerUUID, 1000);
        this.setIslandById(island);
    }

    public @Nullable Island getIslandById(@NonNull String uniqueId) {
        return this.getIslandById(uniqueId, true);
    }

    public @Nullable Island getIslandById(@NonNull String uniqueId, boolean cache) {
        Island island = this.islandsById.get(uniqueId);
        if (island != null) {
            return island;
        }
        island = this.loadIsland(uniqueId);
        if (cache && island != null) {
            this.islandsById.put(uniqueId, island);
        }
        return island;
    }

    public boolean expireIslandById(@NonNull String uniqueId) {
        return this.islandsById.containsKey(uniqueId) && this.islandsById.put(uniqueId, null) != null;
    }

    Island setIslandById(Island island) {
        return this.islandsById.put(island.getUniqueId().intern(), island);
    }

    public void resetAllFlags(World world) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BentoBox.getInstance(), () -> this.getIslands(world).forEach(Island::setFlagsDefaults));
    }

    public void resetFlag(World world, Flag flag) {
        int setting = BentoBox.getInstance().getIWM().getDefaultIslandFlags(world).getOrDefault(flag, flag.getDefaultRank());
        this.getIslands(world).forEach(i -> i.setFlag(flag, setting));
    }

    public Set<String> getAllIslandIds() {
        return this.islandsById.keySet();
    }

    public @NonNull List<Island> getIslands(UUID uniqueId) {
        return this.islandsByUUID.getOrDefault(uniqueId, Collections.emptySet()).stream().map(this::getIslandById).filter(Objects::nonNull).toList();
    }

    public boolean isIslandId(String uniqueId) {
        return this.islandsById.containsKey(uniqueId);
    }

    public boolean isIslandCached(String uniqueId) {
        return this.islandsById.get(uniqueId) != null;
    }

    public IslandGrid getIslandGrid(World world) {
        World w = Util.getWorld(world);
        if (w == null) {
            return null;
        }
        return this.grids.get(w);
    }
}

