/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.panels;

import java.util.List;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.hooks.Hook;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.builders.PanelBuilder;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.panels.BlueprintManagementPanel;
import world.bentobox.bentobox.panels.CatalogPanel;
import world.bentobox.bentobox.panels.CreditsPanel;
import world.bentobox.bentobox.versions.ServerCompatibility;

public class ManagementPanel {
    private static final String LOCALE_REF = "management.panel.";
    private static final int[] PANES = new int[]{0, 4, 5, 8, 9, 18, 26, 27, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};

    private ManagementPanel() {
    }

    public static void openPanel(@NonNull User user, View view) {
        BentoBox plugin = BentoBox.getInstance();
        PanelBuilder builder = new PanelBuilder().name(user.getTranslation("management.panel.title", new String[0])).size(45);
        ManagementPanel.setupHeader(builder, user, view);
        for (int i : PANES) {
            builder.item(i, new PanelItemBuilder().icon(plugin.getSettings().getPanelFillerMaterial()).name(" ").build());
        }
        int startSlot = 10;
        int i = 0;
        switch (view.ordinal()) {
            case 0: {
                List<GameModeAddon> addons = plugin.getAddonsManager().getGameModeAddons();
                if (addons.isEmpty()) {
                    ManagementPanel.looksEmpty(builder, user);
                    break;
                }
                for (Addon addon2 : addons) {
                    GameModeAddon gameModeAddon = (GameModeAddon)addon2;
                    PanelItem addonItem = new PanelItemBuilder().icon(addon2.getDescription().getIcon()).name(user.getTranslation("management.panel.views.gamemodes.gamemode.name", "[name]", addon2.getDescription().getName())).description(user.getTranslation("management.panel.views.gamemodes.gamemode.description", "[islands]", String.valueOf(addon2.getIslands().getIslandCount(gameModeAddon.getOverWorld())))).clickHandler((panel, user1, clickType, slot) -> {
                        if (clickType.equals((Object)ClickType.MIDDLE)) {
                            CreditsPanel.openPanel(user, addon2);
                        }
                        return true;
                    }).build();
                    builder.item(startSlot + i, addonItem);
                    PanelItem blueprints = new PanelItemBuilder().icon(Material.STRUCTURE_BLOCK).name(user.getTranslation("management.panel.views.gamemodes.blueprints.name", new String[0])).description(user.getTranslation("management.panel.views.gamemodes.blueprints.description", new String[0])).clickHandler((panel, user1, clickType, slot) -> {
                        new BlueprintManagementPanel(plugin, user, gameModeAddon).openPanel();
                        return true;
                    }).build();
                    builder.item(startSlot + i + 9, blueprints);
                    ++i;
                }
                break;
            }
            case 1: {
                List<Addon> addons = plugin.getAddonsManager().getEnabledAddons().stream().filter(addon -> !(addon instanceof GameModeAddon)).toList();
                if (addons.isEmpty()) {
                    ManagementPanel.looksEmpty(builder, user);
                    break;
                }
                for (Addon addon3 : addons) {
                    PanelItem addonItem = new PanelItemBuilder().icon(addon3.getDescription().getIcon()).name(String.valueOf(NamedTextColor.WHITE) + addon3.getDescription().getName()).clickHandler((panel, user1, clickType, slot) -> {
                        if (clickType.equals((Object)ClickType.MIDDLE)) {
                            CreditsPanel.openPanel(user, addon2);
                        }
                        return true;
                    }).build();
                    builder.item(startSlot + i, addonItem);
                    if (!builder.slotOccupied(startSlot + ++i)) continue;
                    i += 2;
                }
                break;
            }
            case 2: {
                if (plugin.getHooks().getHooks().isEmpty()) {
                    ManagementPanel.looksEmpty(builder, user);
                    break;
                }
                for (Hook hook : plugin.getHooks().getHooks()) {
                    PanelItem hookItem = new PanelItemBuilder().icon(hook.getIcon()).name(String.valueOf(NamedTextColor.WHITE) + hook.getPluginName()).build();
                    builder.item(startSlot + i, hookItem);
                    if (!builder.slotOccupied(startSlot + ++i)) continue;
                    i += 2;
                }
                break;
            }
        }
        PanelItem catalog = new PanelItemBuilder().icon(Material.ENCHANTED_BOOK).name(user.getTranslation("management.panel.buttons.catalog.name", new String[0])).description(user.getTranslation("management.panel.buttons.catalog.description", new String[0])).clickHandler((panel, user1, clickType, slot) -> {
            CatalogPanel.openPanel(user, CatalogPanel.View.GAMEMODES);
            return true;
        }).build();
        builder.item(17, catalog);
        PanelItem panelItem = new PanelItemBuilder().icon(Material.KNOWLEDGE_BOOK).name(user.getTranslation("management.panel.buttons.credits.name", new String[0])).description(user.getTranslation("management.panel.buttons.credits.description", new String[0])).clickHandler((panel, user1, clickType, slot) -> {
            CreditsPanel.openPanel(user, "BentoBoxWorld/BentoBox");
            return true;
        }).build();
        builder.item(26, panelItem);
        builder.build().open(user);
    }

    private static void setupHeader(PanelBuilder builder, User user, View view) {
        PanelItemBuilder gamemodesIconBuilder = new PanelItemBuilder().icon(Material.COMMAND_BLOCK).name(user.getTranslation("management.panel.views.gamemodes.name", new String[0])).description(user.getTranslation("management.panel.views.gamemodes.description", new String[0])).clickHandler((panel, user1, clickType, slot) -> {
            ManagementPanel.openPanel(user, View.GAMEMODES);
            return true;
        });
        PanelItemBuilder addonsIconBuilder = new PanelItemBuilder().icon(Material.BOOK).name(user.getTranslation("management.panel.views.addons.name", new String[0])).description(user.getTranslation("management.panel.views.addons.description", new String[0])).clickHandler((panel, user1, clickType, slot) -> {
            ManagementPanel.openPanel(user, View.ADDONS);
            return true;
        });
        PanelItemBuilder hooksIconBuilder = new PanelItemBuilder().icon(Material.TRIPWIRE_HOOK).name(user.getTranslation("management.panel.views.hooks.name", new String[0])).description(user.getTranslation("management.panel.views.hooks.description", new String[0])).clickHandler((panel, user1, clickType, slot) -> {
            ManagementPanel.openPanel(user, View.HOOKS);
            return true;
        });
        switch (view.ordinal()) {
            case 0: {
                gamemodesIconBuilder.glow(true);
                break;
            }
            case 1: {
                addonsIconBuilder.glow(true);
                break;
            }
            case 2: {
                hooksIconBuilder.glow(true);
            }
        }
        builder.item(1, gamemodesIconBuilder.build());
        builder.item(2, addonsIconBuilder.build());
        builder.item(3, hooksIconBuilder.build());
        PanelItem reloadItem = new PanelItemBuilder().icon(Material.REDSTONE_TORCH).name(user.getTranslation("management.panel.actions.reload.name", new String[0])).description(user.getTranslation("management.panel.actions.reload.description", new String[0])).clickHandler((panel, user1, clickType, slot) -> {
            user1.performCommand("bentobox reload");
            return true;
        }).build();
        builder.item(6, reloadItem);
        ServerCompatibility.Compatibility compatibility = ServerCompatibility.getInstance().checkCompatibility();
        ServerCompatibility.ServerSoftware serverSoftware = ServerCompatibility.getInstance().getServerSoftware();
        ServerCompatibility.ServerVersion serverVersion = ServerCompatibility.getInstance().getServerVersion();
        PanelItemBuilder compatibilityItemBuilder = new PanelItemBuilder().name(user.getTranslation("management.panel.information.state.name", new String[0])).description(user.getTranslation("management.panel.information.state.description." + String.valueOf((Object)compatibility), "[name]", serverSoftware.equals((Object)ServerCompatibility.ServerSoftware.UNKNOWN) ? serverSoftware.getName() : serverSoftware.toString(), "[version]", serverVersion != null ? serverVersion.toString() : user.getTranslation("general.invalid", new String[0])));
        switch (compatibility) {
            case COMPATIBLE: 
            case SUPPORTED: {
                compatibilityItemBuilder.icon(Material.GREEN_CONCRETE);
                break;
            }
            case NOT_SUPPORTED: {
                compatibilityItemBuilder.icon(Material.ORANGE_CONCRETE);
                break;
            }
            case INCOMPATIBLE: {
                compatibilityItemBuilder.icon(Material.RED_CONCRETE);
            }
        }
        builder.item(7, compatibilityItemBuilder.build());
    }

    private static void looksEmpty(@NonNull PanelBuilder builder, @NonNull User user) {
        PanelItem emptyHere = new PanelItemBuilder().icon(Material.STRUCTURE_VOID).name(user.getTranslation("management.panel.buttons.empty-here.name", new String[0])).description(user.getTranslation("management.panel.buttons.empty-here.description", new String[0])).clickHandler((panel, user1, clickType, slot) -> {
            CatalogPanel.openPanel(user, CatalogPanel.View.GAMEMODES);
            return true;
        }).build();
        builder.item(22, emptyHere);
    }

    public static enum View {
        GAMEMODES,
        ADDONS,
        HOOKS;

    }
}

