/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.panels.customizable;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.island.IslandGoCommand;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.TemplatedPanel;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.panels.builders.TemplatedPanelBuilder;
import world.bentobox.bentobox.api.panels.reader.ItemTemplateRecord;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.panels.customizable.AbstractPanel;

public class IslandHomesPanel
extends AbstractPanel {
    private static final String ISLAND = "ISLAND";
    private final Map<String, IslandInfo> islandMap;
    private final Map<Integer, String> order = new HashMap<Integer, String>();
    private final World world;
    private final IslandGoCommand goCommand;

    private IslandHomesPanel(@NonNull CompositeCommand command, @NonNull User user) {
        super(command, user);
        this.world = command.getWorld();
        this.islandMap = this.getNameIslandMap(user);
        int index = 0;
        for (String name : this.islandMap.keySet()) {
            this.order.put(index++, name);
        }
        this.goCommand = command.getParent().getSubCommand("go").orElse(null);
    }

    @Override
    protected void build() {
        if (this.islandMap.isEmpty()) {
            this.user.sendMessage("general.errors.no-island", new String[0]);
            return;
        }
        TemplatedPanelBuilder panelBuilder = new TemplatedPanelBuilder();
        if (this.doesCustomPanelExists((GameModeAddon)this.command.getAddon(), "island_homes_panel")) {
            panelBuilder.template("island_homes_panel", new File(((Addon)this.command.getAddon()).getDataFolder(), "panels"));
        } else {
            panelBuilder.template("island_homes_panel", new File(this.plugin.getDataFolder(), "panels"));
        }
        panelBuilder.user(this.user);
        panelBuilder.world(this.world);
        panelBuilder.registerTypeBuilder(ISLAND, this::createIslandButton);
        panelBuilder.registerTypeBuilder("NEXT", this::createNextButton);
        panelBuilder.registerTypeBuilder("PREVIOUS", this::createPreviousButton);
        panelBuilder.build();
    }

    @Override
    protected @Nullable PanelItem createNextButton(@NonNull ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        int size = this.islandMap.size();
        if (size <= slot.amountMap().getOrDefault(ISLAND, 1) || 1.0 * (double)size / (double)slot.amountMap().getOrDefault(ISLAND, 1).intValue() <= (double)(this.pageIndex + 1)) {
            return null;
        }
        int nextPageIndex = this.pageIndex + 2;
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            ItemStack clone = template.icon().clone();
            if (((Boolean)template.dataMap().getOrDefault("indexing", false)).booleanValue()) {
                clone.setAmount(nextPageIndex);
            }
            builder.icon(clone);
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.command.getWorld(), template.title(), new String[0]));
        }
        if (template.description() != null) {
            builder.description(this.user.getTranslation(this.command.getWorld(), template.description(), "[number]", String.valueOf(nextPageIndex)));
        }
        builder.clickHandler((panel, user, clickType, i) -> {
            template.actions().forEach(action -> {
                if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && "NEXT".equalsIgnoreCase(action.actionType())) {
                    ++this.pageIndex;
                    this.build();
                }
            });
            return true;
        });
        List tooltips = template.actions().stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.command.getWorld(), action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(template.actions().size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }

    @Override
    protected @Nullable PanelItem createPreviousButton(@NonNull ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.pageIndex == 0) {
            return null;
        }
        int previousPageIndex = this.pageIndex;
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            ItemStack clone = template.icon().clone();
            if (((Boolean)template.dataMap().getOrDefault("indexing", false)).booleanValue()) {
                clone.setAmount(previousPageIndex);
            }
            builder.icon(clone);
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.command.getWorld(), template.title(), new String[0]));
        }
        if (template.description() != null) {
            builder.description(this.user.getTranslation(this.command.getWorld(), template.description(), "[number]", String.valueOf(previousPageIndex)));
        }
        builder.clickHandler((panel, user, clickType, i) -> {
            template.actions().forEach(action -> {
                if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && "PREVIOUS".equalsIgnoreCase(action.actionType())) {
                    --this.pageIndex;
                    this.build();
                }
            });
            return true;
        });
        List tooltips = template.actions().stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.command.getWorld(), action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(template.actions().size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }

    private @Nullable PanelItem createIslandButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.islandMap.isEmpty()) {
            return null;
        }
        int index = this.pageIndex * slot.amountMap().getOrDefault(ISLAND, 1) + slot.slot();
        if (index >= this.islandMap.size()) {
            return null;
        }
        return this.createIslandButtonDetail(template, slot);
    }

    private PanelItem createIslandButtonDetail(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            builder.icon(template.icon().clone());
        } else {
            builder.icon(Material.GRASS_BLOCK);
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.command.getWorld(), template.title(), "[name]", this.order.get(slot.slot())));
        } else {
            builder.name(this.user.getTranslation("panels.island_homes.buttons.name", "[name]", this.order.get(slot.slot())));
        }
        builder.clickHandler((panel, user, clickType, i) -> {
            template.actions().forEach(action -> {
                if (this.goCommand != null) {
                    String name = this.order.get(slot.slot());
                    user.closeInventory();
                    if (this.goCommand.canExecute(user, "", List.of(name))) {
                        this.goCommand.execute(user, "", List.of(name));
                    }
                }
            });
            return true;
        });
        return builder.build();
    }

    private Map<String, IslandInfo> getNameIslandMap(User user) {
        HashMap<String, IslandInfo> islandMap = new HashMap<String, IslandInfo>();
        int index = 0;
        for (Island island : this.command.getIslands().getIslands(this.command.getWorld(), user.getUniqueId())) {
            ++index;
            if (island.getName() != null && !island.getName().isBlank()) {
                islandMap.put(island.getName(), new IslandInfo(island, true));
            } else {
                String text = user.getTranslation("protection.flags.ENTER_EXIT_MESSAGES.island", "[name]", user.getName(), "[display_name]", user.getDisplayName()) + " " + index;
                islandMap.put(text, new IslandInfo(island, true));
            }
            island.getHomes().keySet().stream().filter(n -> !n.isBlank()).forEach(n -> islandMap.put((String)n, new IslandInfo(island, false)));
        }
        return islandMap;
    }

    public static void openPanel(@NonNull CompositeCommand command, @NonNull User user) {
        new IslandHomesPanel(command, user).build();
    }

    private record IslandInfo(Island island, boolean islandName) {
    }
}

