/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.blueprints;

import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.BlueprintClipboard;

public class AdminBlueprintOriginCommand
extends CompositeCommand {
    public AdminBlueprintOriginCommand(AdminBlueprintCommand parent) {
        super(parent, "origin", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.blueprint.origin");
        this.setParametersHelp("commands.admin.blueprint.origin.parameters");
        this.setDescription("commands.admin.blueprint.origin.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        AdminBlueprintCommand parent = (AdminBlueprintCommand)this.getParent();
        BlueprintClipboard clipboard = parent.getClipboards().computeIfAbsent(user.getUniqueId(), v -> new BlueprintClipboard());
        if (clipboard.getPos1() == null || clipboard.getPos2() == null) {
            user.sendMessage("commands.admin.blueprint.need-pos1-pos2", new String[0]);
            return false;
        }
        Block b = Objects.requireNonNull(user.getPlayer()).getLineOfSight(null, 20).stream().filter(x -> !x.getType().equals((Object)Material.AIR)).findFirst().orElse(null);
        if (b != null) {
            clipboard.setOrigin(b.getLocation().toVector());
            user.getPlayer().sendBlockChange(b.getLocation(), Material.REDSTONE_BLOCK.createBlockData());
            Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), () -> user.getPlayer().sendBlockChange(b.getLocation(), b.getBlockData()), 20L);
            user.sendMessage("general.success", new String[0]);
            return true;
        }
        user.sendMessage("commands.admin.blueprint.look-at-a-block", new String[0]);
        return false;
    }
}

