/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.purge;

import java.util.List;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class AdminPurgeProtectCommand
extends CompositeCommand {
    private Island island;

    public AdminPurgeProtectCommand(CompositeCommand parent) {
        super(parent, "protect", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.purge.protect");
        this.setOnlyPlayer(true);
        this.setDescription("commands.admin.purge.protect.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (!args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        if (!this.getIslands().getIslandAt(user.getLocation()).map(i -> {
            this.island = i;
            return true;
        }).orElse(false).booleanValue()) {
            user.sendMessage("commands.admin.purge.protect.move-to-island", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        this.island.setPurgeProtected(!this.island.isPurgeProtected());
        if (this.island.isPurgeProtected()) {
            user.sendMessage("commands.admin.purge.protect.protecting", new String[0]);
        } else {
            user.sendMessage("commands.admin.purge.protect.unprotecting", new String[0]);
        }
        return true;
    }
}

