/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.purge;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.island.IslandGrid;
import world.bentobox.bentobox.util.Pair;
import world.bentobox.bentobox.util.Util;
import world.bentobox.level.Level;

public class AdminPurgeRegionsCommand
extends CompositeCommand
implements Listener {
    private volatile boolean inPurge;
    private boolean toBeConfirmed;
    private User user;
    private Map<Pair<Integer, Integer>, Set<String>> deleteableRegions;
    private final boolean isNether;
    private final boolean isEnd;
    private int days;

    public AdminPurgeRegionsCommand(CompositeCommand parent) {
        super(parent, "regions", new String[0]);
        ((Addon)this.getAddon()).registerListener(this);
        this.isNether = this.getPlugin().getIWM().isNetherGenerate(this.getWorld()) && this.getPlugin().getIWM().isNetherIslands(this.getWorld());
        this.isEnd = this.getPlugin().getIWM().isEndGenerate(this.getWorld()) && this.getPlugin().getIWM().isEndIslands(this.getWorld());
    }

    @Override
    public void setup() {
        this.setPermission("admin.purge.regions");
        this.setOnlyPlayer(false);
        this.setParametersHelp("commands.admin.purge.regions.parameters");
        this.setDescription("commands.admin.purge.regions.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (this.inPurge) {
            user.sendMessage("commands.admin.purge.purge-in-progress", "[label]", this.getTopLabel());
            return false;
        }
        if (args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        this.user = user;
        if (args.getFirst().equalsIgnoreCase("confirm") && this.toBeConfirmed && this.user.equals(user)) {
            return this.deleteEverything();
        }
        this.toBeConfirmed = false;
        try {
            this.days = Integer.parseInt(args.getFirst());
            if (this.days <= 0) {
                user.sendMessage("commands.admin.purge.days-one-or-more", new String[0]);
                return false;
            }
        }
        catch (NumberFormatException e) {
            user.sendMessage("commands.admin.purge.days-one-or-more", new String[0]);
            return false;
        }
        user.sendMessage("commands.admin.purge.scanning", new String[0]);
        Bukkit.getWorlds().forEach(World::save);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.getPlugin(), () -> this.findIslands(this.getWorld(), this.days));
        return true;
    }

    private boolean deleteEverything() {
        if (this.deleteableRegions.isEmpty()) {
            this.user.sendMessage("commands.admin.purge.none-found", new String[0]);
            return false;
        }
        Bukkit.getWorlds().forEach(World::save);
        this.getPlugin().log("Now deleting region files");
        if (!this.deleteRegionFiles()) {
            this.getPlugin().logError("Not all region files could be deleted");
        }
        for (Set<String> islandIDs : this.deleteableRegions.values()) {
            for (String islandID : islandIDs) {
                this.deletePlayerFromWorldFolder(islandID);
                this.getPlugin().getIslands().getIslandCache().deleteIslandFromCache(islandID);
                if (!this.getPlugin().getIslands().deleteIslandId(islandID)) continue;
                this.getPlugin().log("Island ID " + islandID + " deleted from cache and database");
            }
        }
        this.user.sendMessage("general.success", new String[0]);
        this.toBeConfirmed = false;
        this.deleteableRegions.clear();
        return true;
    }

    private void deletePlayerFromWorldFolder(String islandID) {
        File base = this.getWorld().getWorldFolder();
        File playerData = new File(base, "playerdata");
        this.getPlugin().getIslands().getIslandById(islandID).ifPresent(island -> island.getMemberSet().forEach(uuid -> {
            ArrayList<Island> memberOf = new ArrayList<Island>(this.getIslands().getIslands(this.getWorld(), (UUID)uuid));
            this.deleteableRegions.values().forEach(ids -> memberOf.removeIf(i -> ids.contains(i.getUniqueId())));
            if (memberOf.isEmpty()) {
                OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)uuid);
                if (p.isOp()) {
                    return;
                }
                Long lastLogin = this.getPlugin().getPlayers().getLastLoginTimestamp((UUID)uuid);
                if (lastLogin == null) {
                    lastLogin = Bukkit.getOfflinePlayer((UUID)uuid).getLastSeen();
                }
                long cutoffMillis = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(this.days);
                if (lastLogin >= cutoffMillis) {
                    return;
                }
                if (playerData.exists()) {
                    File playerFile = new File(playerData, String.valueOf(uuid) + ".dat");
                    if (playerFile.exists() && !playerFile.delete()) {
                        this.getPlugin().logError("Failed to delete player data file: " + playerFile.getAbsolutePath());
                    }
                    if ((playerFile = new File(playerData, String.valueOf(uuid) + ".dat_old")).exists() && !playerFile.delete()) {
                        this.getPlugin().logError("Failed to delete player data backup file: " + playerFile.getAbsolutePath());
                    }
                }
            }
        }));
    }

    private boolean deleteIfExists(File file) {
        if (!file.getParentFile().exists()) {
            return true;
        }
        if (file.exists() && !file.delete()) {
            this.getPlugin().logError("Failed to delete file: " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    private boolean deleteRegionFiles() {
        String name;
        int z;
        int x;
        if (this.days <= 0) {
            this.getPlugin().logError("Days is somehow zero or negative!");
            return false;
        }
        long cutoffMillis = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(this.days);
        World world = this.getWorld();
        File base = world.getWorldFolder();
        File overworldRegion = new File(base, "region");
        File overworldEntities = new File(base, "entities");
        File overworldPoi = new File(base, "poi");
        File netherRegion = new File(base, "DIM-1" + File.separator + "region");
        File netherEntities = new File(base, "DIM-1" + File.separator + "entities");
        File netherPoi = new File(base, "DIM-1" + File.separator + "poi");
        File endRegion = new File(base, "DIM1" + File.separator + "region");
        File endEntities = new File(base, "DIM1" + File.separator + "entities");
        File endPoi = new File(base, "DIM1" + File.separator + "poi");
        for (Pair<Integer, Integer> coords : this.deleteableRegions.keySet()) {
            File ef;
            File nf;
            x = coords.x();
            name = "r." + x + "." + (z = coords.z().intValue()) + ".mca";
            File owFile = new File(overworldRegion, name);
            if (owFile.exists() && this.getRegionTimestamp(owFile) >= cutoffMillis) {
                return false;
            }
            if (this.isNether && (nf = new File(netherRegion, name)).exists() && this.getRegionTimestamp(nf) >= cutoffMillis) {
                return false;
            }
            if (!this.isEnd || !(ef = new File(endRegion, name)).exists() || this.getRegionTimestamp(ef) < cutoffMillis) continue;
            return false;
        }
        for (Pair<Integer, Integer> coords : this.deleteableRegions.keySet()) {
            x = coords.x();
            z = coords.z();
            name = "r." + x + "." + z + ".mca";
            boolean allDeleted = true;
            allDeleted &= this.deleteIfExists(new File(overworldRegion, name));
            allDeleted &= this.deleteIfExists(new File(overworldEntities, name));
            allDeleted &= this.deleteIfExists(new File(overworldPoi, name));
            if (this.isNether) {
                allDeleted &= this.deleteIfExists(new File(netherRegion, name));
                allDeleted &= this.deleteIfExists(new File(netherEntities, name));
                allDeleted &= this.deleteIfExists(new File(netherPoi, name));
            }
            if (this.isEnd) {
                allDeleted &= this.deleteIfExists(new File(endRegion, name));
                allDeleted &= this.deleteIfExists(new File(endEntities, name));
                allDeleted &= this.deleteIfExists(new File(endPoi, name));
            }
            if (allDeleted) continue;
            this.getPlugin().logError("Could not delete all the region/entity/poi files for some reason");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findIslands(World world, int days) {
        try {
            IslandGrid islandGrid = this.getPlugin().getIslands().getIslandCache().getIslandGrid(world);
            if (islandGrid == null) {
                Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), () -> this.user.sendMessage("commands.admin.purge.none-found", new String[0]));
                return;
            }
            TreeMap<Integer, TreeMap<Integer, IslandGrid.IslandData>> grid = islandGrid.getGrid();
            if (grid == null) {
                Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), () -> this.user.sendMessage("commands.admin.purge.none-found", new String[0]));
                return;
            }
            List<Pair<Integer, Integer>> oldRegions = this.findOldRegions(days);
            this.deleteableRegions = this.mapIslandsToRegions(oldRegions, grid);
            this.deleteableRegions.values().removeIf(islandIds -> islandIds.stream().map(this.getPlugin().getIslands()::getIslandById).anyMatch(optIsland -> optIsland.map(this::canDeleteIsland).orElse(true)));
            Set<Island> uniqueIslands = this.deleteableRegions.values().stream().flatMap(Collection::stream).map(this.getPlugin().getIslands()::getIslandById).flatMap(Optional::stream).collect(Collectors.toSet());
            uniqueIslands.forEach(this::displayIsland);
            this.deleteableRegions.entrySet().stream().filter(e -> ((Set)e.getValue()).isEmpty()).forEach(e -> this.displayEmptyRegion((Pair)e.getKey()));
            if (this.deleteableRegions.isEmpty()) {
                Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), () -> this.user.sendMessage("commands.admin.purge.none-found", new String[0]));
            } else {
                Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), () -> {
                    this.user.sendMessage("commands.admin.purge.purgable-islands", "[number]", String.valueOf(uniqueIslands.size()));
                    this.user.sendMessage("commands.admin.purge.regions.confirm", "[label]", this.getLabel());
                    this.user.sendMessage("general.beta", new String[0]);
                    this.toBeConfirmed = true;
                });
            }
        }
        finally {
            this.inPurge = false;
        }
    }

    private void displayIsland(Island island) {
        if (island.isDeletable()) {
            this.getPlugin().log("Deletable island at " + Util.xyz(island.getCenter().toVector()) + " in world " + this.getWorld().getName() + " will be deleted");
            return;
        }
        if (island.getOwner() == null) {
            this.getPlugin().log("Unowned island at " + Util.xyz(island.getCenter().toVector()) + " in world " + this.getWorld().getName() + " will be deleted");
            return;
        }
        this.getPlugin().log("Island at " + Util.xyz(island.getCenter().toVector()) + " in world " + this.getWorld().getName() + " owned by " + this.getPlugin().getPlayers().getName(island.getOwner()) + " who last logged in " + this.formatLocalTimestamp(this.getPlugin().getPlayers().getLastLoginTimestamp(island.getOwner())) + " will be deleted");
    }

    private void displayEmptyRegion(Pair<Integer, Integer> region) {
        this.getPlugin().log("Empty region at r." + String.valueOf(region.x()) + "." + String.valueOf(region.z()) + " in world " + this.getWorld().getName() + " will be deleted (no islands)");
    }

    private String formatLocalTimestamp(Long millis) {
        if (millis == null) {
            return "(unknown or never recorded)";
        }
        Instant instant = Instant.ofEpochMilli(millis);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(ZoneId.systemDefault());
        return formatter.format(instant);
    }

    private boolean canDeleteIsland(Island island) {
        if (island.isDeletable()) {
            return false;
        }
        long cutoffMillis = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(this.days);
        if (island.getMemberSet().stream().map(uuid -> {
            Long lastLogin = this.getPlugin().getPlayers().getLastLoginTimestamp((UUID)uuid);
            if (lastLogin == null) {
                lastLogin = Bukkit.getOfflinePlayer((UUID)uuid).getLastSeen();
            }
            return lastLogin >= cutoffMillis;
        }).findFirst().orElse(false).booleanValue()) {
            return false;
        }
        boolean levelCheck = this.getPlugin().getAddonsManager().getAddonByName("Level").map(l -> ((Level)l).getIslandLevel(this.getWorld(), island.getOwner()) >= (long)this.getPlugin().getSettings().getIslandPurgeLevel()).orElse(false);
        if (levelCheck) {
            return true;
        }
        return island.isPurgeProtected() || island.isSpawn() || !island.isOwned();
    }

    private List<Pair<Integer, Integer>> findOldRegions(int days) {
        ArrayList<Pair<Integer, Integer>> regions = new ArrayList<Pair<Integer, Integer>>();
        World world = this.getWorld();
        File worldDir = world.getWorldFolder();
        File overworldRegion = new File(worldDir, "region");
        File netherRegion = new File(worldDir, "DIM-1" + File.separator + "region");
        File endRegion = new File(worldDir, "DIM1" + File.separator + "region");
        long cutoffMillis = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(days);
        File[] files = overworldRegion.listFiles((dir, name) -> name.endsWith(".mca"));
        if (files == null) {
            return regions;
        }
        for (File owFile : files) {
            File endFile;
            File netherFile;
            int rz;
            int rx;
            String name2;
            String coordsPart;
            String[] parts;
            if (this.getRegionTimestamp(owFile) >= cutoffMillis || (parts = (coordsPart = (name2 = owFile.getName()).substring(2, name2.length() - 4)).split("\\.")).length != 2) continue;
            try {
                rx = Integer.parseInt(parts[0]);
                rz = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException ex) {
                continue;
            }
            boolean include = true;
            if (this.isNether && (!(netherFile = new File(netherRegion, name2)).exists() || this.getRegionTimestamp(netherFile) >= cutoffMillis)) {
                include = false;
            }
            if (this.isEnd && (!(endFile = new File(endRegion, name2)).exists() || this.getRegionTimestamp(endFile) >= cutoffMillis)) {
                include = false;
            }
            if (!include) continue;
            regions.add(new Pair<Integer, Integer>(rx, rz));
        }
        return regions;
    }

    private Map<Pair<Integer, Integer>, Set<String>> mapIslandsToRegions(List<Pair<Integer, Integer>> oldRegions, TreeMap<Integer, TreeMap<Integer, IslandGrid.IslandData>> grid) {
        int BLOCKS_PER_REGION = 512;
        HashMap<Pair<Integer, Integer>, Set<String>> regionToIslands = new HashMap<Pair<Integer, Integer>, Set<String>>();
        for (Pair<Integer, Integer> region : oldRegions) {
            int rX = region.x();
            int rZ = region.z();
            int regionMinX = rX * 512;
            int regionMinZ = rZ * 512;
            int regionMaxX = regionMinX + 512 - 1;
            int regionMaxZ = regionMinZ + 512 - 1;
            HashSet<String> ids = new HashSet<String>();
            for (Map.Entry<Integer, TreeMap<Integer, IslandGrid.IslandData>> xEntry : grid.entrySet()) {
                for (IslandGrid.IslandData data : xEntry.getValue().values()) {
                    int islandMinX = data.minX();
                    int islandMinZ = data.minZ();
                    int islandMaxX = islandMinX + 2 * data.range();
                    int islandMaxZ = islandMinZ + 2 * data.range();
                    boolean overlaps = islandMaxX >= regionMinX && islandMinX <= regionMaxX && islandMaxZ >= regionMinZ && islandMinZ <= regionMaxZ;
                    if (!overlaps) continue;
                    ids.add(data.id());
                }
            }
            regionToIslands.put(region, ids);
        }
        return regionToIslands;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getRegionTimestamp(File regionFile) {
        if (!regionFile.exists()) return 0L;
        if (regionFile.length() < 8192L) {
            return 0L;
        }
        try (FileInputStream fis = new FileInputStream(regionFile);){
            byte[] buffer = new byte[4096];
            if (fis.skip(4096L) != 4096L) {
                long l = 0L;
                return l;
            }
            if (fis.read(buffer) != 4096) {
                long l = 0L;
                return l;
            }
            ByteBuffer bb = ByteBuffer.wrap(buffer);
            bb.order(ByteOrder.BIG_ENDIAN);
            long maxTimestampSeconds = 0L;
            for (int i = 0; i < 1024; ++i) {
                long timestamp = Integer.toUnsignedLong(bb.getInt());
                if (timestamp <= maxTimestampSeconds) continue;
                maxTimestampSeconds = timestamp;
            }
            long l = maxTimestampSeconds * 1000L;
            return l;
        }
        catch (IOException e) {
            this.getPlugin().logError("Failed to read region file timestamps: " + regionFile.getAbsolutePath() + " " + e.getMessage());
            return 0L;
        }
    }
}

