/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.team;

import java.util.List;
import java.util.UUID;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.events.team.TeamEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.IslandInfo;
import world.bentobox.bentobox.util.Util;

public class AdminTeamAddCommand
extends CompositeCommand {
    public AdminTeamAddCommand(CompositeCommand parent) {
        super(parent, "add", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("mod.team.add");
        this.setParametersHelp("commands.admin.team.add.parameters");
        this.setDescription("commands.admin.team.add.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.size() != 2) {
            this.showHelp(this, user);
            return false;
        }
        UUID ownerUUID = Util.getUUID(args.getFirst());
        if (ownerUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        UUID targetUUID = Util.getUUID(args.get(1));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(1));
            return false;
        }
        Island island = this.getIslands().getPrimaryIsland(this.getWorld(), ownerUUID);
        if (island == null || !this.getIslands().hasIsland(this.getWorld(), ownerUUID)) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        if (this.getIslands().inTeam(this.getWorld(), ownerUUID) && !ownerUUID.equals(island.getOwner())) {
            user.sendMessage("commands.admin.team.add.name-not-owner", "[name]", args.getFirst());
            new IslandInfo(island).showMembers(user);
            return false;
        }
        if (this.getIWM().getWorldSettings(this.getWorld()).isDisallowTeamMemberIslands() && island.inTeam(targetUUID)) {
            user.sendMessage("commands.island.team.invite.errors.already-on-team", new String[0]);
            return false;
        }
        if (this.getIslands().hasIsland(this.getWorld(), targetUUID)) {
            user.sendMessage("commands.admin.team.add.name-has-island", "[name]", args.get(1));
            return false;
        }
        User target = User.getInstance(targetUUID);
        User owner = User.getInstance(ownerUUID);
        owner.sendMessage("commands.island.team.invite.accept.name-joined-your-island", "[name]", this.getPlugin().getPlayers().getName(targetUUID));
        target.sendMessage("commands.island.team.invite.accept.you-joined-island", "[label]", this.getTopLabel());
        Island teamIsland = this.getIslands().getIsland(this.getWorld(), ownerUUID);
        if (teamIsland != null) {
            this.getIslands().setJoinTeam(teamIsland, targetUUID);
            user.sendMessage("commands.admin.team.add.success", "[name]", target.getName(), "[owner]", owner.getName());
            TeamEvent.builder().island(teamIsland).reason(TeamEvent.Reason.JOINED).involvedPlayer(targetUUID).admin(true).build();
            IslandEvent.builder().island(teamIsland).involvedPlayer(targetUUID).admin(true).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(teamIsland.getRank(target), 500).build();
            return true;
        }
        user.sendMessage("general.errors.player-has-no-island", new String[0]);
        return false;
    }
}

