/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.List;
import java.util.Objects;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;

public class IslandResetnameCommand
extends CompositeCommand {
    public IslandResetnameCommand(CompositeCommand islandCommand) {
        super(islandCommand, "resetname", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.name");
        this.setOnlyPlayer(true);
        this.setDescription("commands.island.resetname.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        if (island == null) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        int rank = Objects.requireNonNull(island).getRank(user);
        if (rank < island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        Objects.requireNonNull(this.getIslands().getIsland(this.getWorld(), user)).setName(null);
        user.sendMessage("commands.island.resetname.success", new String[0]);
        return true;
    }
}

