/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island.team;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamCoopCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamGUI;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamInviteAcceptCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamInviteCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamInviteRejectCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamKickCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamLeaveCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamPromoteCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamSetownerCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamTrustCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamUncoopCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamUntrustCommand;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.team.TeamEvent;
import world.bentobox.bentobox.api.panels.reader.PanelTemplateRecord;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.database.objects.TeamInvite;
import world.bentobox.bentobox.managers.RanksManager;

public class IslandTeamCommand
extends CompositeCommand {
    private IslandTeamKickCommand kickCommand;
    private IslandTeamLeaveCommand leaveCommand;
    private IslandTeamSetownerCommand setOwnerCommand;
    private IslandTeamUncoopCommand uncoopCommand;
    private IslandTeamUntrustCommand unTrustCommand;
    private IslandTeamCoopCommand coopCommand;
    private IslandTeamTrustCommand trustCommand;
    private IslandTeamInviteAcceptCommand acceptCommand;
    private IslandTeamInviteRejectCommand rejectCommand;
    private IslandTeamInviteCommand inviteCommand;
    private @Nullable PanelTemplateRecord.TemplateItem border;
    private @Nullable PanelTemplateRecord.TemplateItem background;
    private final Database<TeamInvite> handler;

    public IslandTeamCommand(CompositeCommand parent) {
        super(parent, "team", new String[0]);
        this.handler = new Database<TeamInvite>((Addon)parent.getAddon(), TeamInvite.class);
    }

    @Override
    public void setup() {
        this.setPermission("island.team");
        this.setOnlyPlayer(true);
        this.setDescription("commands.island.team.description");
        this.inviteCommand = new IslandTeamInviteCommand(this);
        this.leaveCommand = new IslandTeamLeaveCommand(this);
        this.setOwnerCommand = new IslandTeamSetownerCommand(this);
        this.kickCommand = new IslandTeamKickCommand(this);
        this.acceptCommand = new IslandTeamInviteAcceptCommand(this);
        this.rejectCommand = new IslandTeamInviteRejectCommand(this);
        if (RanksManager.getInstance().rankExists("ranks.coop")) {
            this.coopCommand = new IslandTeamCoopCommand(this);
            this.uncoopCommand = new IslandTeamUncoopCommand(this);
        }
        if (RanksManager.getInstance().rankExists("ranks.trusted")) {
            this.trustCommand = new IslandTeamTrustCommand(this);
            this.unTrustCommand = new IslandTeamUntrustCommand(this);
        }
        new IslandTeamPromoteCommand(this, "promote");
        new IslandTeamPromoteCommand(this, "demote");
        if (!new File(String.valueOf(this.getPlugin().getDataFolder()) + File.separator + "panels", "team_panel.yml").exists()) {
            this.getPlugin().saveResource("panels/team_panel.yml", false);
        }
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        Island island = this.getIslands().getPrimaryIsland(this.getWorld(), user.getUniqueId());
        if (island == null) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        UUID playerUUID = user.getUniqueId();
        if (this.fireEvent(user, island)) {
            return false;
        }
        Set<UUID> teamMembers = this.getMembers(this.getWorld(), user);
        if (playerUUID.equals(island.getOwner())) {
            int maxSize = this.getIslands().getMaxMembers(island, 500);
            if (teamMembers.size() < maxSize) {
                user.sendMessage("commands.island.team.invite.you-can-invite", "[number]", String.valueOf(maxSize - teamMembers.size()));
            } else {
                user.sendMessage("commands.island.team.invite.errors.island-is-full", new String[0]);
            }
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        new IslandTeamGUI(this.getPlugin(), this, user, this.getIslands().getPrimaryIsland(this.getWorld(), user.getUniqueId())).build();
        return true;
    }

    private boolean fireEvent(User user, Island island) {
        IslandBaseEvent e = TeamEvent.builder().island(island).reason(TeamEvent.Reason.INFO).involvedPlayer(user.getUniqueId()).build();
        return e.getNewEvent().map(IslandBaseEvent::isCancelled).orElse(e.isCancelled());
    }

    public void addInvite(TeamInvite.Type type, @NonNull UUID inviter, @NonNull UUID invitee, @NonNull Island island) {
        this.handler.saveObjectAsync(new TeamInvite(type, inviter, invitee, island.getUniqueId()));
    }

    public boolean isInvited(@NonNull UUID invitee) {
        boolean valid = false;
        if (this.handler.objectExists(invitee.toString())) {
            @Nullable TeamInvite invite = this.getInvite(invitee);
            valid = this.getIslands().getIslandById(invite.getIslandID()).map(island -> island.isOwned() && !island.isDeleted() && !island.isDeletable() && island.getMemberSet().contains((Object)invite.getInviter())).orElse(false);
            if (!valid) {
                this.handler.deleteObject(invite);
            }
        }
        return valid;
    }

    public @Nullable UUID getInviter(UUID invitee) {
        return this.isInvited(invitee) ? this.handler.loadObject(invitee.toString()).getInviter() : null;
    }

    public @Nullable TeamInvite getInvite(UUID invitee) {
        return this.handler.loadObject(invitee.toString());
    }

    public void removeInvite(@NonNull UUID invitee) {
        this.handler.deleteID(invitee.toString());
    }

    protected IslandTeamCoopCommand getCoopCommand() {
        return this.coopCommand;
    }

    protected IslandTeamTrustCommand getTrustCommand() {
        return this.trustCommand;
    }

    public IslandTeamInviteCommand getInviteCommand() {
        return this.inviteCommand;
    }

    public IslandTeamInviteAcceptCommand getAcceptCommand() {
        return this.acceptCommand;
    }

    public IslandTeamInviteRejectCommand getRejectCommand() {
        return this.rejectCommand;
    }

    public IslandTeamKickCommand getKickCommand() {
        return this.kickCommand;
    }

    public IslandTeamLeaveCommand getLeaveCommand() {
        return this.leaveCommand;
    }

    public IslandTeamSetownerCommand getSetOwnerCommand() {
        return this.setOwnerCommand;
    }

    public IslandTeamUncoopCommand getUncoopCommand() {
        return this.uncoopCommand;
    }

    public IslandTeamUntrustCommand getUnTrustCommand() {
        return this.unTrustCommand;
    }
}

