/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island.team;

import java.util.List;
import java.util.UUID;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.events.team.TeamEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class IslandTeamLeaveCommand
extends ConfirmableCommand {
    public IslandTeamLeaveCommand(CompositeCommand islandTeamCommand) {
        super(islandTeamCommand, "leave", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.team.leave");
        this.setOnlyPlayer(true);
        this.setDescription("commands.island.team.leave.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (!this.getIslands().inTeam(this.getWorld(), user.getUniqueId())) {
            user.sendMessage("general.errors.no-team", new String[0]);
            return false;
        }
        if (user.getUniqueId().equals(this.getIslands().getPrimaryIsland(this.getWorld(), user.getUniqueId()).getOwner())) {
            user.sendMessage("commands.island.team.leave.cannot-leave", new String[0]);
            return false;
        }
        if (!this.getSettings().isLeaveConfirmation()) {
            this.leave(user);
            return true;
        }
        if (this.getIWM().isLeaversLoseReset(this.getWorld())) {
            this.showResets(user);
        }
        this.askConfirmation(user, () -> this.leave(user));
        return false;
    }

    private void showResets(User user) {
        int resetsLeft = this.getPlayers().getResetsLeft(this.getWorld(), user.getUniqueId());
        if (resetsLeft != -1) {
            if (resetsLeft == 0) {
                user.sendMessage("commands.island.reset.none-left", new String[0]);
            } else {
                user.sendMessage("commands.island.reset.resets-left", "[number]", String.valueOf(resetsLeft));
            }
        }
    }

    protected boolean leave(User user) {
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        if (island == null) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        IslandBaseEvent event = TeamEvent.builder().island(island).reason(TeamEvent.Reason.LEAVE).involvedPlayer(user.getUniqueId()).build();
        if (event.isCancelled()) {
            return false;
        }
        UUID ownerUUID = island.getOwner();
        if (ownerUUID != null) {
            User.getInstance(ownerUUID).sendMessage("commands.island.team.leave.left-your-island", "[name]", user.getName(), "[display_name]", user.getDisplayName());
        }
        this.getIslands().removePlayer(island, user.getUniqueId());
        this.getPlayers().cleanLeavingPlayer(this.getWorld(), user, false, island);
        if (this.getSettings().getInviteCooldown() > 0 && this.getParent() != null) {
            this.getParent().getSubCommand("invite").ifPresent(c -> c.setCooldown(island.getUniqueId(), user.getUniqueId().toString(), this.getSettings().getInviteCooldown() * 60));
        }
        if (this.getIWM().isLeaversLoseReset(this.getWorld())) {
            this.getPlayers().addReset(this.getWorld(), user.getUniqueId());
            this.showResets(user);
        }
        user.sendMessage("commands.island.team.leave.success", new String[0]);
        IslandEvent.builder().island(island).involvedPlayer(user.getUniqueId()).admin(false).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(island.getRank(user), 0).build();
        return true;
    }
}

