/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.entity.EntityType;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.configuration.ConfigObject;
import world.bentobox.bentobox.api.flags.Flag;

public interface WorldSettings
extends ConfigObject {
    public GameMode getDefaultGameMode();

    @Deprecated(since="1.21.0", forRemoval=true)
    public Map<Flag, Integer> getDefaultIslandFlags();

    default public Map<String, Integer> getDefaultIslandFlagNames() {
        HashMap<String, Integer> flags = new HashMap<String, Integer>();
        this.getDefaultIslandFlags().forEach((key, value) -> flags.put(key.getID(), (Integer)value));
        return flags;
    }

    @Deprecated(since="1.21.0", forRemoval=true)
    public Map<Flag, Integer> getDefaultIslandSettings();

    default public Map<String, Integer> getDefaultIslandSettingNames() {
        HashMap<String, Integer> flags = new HashMap<String, Integer>();
        this.getDefaultIslandSettings().forEach((key, value) -> flags.put(key.getID(), (Integer)value));
        return flags;
    }

    public Difficulty getDifficulty();

    public void setDifficulty(Difficulty var1);

    public String getFriendlyName();

    public int getIslandDistance();

    public int getIslandHeight();

    public int getIslandProtectionRange();

    public int getIslandStartX();

    public int getIslandStartZ();

    public int getIslandXOffset();

    public int getIslandZOffset();

    public List<String> getIvSettings();

    public int getMaxHomes();

    public int getMaxIslands();

    public int getMaxTeamSize();

    default public int getMaxCoopSize() {
        return 4;
    }

    default public int getMaxTrustSize() {
        return 4;
    }

    public int getNetherSpawnRadius();

    public String getPermissionPrefix();

    public Set<EntityType> getRemoveMobsWhitelist();

    public int getSeaHeight();

    public List<String> getHiddenFlags();

    public List<String> getVisitorBannedCommands();

    default public List<String> getFallingBannedCommands() {
        return Collections.emptyList();
    }

    public Map<String, Boolean> getWorldFlags();

    public String getWorldName();

    public boolean isDragonSpawn();

    public boolean isEndGenerate();

    public boolean isEndIslands();

    public boolean isNetherGenerate();

    public boolean isNetherIslands();

    public boolean isOnJoinResetEnderChest();

    public boolean isOnJoinResetInventory();

    public boolean isOnJoinResetMoney();

    public boolean isOnJoinResetHealth();

    public boolean isOnJoinResetHunger();

    public boolean isOnJoinResetXP();

    public @NonNull List<String> getOnJoinCommands();

    public boolean isOnLeaveResetEnderChest();

    public boolean isOnLeaveResetInventory();

    public boolean isOnLeaveResetMoney();

    public boolean isOnLeaveResetHealth();

    public boolean isOnLeaveResetHunger();

    public boolean isOnLeaveResetXP();

    public @NonNull List<String> getOnLeaveCommands();

    default public @NonNull List<String> getOnRespawnCommands() {
        return Collections.emptyList();
    }

    public boolean isUseOwnGenerator();

    public boolean isWaterUnsafe();

    public List<String> getGeoLimitSettings();

    default public List<String> getMobLimitSettings() {
        return new ArrayList<String>();
    }

    public int getResetLimit();

    public long getResetEpoch();

    public void setResetEpoch(long var1);

    public boolean isTeamJoinDeathReset();

    public int getDeathsMax();

    public boolean isDeathsCounted();

    public boolean isDeathsResetOnNewIsland();

    public boolean isAllowSetHomeInNether();

    public boolean isAllowSetHomeInTheEnd();

    public boolean isRequireConfirmationToSetHomeInNether();

    public boolean isRequireConfirmationToSetHomeInTheEnd();

    public int getBanLimit();

    public boolean isLeaversLoseReset();

    public boolean isKickedKeepInventory();

    public boolean isCreateIslandOnFirstLoginEnabled();

    public int getCreateIslandOnFirstLoginDelay();

    public boolean isCreateIslandOnFirstLoginAbortOnLogout();

    default public boolean isPasteMissingIslands() {
        return true;
    }

    default public boolean isTeleportPlayerToIslandUponIslandCreation() {
        return true;
    }

    default public String getAdminCommandAliases() {
        return this.getFriendlyName().toLowerCase(Locale.ENGLISH) + "admin";
    }

    default public String getPlayerCommandAliases() {
        return this.getFriendlyName().toLowerCase(Locale.ENGLISH);
    }

    default public String getDefaultPlayerAction() {
        return "go";
    }

    default public String getDefaultNewPlayerAction() {
        return "create";
    }

    default public boolean isMakeNetherPortals() {
        return false;
    }

    default public boolean isMakeEndPortals() {
        return false;
    }

    default public boolean isCheckForBlocks() {
        return true;
    }

    default public int getConcurrentIslands() {
        return BentoBox.getInstance().getSettings().getIslandNumber();
    }

    default public boolean isDisallowTeamMemberIslands() {
        return true;
    }
}

