/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.flags.clicklisteners;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.events.flags.FlagSettingChangeEvent;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.TabbedPanel;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.panels.settings.SettingsTab;
import world.bentobox.bentobox.util.Util;

public class IslandToggleClick
implements PanelItem.ClickHandler {
    private final BentoBox plugin = BentoBox.getInstance();
    private final String id;

    public IslandToggleClick(String id) {
        this.id = id;
    }

    @Override
    public boolean onClick(Panel panel, User user, ClickType click, int slot) {
        TabbedPanel tp = (TabbedPanel)panel;
        SettingsTab st = (SettingsTab)tp.getActiveTab();
        String prefix = this.plugin.getIWM().getPermissionPrefix(Util.getWorld(user.getWorld()));
        String reqPerm = prefix + "settings." + this.id;
        String allPerms = prefix + "settings.*";
        if (!(user.hasPermission(reqPerm) || user.hasPermission(allPerms) || user.isOp() || user.hasPermission(prefix + "admin.settings"))) {
            user.sendMessage("general.errors.no-permission", "[permission]", reqPerm);
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
            return true;
        }
        Island island = st.getIsland();
        if (island != null && (user.isOp() || island.isAllowed(user, Flags.CHANGE_SETTINGS) || user.hasPermission(prefix + "admin.settings"))) {
            this.plugin.getFlagsManager().getFlag(this.id).ifPresent(flag -> {
                if (click.equals((Object)ClickType.SHIFT_LEFT) && user.isOp()) {
                    this.shiftLeftClick(user, (Flag)flag);
                } else {
                    if (!user.isOp() && island.isCooldown((Flag)flag)) {
                        user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 1.0f);
                        user.notify("protection.panel.flag-item.setting-cooldown", new String[0]);
                        return;
                    }
                    this.toggleFlag(user, (Flag)flag, island);
                }
            });
        } else {
            this.reportError(user, island);
        }
        return true;
    }

    private void toggleFlag(User user, Flag flag, Island island) {
        island.toggleFlag(flag);
        user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
        island.setCooldown(flag);
        Bukkit.getPluginManager().callEvent((Event)new FlagSettingChangeEvent(island, user.getUniqueId(), flag, island.isAllowed(flag)));
        if (flag.hasSubflags()) {
            flag.getSubflags().forEach(subflag -> Bukkit.getPluginManager().callEvent((Event)new FlagSettingChangeEvent(island, user.getUniqueId(), (Flag)subflag, island.isAllowed((Flag)subflag))));
        }
    }

    private void reportError(User user, Island island) {
        if (island == null) {
            user.sendMessage("general.errors.not-on-island", new String[0]);
        } else {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(Objects.requireNonNull(island).getRank(user)), new String[0]));
        }
        user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
    }

    private void shiftLeftClick(User user, Flag flag) {
        if (!this.plugin.getIWM().getHiddenFlags(user.getWorld()).contains(flag.getID())) {
            this.plugin.getIWM().getHiddenFlags(user.getWorld()).add(flag.getID());
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
        } else {
            this.plugin.getIWM().getHiddenFlags(user.getWorld()).remove(flag.getID());
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.0f);
        }
        this.plugin.getIWM().getAddon(user.getWorld()).ifPresent(GameModeAddon::saveWorldSettings);
    }
}

