/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.github;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import world.bentobox.bentobox.api.github.objects.repositories.GitHubRepository;

public class GitHubWebAPI {
    private static final String API_BASE_URL = "https://api.github.com/";
    private static final long RATE_LIMIT_INTERVAL_MS = 1000L;
    private static long lastRequestTime = 0L;
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public synchronized JsonObject fetch(String endpoint) throws IOException, URISyntaxException {
        long currentTime = System.currentTimeMillis();
        long timeSinceLastRequest = currentTime - lastRequestTime;
        if (timeSinceLastRequest < 1000L) {
            try {
                Thread.sleep(1000L - timeSinceLastRequest);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread interrupted while waiting for rate limit", e);
            }
        }
        lastRequestTime = System.currentTimeMillis();
        URL url = new URI(API_BASE_URL + endpoint).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
        connection.setRequestProperty("User-Agent", "BentoBox");
        int responseCode = connection.getResponseCode();
        if (responseCode == 403) {
            throw new IOException("GitHub API rate limit exceeded or access forbidden. Response code: " + responseCode);
        }
        try (Scanner scanner = new Scanner(connection.getInputStream());){
            String response = scanner.useDelimiter("\\A").next();
            JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
            return jsonObject;
        }
    }

    public CompletableFuture<JsonObject> fetchAsync(String endpoint) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.fetch(endpoint);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException("Failed to fetch data from GitHub API", e);
            }
        }, this.executor);
    }

    public GitHubRepository getRepository(String username, String repo) {
        return new GitHubRepository(this, username + "/" + repo);
    }
}

