/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.panels.builders;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.bukkit.World;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.PanelListener;
import world.bentobox.bentobox.api.panels.TemplatedPanel;
import world.bentobox.bentobox.api.panels.reader.ItemTemplateRecord;
import world.bentobox.bentobox.api.panels.reader.PanelTemplateRecord;
import world.bentobox.bentobox.api.panels.reader.TemplateReader;
import world.bentobox.bentobox.api.user.User;

public class TemplatedPanelBuilder {
    private PanelTemplateRecord panelTemplate;
    private User user;
    private World world;
    private PanelListener listener;
    private final List<String> parameters = new ArrayList<String>(0);
    private final Map<String, BiFunction<ItemTemplateRecord, TemplatedPanel.ItemSlot, PanelItem>> objectCreatorMap = new HashMap<String, BiFunction<ItemTemplateRecord, TemplatedPanel.ItemSlot, PanelItem>>();

    public TemplatedPanelBuilder template(String guiName, File dataFolder) {
        this.panelTemplate = TemplateReader.readTemplatePanel(guiName, dataFolder);
        return this;
    }

    public TemplatedPanelBuilder template(String panelName, String templateName, File dataFolder) {
        this.panelTemplate = TemplateReader.readTemplatePanel(panelName, templateName, dataFolder);
        return this;
    }

    public TemplatedPanelBuilder user(User user) {
        this.user = user;
        return this;
    }

    public TemplatedPanelBuilder world(World world) {
        this.world = world;
        return this;
    }

    public TemplatedPanelBuilder parameters(String ... parameters) {
        if (parameters.length > 0) {
            this.parameters.addAll(Arrays.stream(parameters).toList());
        }
        return this;
    }

    public TemplatedPanelBuilder listener(PanelListener listener) {
        this.listener = listener;
        return this;
    }

    public TemplatedPanelBuilder registerTypeBuilder(String type, BiFunction<ItemTemplateRecord, TemplatedPanel.ItemSlot, PanelItem> buttonCreator) {
        this.objectCreatorMap.put(type, buttonCreator);
        return this;
    }

    public TemplatedPanel build() {
        return new TemplatedPanel(this);
    }

    public PanelTemplateRecord getPanelTemplate() {
        return this.panelTemplate;
    }

    public User getUser() {
        return this.user;
    }

    public World getWorld() {
        return this.world;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public PanelListener getListener() {
        return this.listener;
    }

    public Map<String, BiFunction<ItemTemplateRecord, TemplatedPanel.ItemSlot, PanelItem>> getObjectCreatorMap() {
        return this.objectCreatorMap;
    }
}

