/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.json;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.DatabaseConnector;
import world.bentobox.bentobox.database.json.AbstractJSONDatabaseHandler;
import world.bentobox.bentobox.database.objects.DataObject;

public class JSONDatabaseHandler<T>
extends AbstractJSONDatabaseHandler<T> {
    private static final String JSON = ".json";

    JSONDatabaseHandler(BentoBox plugin, Class<T> type, DatabaseConnector databaseConnector) {
        super(plugin, type, databaseConnector);
    }

    @Override
    public List<T> loadObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        String path = this.dataObject.getSimpleName();
        File dataFolder = new File(this.plugin.getDataFolder(), "database");
        File tableFolder = new File(dataFolder, path);
        if (!tableFolder.exists()) {
            tableFolder.mkdirs();
        }
        for (File file : Objects.requireNonNull(tableFolder.listFiles((dir, name) -> name.toLowerCase(Locale.ENGLISH).endsWith(JSON) && !name.startsWith("._")))) {
            try (FileReader reader = new FileReader(file);){
                Object object = this.getGson().fromJson((Reader)reader, this.dataObject);
                if (object != null) {
                    list.add(object);
                    continue;
                }
                this.plugin.logError("JSON file created a null object: " + file.getPath());
                reader.close();
            }
            catch (FileNotFoundException e) {
                this.plugin.logError("Could not load file '" + file.getName() + "': File not found.");
            }
            catch (Exception e) {
                this.plugin.logError("Could not load objects " + file.getName() + " " + e.getMessage());
            }
        }
        return list;
    }

    @Override
    public T loadObject(@NonNull String uniqueId) {
        String path = "database" + File.separator + this.dataObject.getSimpleName();
        String fileName = path + File.separator + uniqueId;
        if (!fileName.endsWith(JSON)) {
            fileName = fileName + JSON;
        }
        Object result = null;
        try (FileReader reader = new FileReader(new File(this.plugin.getDataFolder(), fileName));){
            result = this.getGson().fromJson((Reader)reader, this.dataObject);
        }
        catch (FileNotFoundException e) {
            this.plugin.logError("Could not load file '" + fileName + "': File not found.");
        }
        catch (Exception e) {
            this.plugin.logError("Could not load objects " + fileName + " " + e.getMessage());
        }
        return (T)result;
    }

    @Override
    public CompletableFuture<Boolean> saveObject(T instance) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        File backupTableFolder;
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        if (instance == null) {
            this.plugin.logError("JSON database request to store a null. ");
            completableFuture.complete(false);
            return completableFuture;
        }
        if (!(instance instanceof DataObject)) {
            this.plugin.logError("This class is not a DataObject: " + instance.getClass().getName());
            completableFuture.complete(false);
            return completableFuture;
        }
        String path = "database" + File.separator + this.dataObject.getSimpleName();
        String backupPath = "database_backup" + File.separator + this.dataObject.getSimpleName();
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor("uniqueId", this.dataObject);
        Method method = propertyDescriptor.getReadMethod();
        String fileName = String.valueOf(method.invoke(instance, new Object[0])) + JSON;
        File tableFolder = new File(this.plugin.getDataFolder(), path);
        File file = new File(tableFolder, fileName);
        if (!tableFolder.exists()) {
            tableFolder.mkdirs();
        }
        if (!(backupTableFolder = new File(this.plugin.getDataFolder(), backupPath)).exists()) {
            backupTableFolder.mkdirs();
        }
        String toStore = this.getGson().toJson(instance);
        if (this.plugin.isEnabled()) {
            this.processQueue.add(() -> this.store(completableFuture, toStore, file, tableFolder, backupTableFolder, fileName, true));
        } else {
            this.store(completableFuture, toStore, file, tableFolder, backupTableFolder, fileName, false);
        }
        return completableFuture;
    }

    private void store(CompletableFuture<Boolean> completableFuture, String toStore, File file, File tableFolder, File backupTableFolder, String fileName, boolean async) {
        if (async && !this.plugin.isEnabled()) {
            return;
        }
        File tmpFile = new File(backupTableFolder, fileName);
        if (file.exists()) {
            try {
                Files.copy(file.toPath(), tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.plugin.logError("Could not backup JSON file: " + tableFolder.getName() + " " + fileName + " " + e.getMessage());
            }
        }
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(toStore);
            completableFuture.complete(true);
        }
        catch (IOException e) {
            this.plugin.logError("Could not save JSON file: " + tableFolder.getName() + " " + fileName + " " + e.getMessage());
            completableFuture.complete(false);
        }
    }

    @Override
    public void deleteID(String uniqueId) {
        if (this.plugin.isEnabled()) {
            this.processQueue.add(() -> this.delete(uniqueId));
        } else {
            this.delete(uniqueId);
        }
    }

    private void delete(String uniqueId) {
        File dataFolder;
        File tableFolder;
        if (!((String)uniqueId).endsWith(JSON)) {
            uniqueId = (String)uniqueId + JSON;
        }
        if ((tableFolder = new File(dataFolder = new File(this.plugin.getDataFolder(), "database"), this.dataObject.getSimpleName())).exists()) {
            File file = new File(tableFolder, (String)uniqueId);
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (IOException e) {
                this.plugin.logError("Could not delete JSON database object! " + file.getName() + " - " + e.getMessage());
            }
        }
    }

    @Override
    public void deleteObject(T instance) {
        if (instance == null) {
            this.plugin.logError("JSON database request to delete a null.");
            return;
        }
        if (!(instance instanceof DataObject)) {
            this.plugin.logError("This class is not a DataObject: " + instance.getClass().getName());
            return;
        }
        try {
            Method getUniqueId = this.dataObject.getMethod("getUniqueId", new Class[0]);
            this.deleteID((String)getUniqueId.invoke(instance, new Object[0]));
        }
        catch (Exception e) {
            this.plugin.logError("Could not delete object " + instance.getClass().getName() + " " + e.getMessage());
        }
    }

    @Override
    public boolean objectExists(String uniqueId) {
        return this.databaseConnector.uniqueIdExists(this.dataObject.getSimpleName(), uniqueId);
    }

    @Override
    public void close() {
        this.shutdown = true;
    }
}

