/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.json.adapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import world.bentobox.bentobox.util.Pair;

public class PairTypeAdapter<X, Z>
extends TypeAdapter<Pair<X, Z>> {
    private final Type xType;
    private final Type zType;

    public PairTypeAdapter(Type xType, Type zType) {
        this.xType = xType;
        this.zType = zType;
    }

    public void write(JsonWriter out, Pair<X, Z> pair) throws IOException {
        out.beginObject();
        out.name("x");
        Gson gson = new Gson();
        gson.toJson(pair.getKey(), this.xType, out);
        out.name("z");
        gson.toJson(pair.getValue(), this.zType, out);
        out.endObject();
    }

    public Pair<X, Z> read(JsonReader in) throws IOException {
        Object x = null;
        Object z = null;
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (name.equals("x")) {
                x = new Gson().fromJson(in, this.xType);
                continue;
            }
            if (!name.equals("z")) continue;
            z = new Gson().fromJson(in, this.zType);
        }
        in.endObject();
        return new Pair<Object, Object>(x, z);
    }
}

