/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.objects;

import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.Expose;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.logs.LogEntry;
import world.bentobox.bentobox.api.metadata.MetaDataAble;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.BonusRangeRecord;
import world.bentobox.bentobox.database.objects.DataObject;
import world.bentobox.bentobox.database.objects.Table;
import world.bentobox.bentobox.database.objects.adapters.Adapter;
import world.bentobox.bentobox.database.objects.adapters.LogEntryListAdapter;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.managers.IslandsManager;
import world.bentobox.bentobox.util.Pair;
import world.bentobox.bentobox.util.Util;

@Table(name="Islands")
public class Island
implements DataObject,
MetaDataAble {
    @Expose
    private Set<UUID> primaries = new HashSet<UUID>();
    private boolean changed;
    @Expose
    @Deprecated(since="3.7.4", forRemoval=true)
    private boolean deleted = false;
    @Expose
    private boolean deletable = false;
    @Expose
    private @NonNull String uniqueId = UUID.randomUUID().toString();
    @Expose
    private Location center;
    @Expose
    private @Nullable Location location;
    @Expose
    private int range;
    @Expose
    private int protectionRange;
    @Expose
    private List<BonusRangeRecord> bonusRanges = new ArrayList<BonusRangeRecord>();
    @Expose
    private int maxEverProtectionRange;
    @Expose
    private World world;
    @Expose
    private String gameMode;
    @Expose
    private @Nullable String name;
    @Expose
    private long createdDate;
    @Expose
    private long updatedDate;
    @Expose
    private @Nullable UUID owner;
    @Expose
    private Map<UUID, Integer> members = new HashMap<UUID, Integer>();
    @Expose
    private Map<Integer, Integer> maxMembers;
    @Expose
    private boolean spawn = false;
    @Expose
    private boolean purgeProtected = false;
    @Expose
    private Map<String, Integer> flags = new HashMap<String, Integer>();
    @Adapter(value=LogEntryListAdapter.class)
    @Expose
    private List<LogEntry> history = new LinkedList<LogEntry>();
    @Expose
    private Map<World.Environment, Location> spawnPoint = new EnumMap<World.Environment, Location>(World.Environment.class);
    @Expose
    private boolean doNotLoad;
    @Expose
    private Map<String, Long> cooldowns = new HashMap<String, Long>();
    @Expose
    private Map<String, Integer> commandRanks;
    @Expose
    private @Nullable Boolean reserved = null;
    @Expose
    private Map<String, MetaDataValue> metaData;
    @Expose
    private Map<String, Location> homes;
    @Expose
    private Integer maxHomes;

    public Island() {
    }

    public Island(@NonNull Location location, UUID owner, int protectionRange) {
        this.setOwner(owner);
        this.createdDate = System.currentTimeMillis();
        this.updatedDate = System.currentTimeMillis();
        this.world = location.getWorld();
        this.center = new Location(location.getWorld(), location.getX(), location.getY(), location.getZ());
        this.range = BentoBox.getInstance().getIWM().getIslandDistance(this.world);
        this.protectionRange = protectionRange;
        this.maxEverProtectionRange = protectionRange;
    }

    public Island(Island island) {
        this.center = island.getCenter().clone();
        this.createdDate = island.getCreatedDate();
        Optional.ofNullable(island.getCommandRanks()).ifPresent(cr -> {
            this.commandRanks = new HashMap<String, Integer>();
            this.commandRanks.putAll((Map<String, Integer>)cr);
        });
        Optional.ofNullable(island.getCooldowns()).ifPresent(c -> {
            this.cooldowns = new HashMap<String, Long>();
            this.cooldowns.putAll((Map<String, Long>)c);
        });
        this.createdDate = island.getCreatedDate();
        this.deleted = island.isDeleted();
        this.deletable = island.isDeletable();
        this.doNotLoad = island.isDoNotLoad();
        this.flags.putAll(island.getFlags());
        this.gameMode = island.getGameMode();
        this.homes = new HashMap<String, Location>(island.getHomes());
        this.history.addAll(island.getHistory());
        this.location = island.getProtectionCenter();
        this.maxEverProtectionRange = island.getMaxEverProtectionRange();
        this.maxHomes = island.getMaxHomes();
        this.maxMembers = new HashMap<Integer, Integer>(island.getMaxMembers());
        this.members.putAll(island.getMembers());
        island.getMetaData().ifPresent(m -> {
            this.metaData = new HashMap<String, MetaDataValue>();
            this.metaData.putAll((Map<String, MetaDataValue>)m);
        });
        this.name = island.getName();
        this.owner = island.getOwner();
        this.protectionRange = island.getProtectionRange();
        this.purgeProtected = island.isPurgeProtected();
        this.range = island.getRange();
        this.reserved = island.isReserved();
        this.spawn = island.isSpawn();
        island.getSpawnPoint().forEach((k, v) -> island.spawnPoint.put((World.Environment)k, v.clone()));
        this.uniqueId = island.getUniqueId();
        this.updatedDate = island.getUpdatedDate();
        this.world = island.getWorld();
        this.bonusRanges.addAll(island.getBonusRanges());
        this.primaries.addAll(island.getPrimaries());
        this.setChanged();
    }

    public void addMember(@NonNull UUID playerUUID) {
        if (this.getRank(playerUUID) != 500) {
            this.setRank(playerUUID, 500);
            this.setChanged();
        }
    }

    public boolean ban(@NonNull UUID issuer, @NonNull UUID target) {
        if (this.getRank(target) != -1) {
            this.setRank(target, -1);
            this.log(new LogEntry.Builder(LogEntry.LogType.BAN).data("player", target.toString()).data("issuer", issuer.toString()).build());
            this.setChanged();
        }
        return true;
    }

    public Set<UUID> getBanned() {
        HashSet<UUID> result = new HashSet<UUID>();
        for (Map.Entry<UUID, Integer> member : this.members.entrySet()) {
            if (member.getValue() > -1) continue;
            result.add(member.getKey());
        }
        return result;
    }

    public boolean unban(@NonNull UUID issuer, @NonNull UUID target) {
        if (this.members.remove(target) != null) {
            this.log(new LogEntry.Builder(LogEntry.LogType.UNBAN).data("player", target.toString()).data("issuer", issuer.toString()).build());
            return true;
        }
        return false;
    }

    public @NonNull Location getCenter() {
        return Objects.requireNonNull(this.center, "Island getCenter requires a non-null center").clone();
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public int getFlag(@NonNull Flag flag) {
        return this.flags.computeIfAbsent(flag.getID(), k -> flag.getDefaultRank());
    }

    public Map<String, Integer> getFlags() {
        return this.flags;
    }

    public Map<UUID, Integer> getMembers() {
        return this.members;
    }

    public ImmutableSet<UUID> getMemberSet() {
        return this.getMemberSet(500);
    }

    public @NonNull ImmutableSet<UUID> getMemberSet(int minimumRank) {
        ImmutableSet.Builder result = new ImmutableSet.Builder();
        this.members.entrySet().stream().filter(e -> (Integer)e.getValue() >= minimumRank).map(Map.Entry::getKey).forEach(arg_0 -> ((ImmutableSet.Builder)result).add(arg_0));
        return result.build();
    }

    public @NonNull ImmutableSet<UUID> getMemberSet(int rank, boolean includeAboveRanks) {
        if (includeAboveRanks) {
            return this.getMemberSet(rank);
        }
        ImmutableSet.Builder result = new ImmutableSet.Builder();
        this.members.entrySet().stream().filter(e -> (Integer)e.getValue() == rank).map(Map.Entry::getKey).forEach(arg_0 -> ((ImmutableSet.Builder)result).add(arg_0));
        return result.build();
    }

    public int getMinProtectedX() {
        return Math.max(this.getMinX(), this.getProtectionCenter().getBlockX() - this.getProtectionRange());
    }

    public int getMaxProtectedX() {
        return Math.min(this.getMaxX(), this.getProtectionCenter().getBlockX() + this.getProtectionRange());
    }

    public int getMinProtectedZ() {
        return Math.max(this.getMinZ(), this.getProtectionCenter().getBlockZ() - this.getProtectionRange());
    }

    public int getMaxProtectedZ() {
        return Math.min(this.getMaxZ(), this.getProtectionCenter().getBlockZ() + this.getProtectionRange());
    }

    public int getMinX() {
        return this.center.getBlockX() - this.range;
    }

    public int getMaxX() {
        return this.center.getBlockX() + this.range;
    }

    public int getMinZ() {
        return this.center.getBlockZ() - this.range;
    }

    public int getMaxZ() {
        return this.center.getBlockZ() + this.range;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @Nullable UUID getOwner() {
        return this.owner;
    }

    public boolean isOwned() {
        return this.owner != null;
    }

    public boolean isUnowned() {
        return this.owner == null;
    }

    public int getProtectionRange() {
        return Math.min(this.getRange(), this.getRawProtectionRange() + this.getBonusRanges().stream().mapToInt(BonusRangeRecord::getRange).sum());
    }

    public int getRawProtectionRange() {
        return this.protectionRange;
    }

    public int getMaxEverProtectionRange() {
        if (this.maxEverProtectionRange > this.getRange()) {
            this.maxEverProtectionRange = this.getRange();
            this.setChanged();
        }
        return Math.max(this.getProtectionRange(), this.maxEverProtectionRange);
    }

    public void setMaxEverProtectionRange(int maxEverProtectionRange) {
        if (maxEverProtectionRange > this.maxEverProtectionRange) {
            this.maxEverProtectionRange = maxEverProtectionRange;
        }
        if (maxEverProtectionRange > this.range) {
            this.maxEverProtectionRange = this.range;
        }
        this.setChanged();
    }

    public boolean isPurgeProtected() {
        return this.purgeProtected;
    }

    public int getRange() {
        return this.range;
    }

    public int getRank(User user) {
        return this.members.getOrDefault(user.getUniqueId(), 0);
    }

    public int getRank(UUID userUUID) {
        return this.members.getOrDefault(userUUID, 0);
    }

    @Override
    public @NonNull String getUniqueId() {
        return this.uniqueId;
    }

    public long getUpdatedDate() {
        return this.updatedDate;
    }

    public World getWorld() {
        return this.world;
    }

    public @Nullable World getNetherWorld() {
        return this.getWorld(World.Environment.NETHER);
    }

    public @Nullable World getEndWorld() {
        return this.getWorld(World.Environment.THE_END);
    }

    public @Nullable World getWorld(World.Environment environment) {
        if (World.Environment.NORMAL.equals((Object)environment)) {
            return this.world;
        }
        if (World.Environment.THE_END.equals((Object)environment) && this.isEndIslandEnabled()) {
            return this.getPlugin().getIWM().getEndWorld(this.world);
        }
        if (World.Environment.NETHER.equals((Object)environment) && this.isNetherIslandEnabled()) {
            return this.getPlugin().getIWM().getNetherWorld(this.world);
        }
        return null;
    }

    public int getX() {
        return this.center.getBlockX();
    }

    public int getY() {
        return this.center.getBlockY();
    }

    public int getZ() {
        return this.center.getBlockZ();
    }

    public boolean inIslandSpace(int x, int z) {
        return x >= this.getMinX() && x < this.getMinX() + this.range * 2 && z >= this.getMinZ() && z < this.getMinZ() + this.range * 2;
    }

    public boolean inIslandSpace(Location location) {
        return Util.sameWorld(this.world, location.getWorld()) && (location.getWorld().getEnvironment().equals((Object)World.Environment.NORMAL) || this.getPlugin().getIWM().isIslandNether(location.getWorld()) || this.getPlugin().getIWM().isIslandEnd(location.getWorld())) && this.inIslandSpace(location.getBlockX(), location.getBlockZ());
    }

    public boolean inIslandSpace(Pair<Integer, Integer> blockCoordinates) {
        return this.inIslandSpace(blockCoordinates.x(), blockCoordinates.z());
    }

    public @Nullable BoundingBox getBoundingBox() {
        return this.getBoundingBox(World.Environment.NORMAL);
    }

    public @Nullable BoundingBox getBoundingBox(World.Environment environment) {
        BoundingBox boundingBox = World.Environment.NORMAL.equals((Object)environment) ? new BoundingBox((double)this.getMinX(), (double)this.world.getMinHeight(), (double)this.getMinZ(), (double)this.getMaxX(), (double)this.world.getMaxHeight(), (double)this.getMaxZ()) : (World.Environment.THE_END.equals((Object)environment) && this.isEndIslandEnabled() && this.getEndWorld() != null ? new BoundingBox((double)this.getMinX(), (double)this.getEndWorld().getMinHeight(), (double)this.getMinZ(), (double)this.getMaxX(), (double)this.getEndWorld().getMaxHeight(), (double)this.getMaxZ()) : (World.Environment.NETHER.equals((Object)environment) && this.isNetherIslandEnabled() && this.getNetherWorld() != null ? new BoundingBox((double)this.getMinX(), (double)this.getNetherWorld().getMinHeight(), (double)this.getMinZ(), (double)this.getMaxX(), (double)this.getNetherWorld().getMaxHeight(), (double)this.getMaxZ()) : null));
        return boundingBox;
    }

    private boolean playerIsVisitor(Player player) {
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return false;
        }
        return this.onIsland(player.getLocation()) && this.getRank(User.getInstance(player)) == 0;
    }

    public @NonNull List<Player> getVisitors() {
        return Bukkit.getOnlinePlayers().stream().filter(this::playerIsVisitor).collect(Collectors.toList());
    }

    public boolean hasVisitors() {
        return Bukkit.getOnlinePlayers().stream().anyMatch(this::playerIsVisitor);
    }

    public @NonNull List<Player> getPlayersOnIsland() {
        return Bukkit.getOnlinePlayers().stream().filter(player -> this.onIsland(player.getLocation())).collect(Collectors.toList());
    }

    public boolean hasPlayersOnIsland() {
        return Bukkit.getOnlinePlayers().stream().anyMatch(player -> this.onIsland(player.getLocation()));
    }

    public boolean isAllowed(Flag flag) {
        return this.getFlag(flag) >= 0;
    }

    public boolean isAllowed(User user, Flag flag) {
        return user.isOp() || this.getRank(user) >= this.getFlag(flag);
    }

    public boolean isBanned(UUID targetUUID) {
        return this.members.containsKey(targetUUID) && this.members.get(targetUUID).equals(-1);
    }

    public boolean isSpawn() {
        return this.spawn;
    }

    public boolean onIsland(@NonNull Location target) {
        return Util.sameWorld(this.world, target.getWorld()) && (target.getWorld().getEnvironment().equals((Object)World.Environment.NORMAL) || this.getPlugin().getIWM().isIslandNether(target.getWorld()) || this.getPlugin().getIWM().isIslandEnd(target.getWorld())) && target.getBlockX() >= this.getMinProtectedX() && target.getBlockX() < this.getMinProtectedX() + this.getProtectionRange() * 2 && target.getBlockZ() >= this.getMinProtectedZ() && target.getBlockZ() < this.getMinProtectedZ() + this.getProtectionRange() * 2;
    }

    public @Nullable BoundingBox getProtectionBoundingBox() {
        return this.getProtectionBoundingBox(World.Environment.NORMAL);
    }

    public @Nullable BoundingBox getProtectionBoundingBox(World.Environment environment) {
        BoundingBox boundingBox = World.Environment.NORMAL.equals((Object)environment) ? new BoundingBox((double)this.getMinProtectedX(), (double)this.world.getMinHeight(), (double)this.getMinProtectedZ(), (double)this.getMaxProtectedX(), (double)this.world.getMaxHeight(), (double)this.getMaxProtectedZ()) : (World.Environment.THE_END.equals((Object)environment) && this.isEndIslandEnabled() && this.getEndWorld() != null ? new BoundingBox((double)this.getMinProtectedX(), (double)this.getEndWorld().getMinHeight(), (double)this.getMinProtectedZ(), (double)this.getMaxProtectedX(), (double)this.getEndWorld().getMaxHeight(), (double)this.getMaxProtectedZ()) : (World.Environment.NETHER.equals((Object)environment) && this.isNetherIslandEnabled() && this.getNetherWorld() != null ? new BoundingBox((double)this.getMinProtectedX(), (double)this.getNetherWorld().getMinHeight(), (double)this.getMinProtectedZ(), (double)this.getMaxProtectedX(), (double)this.getNetherWorld().getMaxHeight(), (double)this.getMaxProtectedZ()) : null));
        return boundingBox;
    }

    public void removeMember(UUID playerUUID) {
        if (this.members.remove(playerUUID) != null) {
            this.setChanged();
        }
    }

    public void setCenter(@NonNull Location center) {
        if (this.center == null || !center.getWorld().equals((Object)this.center.getWorld()) || !center.equals((Object)this.center)) {
            this.world = center.getWorld();
            this.center = center;
            this.setChanged();
        }
    }

    public void setCreatedDate(long createdDate) {
        if (this.createdDate != createdDate) {
            this.createdDate = createdDate;
            this.setChanged();
        }
    }

    public Island setFlag(Flag flag, int value) {
        this.setFlag(flag, value, true);
        return this;
    }

    public void setFlag(Flag flag, int value, boolean doSubflags) {
        if (this.flags.containsKey(flag.getID()) && this.flags.get(flag.getID()) != value) {
            this.flags.put(flag.getID(), value);
            this.setChanged();
        }
        if (doSubflags && flag.hasSubflags()) {
            flag.getSubflags().forEach(subflag -> this.setFlag((Flag)subflag, value, true));
        }
    }

    public void setFlags(Map<String, Integer> flags) {
        this.flags = flags;
        this.setChanged();
    }

    public Island setFlagsDefaults() {
        BentoBox plugin = BentoBox.getInstance();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        plugin.getFlagsManager().getFlags().stream().filter(f -> f.getType().equals((Object)Flag.Type.PROTECTION)).forEach(f -> result.put(f.getID(), plugin.getIWM().getDefaultIslandFlags(this.world).getOrDefault(f, f.getDefaultRank())));
        plugin.getFlagsManager().getFlags().stream().filter(f -> f.getType().equals((Object)Flag.Type.SETTING)).forEach(f -> result.put(f.getID(), plugin.getIWM().getDefaultIslandSettings(this.world).getOrDefault(f, f.getDefaultRank())));
        this.setFlags(result);
        return this;
    }

    public void setMembers(Map<UUID, Integer> members) {
        this.members = members;
        this.setChanged();
    }

    public void setName(String name) {
        if (name == null || !name.equals(this.name)) {
            this.name = name != null && !name.isEmpty() ? name : null;
            this.setChanged();
        }
    }

    public void setOwner(@Nullable UUID owner) {
        if (this.owner == owner) {
            return;
        }
        this.owner = owner;
        if (owner == null) {
            this.log(new LogEntry.Builder(LogEntry.LogType.UNOWNED).build());
            this.setChanged();
            return;
        }
        for (Map.Entry<UUID, Integer> en : this.members.entrySet()) {
            if (!en.getValue().equals(1000)) continue;
            this.setRank(en.getKey(), 500);
        }
        this.setRank(owner, 1000);
        this.setChanged();
    }

    public void setProtectionRange(int protectionRange) {
        if (this.protectionRange != protectionRange) {
            this.protectionRange = protectionRange;
            this.updateMaxEverProtectionRange();
            this.setChanged();
        }
    }

    public void updateMaxEverProtectionRange() {
        int diffMinX = Math.abs(Objects.requireNonNull(this.getCenter()).getBlockX() - this.getMinProtectedX());
        int diffMaxX = Math.abs(this.getCenter().getBlockX() - this.getMaxProtectedX());
        int diffMinZ = Math.abs(this.getCenter().getBlockZ() - this.getMinProtectedZ());
        int diffMaxZ = Math.abs(this.getCenter().getBlockZ() - this.getMaxProtectedZ());
        if (diffMinX > this.maxEverProtectionRange) {
            this.maxEverProtectionRange = diffMinX;
        }
        if (diffMaxX > this.maxEverProtectionRange) {
            this.maxEverProtectionRange = diffMaxX;
        }
        if (diffMinZ > this.maxEverProtectionRange) {
            this.maxEverProtectionRange = diffMinZ;
        }
        if (diffMaxZ > this.maxEverProtectionRange) {
            this.maxEverProtectionRange = diffMaxZ;
        }
    }

    public void setPurgeProtected(boolean purgeProtected) {
        if (this.purgeProtected != purgeProtected) {
            this.purgeProtected = purgeProtected;
            this.setChanged();
        }
    }

    public void setRange(int range) {
        if (this.range != range) {
            this.range = range;
            this.setChanged();
        }
    }

    public void setRank(User user, int rank) {
        this.setRank(user.getUniqueId(), rank);
    }

    public void setRank(@Nullable UUID uuid, int newRank) {
        if (uuid == null) {
            return;
        }
        AtomicBoolean isRankChanged = new AtomicBoolean(false);
        this.members.compute(uuid, (key, existingRank) -> {
            if (existingRank == null || existingRank != newRank) {
                isRankChanged.set(true);
                return newRank;
            }
            return existingRank;
        });
        if (isRankChanged.get()) {
            this.setChanged();
        }
    }

    public void setRanks(Map<UUID, Integer> ranks) {
        this.members = ranks;
        this.setChanged();
    }

    public void setSpawn(boolean isSpawn) {
        if (this.spawn == isSpawn) {
            return;
        }
        this.spawn = isSpawn;
        if (isSpawn) {
            this.setOwner(null);
            this.members.clear();
            this.setFlagsDefaults();
            this.setFlag(Flags.LOCK, 0);
        }
        this.log(new LogEntry.Builder(LogEntry.LogType.SPAWN).data("value", String.valueOf(isSpawn)).build());
        this.setChanged();
    }

    public Map<World.Environment, Location> getSpawnPoint() {
        return this.spawnPoint;
    }

    public void setSpawnPoint(Map<World.Environment, Location> spawnPoint) {
        this.spawnPoint = spawnPoint;
        this.setChanged();
    }

    @Override
    public void setUniqueId(@NonNull String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setUpdatedDate(long updatedDate) {
        this.updatedDate = updatedDate;
    }

    public void setWorld(World world) {
        this.world = world;
        this.setChanged();
    }

    public void toggleFlag(Flag flag) {
        this.toggleFlag(flag, true);
    }

    public void toggleFlag(Flag flag, boolean doSubflags) {
        boolean newToggleValue;
        boolean bl = newToggleValue = !this.isAllowed(flag);
        if (flag.getType().equals((Object)Flag.Type.SETTING) || flag.getType().equals((Object)Flag.Type.WORLD_SETTING)) {
            this.setSettingsFlag(flag, newToggleValue, doSubflags);
        }
        this.setChanged();
    }

    public void setSettingsFlag(Flag flag, boolean state) {
        this.setSettingsFlag(flag, state, true);
    }

    public void setSettingsFlag(Flag flag, boolean state, boolean doSubflags) {
        int newState;
        int n = newState = state ? 1 : -1;
        if (flag.getType().equals((Object)Flag.Type.SETTING) || flag.getType().equals((Object)Flag.Type.WORLD_SETTING)) {
            this.flags.put(flag.getID(), newState);
            if (doSubflags && flag.hasSubflags()) {
                flag.getSubflags().forEach(subflag -> this.setSettingsFlag((Flag)subflag, state, true));
            }
        }
        this.setChanged();
    }

    public void setSpawnPoint(World.Environment islandType, Location l) {
        this.spawnPoint.compute(islandType, (key, value) -> {
            if (value == null || !value.equals((Object)l)) {
                this.setChanged();
                return l;
            }
            return value;
        });
    }

    public @Nullable Location getSpawnPoint(World.Environment islandType) {
        return this.spawnPoint.get(islandType);
    }

    public void removeRank(Integer rank) {
        if (this.members.values().removeIf(rank::equals)) {
            this.setChanged();
        }
    }

    public List<LogEntry> getHistory() {
        return this.history;
    }

    public void log(LogEntry logEntry) {
        this.history.add(logEntry);
        this.setChanged();
    }

    public void setHistory(List<LogEntry> history) {
        this.history = history;
        this.setChanged();
    }

    public boolean isDoNotLoad() {
        return this.doNotLoad;
    }

    public void setDoNotLoad(boolean doNotLoad) {
        this.doNotLoad = doNotLoad;
        this.setChanged();
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
        this.setChanged();
    }

    public String getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(String gameMode) {
        this.gameMode = gameMode;
    }

    public boolean hasNetherIsland() {
        World nether = BentoBox.getInstance().getIWM().getNetherWorld(this.getWorld());
        return nether != null && this.getCenter().toVector().toLocation(nether).getBlock().getType() != Material.AIR;
    }

    public boolean isNetherIslandEnabled() {
        return this.getPlugin().getIWM().isNetherGenerate(this.world) && this.getPlugin().getIWM().isNetherIslands(this.world);
    }

    public boolean hasEndIsland() {
        World end = BentoBox.getInstance().getIWM().getEndWorld(this.getWorld());
        return end != null && this.getCenter().toVector().toLocation(end).getBlock().getType() != Material.AIR;
    }

    public boolean isEndIslandEnabled() {
        return this.getPlugin().getIWM().isEndGenerate(this.world) && this.getPlugin().getIWM().isEndIslands(this.world);
    }

    public boolean isCooldown(Flag flag) {
        if (this.cooldowns.containsKey(flag.getID()) && this.cooldowns.get(flag.getID()) > System.currentTimeMillis()) {
            return true;
        }
        if (this.cooldowns.remove(flag.getID()) != null) {
            this.setChanged();
        }
        return false;
    }

    public void setCooldown(Flag flag) {
        this.cooldowns.put(flag.getID(), (long)flag.getCooldown() * 1000L + System.currentTimeMillis());
        this.setChanged();
    }

    public Map<String, Long> getCooldowns() {
        return this.cooldowns;
    }

    public void setCooldowns(Map<String, Long> cooldowns) {
        this.cooldowns = cooldowns;
        this.setChanged();
    }

    public Map<String, Integer> getCommandRanks() {
        return this.commandRanks;
    }

    public void setCommandRanks(Map<String, Integer> commandRanks) {
        this.commandRanks = commandRanks;
        this.setChanged();
    }

    public int getRankCommand(String command) {
        if (this.commandRanks == null) {
            this.commandRanks = new HashMap<String, Integer>();
        }
        return this.commandRanks.computeIfAbsent(command, key -> {
            String[] labels = key.replaceFirst("/", "").split(" ");
            CompositeCommand compositeCommand = this.getPlugin().getCommandsManager().getCommand(labels[0]);
            for (int i = 1; i < labels.length && compositeCommand != null; ++i) {
                compositeCommand = compositeCommand.getSubCommand(labels[i]).orElse(null);
            }
            return compositeCommand == null ? 1000 : compositeCommand.getDefaultCommandRank();
        });
    }

    public void setRankCommand(String command, int rank) {
        if (this.commandRanks == null) {
            this.commandRanks = new HashMap<String, Integer>();
        }
        this.commandRanks.compute(command, (key, value) -> {
            if (value == null || !value.equals(rank)) {
                this.setChanged();
                return rank;
            }
            return value;
        });
    }

    public boolean isReserved() {
        return this.reserved != null && this.reserved != false;
    }

    public void setReserved(boolean reserved) {
        if (this.reserved == null) {
            this.reserved = false;
        }
        if (this.reserved != reserved) {
            this.reserved = reserved;
            this.setChanged();
        }
    }

    @Override
    public Optional<Map<String, MetaDataValue>> getMetaData() {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, MetaDataValue>();
        }
        return Optional.of(this.metaData);
    }

    @Override
    public void setMetaData(Map<String, MetaDataValue> metaData) {
        this.metaData = metaData;
        this.setChanged();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged() {
        this.setUpdatedDate(System.currentTimeMillis());
        this.changed = true;
        IslandsManager.updateIsland(this);
    }

    public void clearChanged() {
        this.changed = false;
    }

    public @NonNull Location getProtectionCenter() {
        return this.location == null ? this.getCenter() : this.location.clone();
    }

    public void setProtectionCenter(Location location) throws IOException {
        if (this.getProtectionCenter().equals((Object)location)) {
            return;
        }
        if (!this.inIslandSpace(location)) {
            throw new IOException("Location must be in island space");
        }
        this.location = location;
        this.updateMaxEverProtectionRange();
        this.setChanged();
    }

    public @NonNull Map<String, Location> getHomes() {
        if (this.homes == null) {
            this.homes = new HashMap<String, Location>();
        }
        return this.homes;
    }

    public @NonNull Location getHome(String nameToLookFor) {
        return this.getHomes().entrySet().stream().filter(en -> ((String)en.getKey()).equalsIgnoreCase(nameToLookFor)).map(Map.Entry::getValue).findFirst().orElse(this.getProtectionCenter().clone().add(new Vector(0.5, 0.0, 0.5)));
    }

    public void setHomes(Map<String, Location> homes) {
        this.homes = homes;
        this.setChanged();
    }

    public void addHome(String name, Location location) {
        if (this.getHomes().containsKey(name) && this.getHomes().get(name).equals((Object)location)) {
            return;
        }
        if (location != null) {
            Vector v = location.toVector();
            if (this.getBoundingBox() != null && !this.getBoundingBox().contains(v)) {
                BentoBox.getInstance().logWarning("Tried to set a home location " + String.valueOf(location) + " outside of the island. This generally should not happen.");
                BentoBox.getInstance().logWarning("Island is at " + String.valueOf(this.getCenter()) + ". The island file may need editing to remove this home.");
                BentoBox.getInstance().logWarning("Please report this issue and logs around this item to BentoBox");
            }
        }
        this.getHomes().put(name.toLowerCase(), location);
        this.setChanged();
    }

    public boolean removeHome(String name) {
        if (this.getHomes().remove(name.toLowerCase()) != null) {
            this.setChanged();
            return true;
        }
        return false;
    }

    public boolean removeHomes() {
        if (this.getHomes().keySet().removeIf(k -> !k.isEmpty())) {
            this.setChanged();
            return true;
        }
        return false;
    }

    public boolean renameHome(String oldName, String newName) {
        if (this.getHomes().containsKey(oldName.toLowerCase()) && !this.getHomes().containsKey(newName.toLowerCase())) {
            this.addHome(newName, this.getHome(oldName));
            this.removeHome(oldName);
            return true;
        }
        return false;
    }

    public @Nullable Integer getMaxHomes() {
        return this.maxHomes;
    }

    public void setMaxHomes(@Nullable Integer maxHomes) {
        if (!Objects.equals(this.maxHomes, maxHomes)) {
            this.maxHomes = maxHomes;
            this.setChanged();
        }
    }

    public Map<Integer, Integer> getMaxMembers() {
        if (this.maxMembers == null) {
            this.maxMembers = new HashMap<Integer, Integer>();
        }
        return this.maxMembers;
    }

    public void setMaxMembers(Map<Integer, Integer> maxMembers) {
        if (this.maxMembers != maxMembers) {
            this.maxMembers = maxMembers;
            this.setChanged();
        }
    }

    public @Nullable Integer getMaxMembers(int rank) {
        return this.getMaxMembers().get(rank);
    }

    public void setMaxMembers(int rank, Integer maxMembers) {
        this.getMaxMembers().compute(rank, (key, value) -> {
            if (value == null || !value.equals(maxMembers)) {
                this.setChanged();
                return maxMembers;
            }
            return value;
        });
    }

    public List<BonusRangeRecord> getBonusRanges() {
        if (this.bonusRanges == null) {
            this.setBonusRanges(new ArrayList<BonusRangeRecord>());
        }
        return this.bonusRanges;
    }

    public void setBonusRanges(List<BonusRangeRecord> bonusRanges) {
        this.bonusRanges = bonusRanges;
        this.setChanged();
    }

    public int getBonusRange(String id) {
        return this.getBonusRanges().stream().filter(r -> r.getUniqueId().equals(id)).mapToInt(BonusRangeRecord::getRange).sum();
    }

    public Optional<BonusRangeRecord> getBonusRangeRecord(String uniqueId) {
        return this.getBonusRanges().stream().filter(r -> r.getUniqueId().equals(uniqueId)).findFirst();
    }

    public void addBonusRange(String id, int range, String message) {
        this.getBonusRanges().add(new BonusRangeRecord(id, range, message));
        this.setMaxEverProtectionRange(this.getProtectionRange());
        this.setChanged();
    }

    public void clearBonusRange(String id) {
        if (this.getBonusRanges().removeIf(r -> r.getUniqueId().equals(id))) {
            this.setChanged();
        }
    }

    public void clearAllBonusRanges() {
        this.getBonusRanges().clear();
        this.setChanged();
    }

    public boolean isPrimary(UUID userID) {
        return this.getPrimaries().contains(userID);
    }

    public void setPrimary(UUID userID) {
        if (this.getPrimaries().add(userID)) {
            this.setChanged();
        }
    }

    public void removePrimary(UUID userID) {
        if (this.getPrimaries().remove(userID)) {
            this.setChanged();
        }
    }

    public boolean inTeam(UUID playerUUID) {
        return this.getMemberSet().contains((Object)playerUUID);
    }

    public boolean hasTeam() {
        return this.getMemberSet().size() > 1;
    }

    public String toString() {
        return "Island [changed=" + this.changed + ", deleted=" + this.deleted + ", uniqueId=" + this.uniqueId + ", center=" + String.valueOf(this.center) + ", location=" + String.valueOf(this.location) + ", range=" + this.range + ", protectionRange=" + this.protectionRange + ", maxEverProtectionRange=" + this.maxEverProtectionRange + ", world=" + String.valueOf(this.world) + ", gameMode=" + this.gameMode + ", name=" + this.name + ", createdDate=" + this.createdDate + ", updatedDate=" + this.updatedDate + ", owner=" + String.valueOf(this.owner) + ", members=" + String.valueOf(this.members) + ", maxMembers=" + String.valueOf(this.maxMembers) + ", spawn=" + this.spawn + ", purgeProtected=" + this.purgeProtected + ", flags=" + String.valueOf(this.flags) + ", history=" + String.valueOf(this.history) + ", spawnPoint=" + String.valueOf(this.spawnPoint) + ", doNotLoad=" + this.doNotLoad + ", cooldowns=" + String.valueOf(this.cooldowns) + ", commandRanks=" + String.valueOf(this.commandRanks) + ", reserved=" + this.reserved + ", metaData=" + String.valueOf(this.metaData) + ", homes=" + String.valueOf(this.homes) + ", maxHomes=" + this.maxHomes + "]";
    }

    public Set<UUID> getPrimaries() {
        if (this.primaries == null) {
            this.primaries = new HashSet<UUID>();
        }
        return this.primaries;
    }

    public void setPrimaries(Set<UUID> primaries) {
        this.primaries = primaries;
        this.setChanged();
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Island other = (Island)obj;
        return Objects.equals(this.uniqueId, other.uniqueId);
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }
}

