/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.objects;

import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.metadata.MetaDataAble;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.database.objects.DataObject;
import world.bentobox.bentobox.database.objects.Table;
import world.bentobox.bentobox.util.Util;

@Table(name="Players")
public class Players
implements DataObject,
MetaDataAble {
    @Expose
    private String uniqueId;
    @Expose
    private String playerName;
    @Expose
    private Map<String, Integer> resets = new HashMap<String, Integer>();
    @Expose
    private String locale = "";
    @Expose
    private Map<String, Integer> deaths = new HashMap<String, Integer>();
    @Expose
    private Long lastLogin;
    @Expose
    private Set<String> pendingKicks = new HashSet<String>();
    @Expose
    private Flag.Mode flagsDisplayMode = Flag.Mode.BASIC;
    @Expose
    private Map<String, MetaDataValue> metaData;

    public Players() {
    }

    public Players(BentoBox plugin, UUID uniqueId) {
        this.uniqueId = uniqueId.toString();
        this.locale = "";
        this.playerName = Bukkit.getOfflinePlayer((UUID)uniqueId).getName();
        if (this.playerName == null) {
            this.playerName = uniqueId.toString();
        }
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)UUID.fromString(this.uniqueId));
    }

    public UUID getPlayerUUID() {
        return UUID.fromString(this.uniqueId);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public int getResets(World world) {
        return this.resets.computeIfAbsent(world.getName(), k -> 0);
    }

    public Map<String, Integer> getResets() {
        return this.resets;
    }

    public void setResets(Map<String, Integer> resets) {
        this.resets = resets;
    }

    public void setResets(World world, int resets) {
        this.resets.put(world.getName(), resets);
    }

    public void setPlayerUUID(UUID uuid) {
        this.uniqueId = uuid.toString();
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Map<String, Integer> getDeaths() {
        return this.deaths;
    }

    public void setDeaths(World world, int deaths) {
        this.deaths.put(world.getName(), Math.min(deaths, this.getPlugin().getIWM().getDeathsMax(world)));
    }

    public void addDeath(World world) {
        this.deaths.putIfAbsent(world.getName(), 0);
        if (this.deaths.get(world.getName()) < this.getPlugin().getIWM().getDeathsMax(world)) {
            this.deaths.put(world.getName(), this.deaths.get(world.getName()) + 1);
        }
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void addReset(World world) {
        this.resets.merge(world.getName(), 1, Integer::sum);
    }

    public int getDeaths(World world) {
        return this.deaths.getOrDefault(world.getName(), 0);
    }

    public void setDeaths(Map<String, Integer> deaths) {
        this.deaths = deaths;
    }

    public Set<String> getPendingKicks() {
        return this.pendingKicks;
    }

    public void setPendingKicks(Set<String> pendingKicks) {
        this.pendingKicks = pendingKicks;
    }

    public void addToPendingKick(World world) {
        World w = Util.getWorld(world);
        if (w != null) {
            this.pendingKicks.add(w.getName());
        }
    }

    @Override
    public Optional<Map<String, MetaDataValue>> getMetaData() {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, MetaDataValue>();
        } else if (this.isImmutable(this.metaData)) {
            this.metaData = new HashMap<String, MetaDataValue>(this.metaData);
        }
        return Optional.of(this.metaData);
    }

    private boolean isImmutable(Map<String, MetaDataValue> map) {
        try {
            String testKey = "testKey";
            MetaDataValue testValue = new MetaDataValue("test");
            if (!map.isEmpty()) {
                String existingKey = map.keySet().iterator().next();
                map.put(existingKey, map.get(existingKey));
            } else {
                map.put(testKey, testValue);
                map.remove(testKey);
            }
            return false;
        }
        catch (UnsupportedOperationException e) {
            return true;
        }
    }

    @Override
    public void setMetaData(Map<String, MetaDataValue> metaData) {
        if (this.isImmutable(metaData)) {
            throw new IllegalArgumentException("Provided map is immutable and cannot be set.");
        }
        this.metaData = metaData;
    }

    public @Nullable Long getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(Long lastLogin) {
        this.lastLogin = lastLogin;
    }
}

