/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.sql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.DatabaseConnectionSettingsImpl;
import world.bentobox.bentobox.database.DatabaseConnector;

public abstract class SQLDatabaseConnector
implements DatabaseConnector {
    protected String connectionUrl;
    protected final DatabaseConnectionSettingsImpl dbSettings;
    protected static HikariDataSource dataSource;
    protected static Set<Class<?>> types;

    protected SQLDatabaseConnector(DatabaseConnectionSettingsImpl dbSettings, String connectionUrl) {
        this.dbSettings = dbSettings;
        this.connectionUrl = connectionUrl;
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public @NonNull String getUniqueId(String tableName) {
        return "";
    }

    @Override
    public boolean uniqueIdExists(String tableName, String key) {
        return false;
    }

    @Override
    public void closeConnection(Class<?> type) {
        types.remove(type);
        if (types.isEmpty()) {
            dataSource.close();
            BentoBox.getInstance().log("Closed database connection");
        }
    }

    public abstract HikariConfig createConfig();

    @Override
    public Object createConnection(Class<?> type) {
        types.add(type);
        if (dataSource == null) {
            try {
                dataSource = new HikariDataSource(this.createConfig());
                try (Connection connection = dataSource.getConnection();){
                    connection.isValid(5000);
                }
            }
            catch (SQLException e) {
                BentoBox.getInstance().logError("Could not connect to the database! " + e.getMessage());
                dataSource = null;
            }
        }
        return dataSource;
    }

    static {
        types = new HashSet();
    }
}

