/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.hooks;

import org.bukkit.Material;
import org.bukkit.World;
import org.mvplugins.multiverse.core.MultiverseCoreApi;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.options.ImportWorldOptions;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.hooks.Hook;
import world.bentobox.bentobox.hooks.WorldManagementHook;

public class MultiverseCore5Hook
extends Hook
implements WorldManagementHook {
    public MultiverseCore5Hook() {
        super("Multiverse-Core", Material.COMPASS);
    }

    @Override
    public void registerWorld(World world, boolean islandWorld) {
        MultiverseCoreApi api = MultiverseCoreApi.get();
        String generator = islandWorld ? this.getGenerator(world) : null;
        api.getWorldManager().importWorld(ImportWorldOptions.worldName((String)world.getName()).environment(world.getEnvironment()).generator(generator)).peek(mvWorld -> mvWorld.setAutoLoad(false));
    }

    private String getGenerator(World world) {
        return BentoBox.getInstance().getIWM().getAddon(world).map(gm -> gm.getDefaultWorldGenerator(world.getName(), "") != null).orElse(false) != false ? BentoBox.getInstance().getName() : null;
    }

    @Override
    public void unregisterWorld(World world) {
        MultiverseCoreApi api = MultiverseCoreApi.get();
        api.getWorldManager().getWorld(world.getName()).peek(arg_0 -> ((WorldManager)api.getWorldManager()).removeWorld(arg_0));
    }

    @Override
    public boolean hook() {
        return true;
    }

    @Override
    public String getFailureCause() {
        return null;
    }
}

