/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.database.objects.Players;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.managers.PlayersManager;
import world.bentobox.bentobox.util.Util;

public class JoinLeaveListener
implements Listener {
    private final BentoBox plugin;
    private final PlayersManager players;

    public JoinLeaveListener(@NonNull BentoBox plugin) {
        this.plugin = plugin;
        this.players = plugin.getPlayers();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        User.removePlayer(event.getPlayer());
        User user = User.getInstance(event.getPlayer());
        if (!user.isPlayer() || user.getUniqueId() == null) {
            return;
        }
        this.plugin.getIWM().getAddon(event.getPlayer().getWorld()).ifPresent(gm -> user.setAddon((Addon)gm));
        UUID playerUUID = event.getPlayer().getUniqueId();
        if (!this.players.isKnown(playerUUID)) {
            this.firstTime(user);
        }
        this.players.getPlayer(playerUUID);
        this.players.setLoginTimeStamp(user);
        this.plugin.getIWM().getOverWorlds().stream().filter(w -> event.getPlayer().getLastSeen() < this.plugin.getIWM().getResetEpoch((World)w)).forEach(w -> this.players.setResets((World)w, playerUUID, 0));
        this.updateIslandRange(user);
        if (!user.getName().isEmpty()) {
            this.players.setPlayerName(user);
        } else {
            this.plugin.logWarning("Player that just logged in has no name! " + String.valueOf(playerUUID));
        }
        this.plugin.getIslands().getIslandAt(user.getLocation()).filter(i -> user.getUniqueId().equals(i.getOwner())).ifPresent(i -> this.plugin.getIslands().setPrimaryIsland(playerUUID, (Island)i));
        if (this.plugin.getIslands().locationIsOnIsland(event.getPlayer(), user.getLocation()) && Flags.REMOVE_MOBS.isSetForWorld(user.getWorld())) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getIslands().clearArea(user.getLocation()));
        }
        this.clearPlayersInventory(Util.getWorld(event.getPlayer().getWorld()), user);
        this.updateIslandMaxTeamAndHomeSize(user);
        this.plugin.getMetrics().ifPresent(bStats -> bStats.addPlayer(playerUUID));
        this.plugin.getAddonsManager().getGameModeAddons().forEach(addon -> this.plugin.getPlaceholdersManager().registerPlaceholder((Addon)addon, "onisland_" + user.getName(), asker -> {
            if (asker == null) {
                return "";
            }
            User named = User.getInstance(user.getUniqueId());
            if (named.isOnline()) {
                return this.plugin.getIslands().getIslands(addon.getOverWorld(), asker).stream().filter(island -> island.onIsland(named.getLocation())).findFirst().map(i -> "true").orElse("false");
            }
            return "false";
        }));
    }

    private void updateIslandMaxTeamAndHomeSize(User user) {
        this.plugin.getIWM().getOverWorlds().stream().flatMap(w -> this.plugin.getIslands().getIslands((World)w, user.getUniqueId()).stream()).filter(Objects::nonNull).filter(i -> user.getUniqueId().equals(i.getOwner())).forEach(i -> {
            this.plugin.getIslands().getMaxMembers((Island)i, 500);
            this.plugin.getIslands().getMaxMembers((Island)i, 200);
            this.plugin.getIslands().getMaxMembers((Island)i, 400);
            this.plugin.getIslands().getMaxHomes((Island)i);
        });
    }

    private void firstTime(User user) {
        this.players.getPlayer(user.getUniqueId());
        this.plugin.getIWM().getOverWorlds().stream().filter(w -> this.plugin.getIWM().isCreateIslandOnFirstLoginEnabled((World)w)).forEach(w -> {
            if (!this.plugin.getIslands().hasIsland((World)w, user) && !this.plugin.getIslands().inTeam((World)w, user.getUniqueId())) {
                int delay = this.plugin.getIWM().getCreateIslandOnFirstLoginDelay((World)w);
                user.sendMessage("commands.island.create.on-first-login", "[number]", String.valueOf(delay));
                Runnable createIsland = () -> {
                    if (!this.plugin.getIWM().isCreateIslandOnFirstLoginAbortOnLogout((World)w) || user.isOnline()) {
                        this.plugin.getIWM().getAddon((World)w).flatMap(addon -> addon.getPlayerCommand().flatMap(command -> command.getSubCommand("create"))).ifPresent(command -> command.execute(user, "create", Collections.singletonList("default")));
                    }
                };
                if (delay <= 0) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, createIsland);
                } else {
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, createIsland, (long)delay * 20L);
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerSwitchWorld(PlayerChangedWorldEvent event) {
        World world = Util.getWorld(event.getPlayer().getWorld());
        if (world != null) {
            this.clearPlayersInventory(world, User.getInstance(event.getPlayer()));
        }
    }

    private void clearPlayersInventory(@Nullable World world, @NonNull User user) {
        if (user.getUniqueId() == null || world == null) {
            return;
        }
        Players playerData = this.players.getPlayer(user.getUniqueId());
        if (playerData != null && playerData.getPendingKicks().contains(world.getName())) {
            if (this.plugin.getIWM().isOnLeaveResetEnderChest(world)) {
                user.getPlayer().getEnderChest().clear();
            }
            if (this.plugin.getIWM().isOnLeaveResetInventory(world)) {
                user.getPlayer().getInventory().clear();
            }
            Set<String> kicks = playerData.getPendingKicks();
            kicks.remove(world.getName());
            playerData.setPendingKicks(kicks);
        }
    }

    private void updateIslandRange(User user) {
        this.plugin.getIslands().getIslands(user.getUniqueId()).stream().filter(island -> island.getOwner() != null && island.getOwner().equals(user.getUniqueId())).forEach(island -> {
            int range = user.getPermissionValue(this.plugin.getIWM().getAddon(island.getWorld()).map(Addon::getPermissionPrefix).orElse("") + "island.range", island.getRawProtectionRange());
            if ((range = Math.min(range, this.plugin.getIWM().getIslandDistance(island.getWorld()))) != island.getRawProtectionRange()) {
                user.sendMessage("commands.admin.setrange.range-updated", "[number]", String.valueOf(range));
                int oldRange = island.getProtectionRange();
                island.setProtectionRange(range);
                this.plugin.log("Island protection range changed from " + oldRange + " to " + island.getProtectionRange() + " for " + user.getName() + " due to permission.");
                IslandEvent.builder().island((Island)island).location(island.getProtectionCenter()).reason(IslandEvent.Reason.RANGE_CHANGE).involvedPlayer(user.getUniqueId()).admin(true).protectionRange(island.getProtectionRange(), oldRange).build();
            }
        });
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getIslands().getIslands(event.getPlayer().getUniqueId()).stream().filter(island -> island.getMembers().containsKey(event.getPlayer().getUniqueId())).forEach(island -> {
            if (Bukkit.getOnlinePlayers().stream().filter(p -> !event.getPlayer().equals(p)).noneMatch(p -> island.inTeam(p.getUniqueId()))) {
                island.getMembers().entrySet().stream().filter(e -> (Integer)e.getValue() == 200).forEach(e -> User.getInstance((UUID)e.getKey()).sendMessage("commands.island.team.uncoop.all-members-logged-off", "[name]", this.plugin.getPlayers().getName(island.getOwner())));
                island.removeRank(200);
            }
        });
        this.plugin.getIslands().clearRank(200, event.getPlayer().getUniqueId());
        this.plugin.getAddonsManager().getGameModeAddons().forEach(addon -> this.plugin.getPlaceholdersManager().unregisterPlaceholder((Addon)addon, "onisland_" + event.getPlayer().getName()));
        this.plugin.getPlayers().savePlayer(event.getPlayer().getUniqueId());
        User.removePlayer(event.getPlayer());
    }
}

