/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.settings;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.events.flags.FlagSettingChangeEvent;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;

public class PVPListener
extends FlagListener {
    private final Map<Integer, UUID> thrownPotions = new HashMap<Integer, UUID>();
    private final Map<Entity, Player> firedFireworks = new WeakHashMap<Entity, Player>();

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.getPlugin().getIWM().inWorld(e.getEntity().getWorld())) {
                if (e.getEntity().equals((Object)e.getDamager()) || e.getEntity().hasMetadata("NPC") || e.getDamager().hasMetadata("NPC")) {
                    return;
                }
                if (this.PVPAllowed(e.getEntity().getLocation())) {
                    return;
                }
                if (e.getCause().equals((Object)EntityDamageEvent.DamageCause.ENTITY_ATTACK) && this.protectedVisitor((LivingEntity)player)) {
                    Player p;
                    Entity entity2 = e.getDamager();
                    if (entity2 instanceof Player && (p = (Player)entity2) != null) {
                        User.getInstance(p).notify(Flags.INVINCIBLE_VISITORS.getHintReference(), new String[0]);
                    } else {
                        Player sh;
                        Projectile pr;
                        entity2 = e.getDamager();
                        if (entity2 instanceof Projectile && (entity2 = (pr = (Projectile)entity2).getShooter()) instanceof Player && (sh = (Player)entity2) != null) {
                            User.getInstance(sh).notify(Flags.INVINCIBLE_VISITORS.getHintReference(), new String[0]);
                        }
                    }
                    e.setCancelled(true);
                } else {
                    this.respond((Cancellable)e, e.getDamager(), e.getEntity(), this.getFlag(e.getEntity().getWorld()));
                }
            }
        }
    }

    private void respond(Cancellable e, Entity damager, Entity hurtEntity, Flag flag) {
        Projectile projectile;
        ProjectileSource user2;
        if (damager instanceof Player) {
            Player player = (Player)damager;
            User user2 = User.getInstance((CommandSender)damager);
            if (!this.checkIsland((Event)e, player, player.getLocation(), flag)) {
                user2.notify(this.getFlag(player.getWorld()).getHintReference(), new String[0]);
                e.setCancelled(true);
            }
        } else if (damager instanceof Projectile && (user2 = (projectile = (Projectile)damager).getShooter()) instanceof Player) {
            Player shooter = (Player)user2;
            this.processDamage(e, damager, shooter, hurtEntity, flag);
        } else if (damager instanceof Firework && this.firedFireworks.containsKey(damager)) {
            Player shooter = this.firedFireworks.get(damager);
            this.processDamage(e, damager, shooter, hurtEntity, flag);
        }
    }

    private void processDamage(Cancellable e, Entity damager, Player shooter, Entity hurtEntity, Flag flag) {
        if (hurtEntity.equals((Object)shooter) || shooter == null) {
            return;
        }
        User user = User.getInstance(shooter);
        if (!this.checkIsland((Event)e, shooter, damager.getLocation(), flag)) {
            damager.setFireTicks(0);
            hurtEntity.setFireTicks(0);
            user.notify(this.getFlag(damager.getWorld()).getHintReference(), new String[0]);
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFishing(PlayerFishEvent e) {
        Entity entity = e.getCaught();
        if (entity instanceof Player) {
            Player c = (Player)entity;
            if (this.getPlugin().getIWM().inWorld(c.getLocation())) {
                if (c.equals((Object)e.getPlayer()) || c.hasMetadata("NPC")) {
                    return;
                }
                if (this.PVPAllowed(c.getLocation())) {
                    return;
                }
                if (this.protectedVisitor((LivingEntity)c)) {
                    User.getInstance(e.getPlayer()).notify(Flags.INVINCIBLE_VISITORS.getHintReference(), new String[0]);
                    e.setCancelled(true);
                } else if (!this.checkIsland((Event)e, e.getPlayer(), c.getLocation(), this.getFlag(c.getWorld()))) {
                    e.getHook().remove();
                    User.getInstance(e.getPlayer()).notify(this.getFlag(c.getWorld()).getHintReference(), new String[0]);
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSplashPotionSplash(PotionSplashEvent e) {
        Player p;
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (projectileSource instanceof Player && (p = (Player)projectileSource) != null && this.getPlugin().getIWM().inWorld(e.getEntity().getWorld())) {
            User user = User.getInstance(p);
            if (this.PVPAllowed(e.getEntity().getLocation())) {
                return;
            }
            for (LivingEntity le : e.getAffectedEntities()) {
                if (le.getUniqueId().equals(user.getUniqueId()) || !this.blockPVP(user, le, (Event)e, this.getFlag(e.getEntity().getWorld()))) continue;
                e.setIntensity(le, 0.0);
            }
        }
    }

    private boolean blockPVP(User user, LivingEntity le, Event e, Flag flag) {
        if (le.equals((Object)user.getPlayer()) || le.hasMetadata("NPC")) {
            return false;
        }
        if (le instanceof Player) {
            if (this.protectedVisitor(le)) {
                user.notify(Flags.INVINCIBLE_VISITORS.getHintReference(), new String[0]);
                return true;
            }
            if (!this.checkIsland(e, user.getPlayer(), le.getLocation(), flag)) {
                user.notify(this.getFlag(le.getWorld()).getHintReference(), new String[0]);
                return true;
            }
        }
        return false;
    }

    private boolean protectedVisitor(LivingEntity entity) {
        return this.getPlugin().getIWM().getIvSettings(entity.getWorld()).contains(EntityDamageEvent.DamageCause.ENTITY_ATTACK.name()) && !this.getIslands().userIsOnIsland(entity.getWorld(), User.getInstance((CommandSender)entity));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onLingeringPotionSplash(LingeringPotionSplashEvent e) {
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            if (this.getPlugin().getIWM().inWorld(e.getEntity().getWorld())) {
                this.thrownPotions.put(e.getAreaEffectCloud().getEntityId(), player.getUniqueId());
                Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), () -> this.thrownPotions.remove(e.getAreaEffectCloud().getEntityId()), (long)e.getAreaEffectCloud().getDuration());
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onLingeringPotionDamage(AreaEffectCloudApplyEvent e) {
        if (this.thrownPotions.containsKey(e.getEntity().getEntityId())) {
            User user = User.getInstance(this.thrownPotions.get(e.getEntity().getEntityId()));
            e.getAffectedEntities().removeIf(le -> !le.getUniqueId().equals(user.getUniqueId()) && this.blockPVP(user, (LivingEntity)le, (Event)e, this.getFlag(e.getEntity().getWorld())));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerShootFireworkEvent(EntityShootBowEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (e.getProjectile() instanceof Firework) {
                this.firedFireworks.put(e.getProjectile(), player);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPVPFlagToggle(FlagSettingChangeEvent e) {
        Flag flag = e.getEditedFlag();
        if (Flags.PVP_OVERWORLD.equals(flag) || Flags.PVP_NETHER.equals(flag) || Flags.PVP_END.equals(flag)) {
            String message = "protection.flags." + flag.getID() + "." + (e.isSetTo() ? "enabled" : "disabled");
            e.getIsland().getPlayersOnIsland().forEach(player -> User.getInstance(player).sendMessage(message, new String[0]));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        if (e.getTo() == null) {
            return;
        }
        Island previousIsland = this.getIslands().getIslandAt(e.getFrom()).orElse(null);
        this.getIslands().getIslandAt(e.getTo()).ifPresent(island -> {
            if (island.getMemberSet(200).contains((Object)e.getPlayer().getUniqueId())) {
                return;
            }
            if (e.getFrom().getWorld() == e.getTo().getWorld() && island == previousIsland) {
                return;
            }
            if (island.isAllowed(Flags.PVP_OVERWORLD)) {
                this.alertUser(e.getPlayer(), Flags.PVP_OVERWORLD);
            }
            if (island.isAllowed(Flags.PVP_NETHER)) {
                this.alertUser(e.getPlayer(), Flags.PVP_NETHER);
            }
            if (island.isAllowed(Flags.PVP_END)) {
                this.alertUser(e.getPlayer(), Flags.PVP_END);
            }
        });
    }

    private void alertUser(@NonNull Player player, Flag flag) {
        String message = "protection.flags." + flag.getID() + ".enabled";
        User.getInstance(player).notify(message, new String[0]);
        player.playSound(player.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 2.0f, 1.0f);
    }
}

