/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.worldsettings;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.util.Util;

public class IslandRespawnListener
extends FlagListener {
    private final Map<UUID, UUID> respawn = new HashMap<UUID, UUID>();

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerDeath(PlayerDeathEvent e) {
        World world = Util.getWorld(e.getEntity().getWorld());
        if (world == null || !this.getIWM().inWorld(world)) {
            return;
        }
        if (!Flags.ISLAND_RESPAWN.isSetForWorld(world)) {
            return;
        }
        if (!this.getIslands().hasIsland(world, e.getEntity().getUniqueId()) && !this.getIslands().inTeam(world, e.getEntity().getUniqueId())) {
            return;
        }
        this.respawn.put(e.getEntity().getUniqueId(), world.getUID());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        Location respawnLocation;
        UUID worldUUID = this.respawn.remove(e.getPlayer().getUniqueId());
        if (worldUUID == null) {
            return;
        }
        World world = e.getPlayer().getServer().getWorld(worldUUID);
        if (world == null) {
            return;
        }
        World w = Util.getWorld(world);
        String ownerName = e.getPlayer().getName();
        if (w != null && (respawnLocation = this.getIslands().getHomeLocation(world, e.getPlayer().getUniqueId())) != null && this.getIslands().isSafeLocation(respawnLocation)) {
            e.setRespawnLocation(respawnLocation);
            Island island = BentoBox.getInstance().getIslands().getIsland(w, User.getInstance(e.getPlayer()));
            if (island != null) {
                ownerName = BentoBox.getInstance().getPlayers().getName(island.getOwner());
            }
        }
        Util.runCommands(User.getInstance(e.getPlayer()), ownerName, this.getIWM().getOnRespawnCommands(world), "respawn");
    }
}

