/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.worldsettings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.lists.Flags;

public class ObsidianScoopingListener
extends FlagListener {
    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerInteractEvent(PlayerInteractEvent e) {
        this.onPlayerInteract(e);
    }

    boolean onPlayerInteract(PlayerInteractEvent e) {
        if (!(this.getIWM().inWorld(e.getPlayer().getLocation()) && Flags.OBSIDIAN_SCOOPING.isSetForWorld(e.getPlayer().getWorld()) && e.getPlayer().getGameMode().equals((Object)GameMode.SURVIVAL) && e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && e.getItem() != null && e.getItem().getType().equals((Object)Material.BUCKET) && e.getClickedBlock() != null && e.getClickedBlock().getType().equals((Object)Material.OBSIDIAN) && !e.getClickedBlock().getRelative(e.getBlockFace()).getType().equals((Object)Material.WATER))) {
            return false;
        }
        if (Material.BUCKET.equals((Object)e.getPlayer().getInventory().getItemInOffHand().getType()) && Material.BUCKET.equals((Object)e.getPlayer().getInventory().getItemInMainHand().getType()) && EquipmentSlot.OFF_HAND.equals((Object)e.getHand())) {
            return false;
        }
        return this.lookForLava(e);
    }

    private boolean lookForLava(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        ItemStack bucket = e.getItem();
        RayTraceResult rtBlocks = e.getPlayer().rayTraceBlocks(5.0, FluidCollisionMode.ALWAYS);
        if (rtBlocks == null) {
            return false;
        }
        Block b = rtBlocks.getHitBlock();
        if (!b.getType().equals((Object)Material.OBSIDIAN)) {
            return false;
        }
        User user = User.getInstance(player);
        if (this.getIslands().userIsOnIsland(user.getWorld(), user)) {
            if (this.getBlocksAround(b).stream().anyMatch(block -> block.getType().equals((Object)Material.OBSIDIAN))) {
                user.sendMessage("protection.flags.OBSIDIAN_SCOOPING.obsidian-nearby", new String[0]);
                return false;
            }
            user.sendMessage("protection.flags.OBSIDIAN_SCOOPING.scooping", new String[0]);
            player.getWorld().playSound(player.getLocation(), Sound.ITEM_BUCKET_FILL_LAVA, 1.0f, 1.0f);
            e.setCancelled(true);
            Bukkit.getScheduler().runTask((Plugin)BentoBox.getInstance(), () -> this.givePlayerLava(player, b, bucket));
            return true;
        }
        return false;
    }

    private void givePlayerLava(Player player, Block b, ItemStack bucket) {
        bucket.setAmount(bucket.getAmount() - 1);
        HashMap map = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.LAVA_BUCKET)});
        if (!map.isEmpty()) {
            map.values().forEach(i -> player.getWorld().dropItem(player.getLocation(), i));
        }
        b.setType(Material.AIR);
    }

    private List<Block> getBlocksAround(Block b) {
        ArrayList<Block> blocksAround = new ArrayList<Block>();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    blocksAround.add(b.getWorld().getBlockAt(b.getX() + x, b.getY() + y, b.getZ() + z));
                }
            }
        }
        blocksAround.remove(b);
        return blocksAround;
    }
}

