/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.teleports;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.listeners.teleports.AbstractTeleportListener;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.util.Util;
import world.bentobox.bentobox.util.teleport.ClosestSafeSpotTeleport;

public class EntityTeleportListener
extends AbstractTeleportListener
implements Listener {
    public EntityTeleportListener(@NonNull BentoBox bentoBox) {
        super(bentoBox);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityPortal(EntityPortalEvent event) {
        World fromWorld = event.getFrom().getWorld();
        World overWorld = Util.getWorld(fromWorld);
        if (overWorld == null || !this.plugin.getIWM().inWorld(overWorld) || event.getTo() == null) {
            return;
        }
        if (!Flags.ENTITY_PORTAL_TELEPORT.isSetForWorld(overWorld)) {
            event.setCancelled(true);
            return;
        }
        World.Environment source = fromWorld.getEnvironment();
        World.Environment destination = event.getTo().getWorld().getEnvironment();
        if (World.Environment.NETHER == source && World.Environment.NORMAL == destination || World.Environment.NORMAL == source && World.Environment.NETHER == destination) {
            this.portalProcess(event, World.Environment.NETHER);
        } else if (World.Environment.THE_END == source && World.Environment.NORMAL == destination || World.Environment.NORMAL == source && World.Environment.THE_END == destination) {
            this.portalProcess(event, World.Environment.THE_END);
        } else {
            this.portalProcess(event, event.getTo().getWorld().getEnvironment());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityEnterPortal(EntityPortalEnterEvent event) {
        if (EntityType.PLAYER.equals((Object)event.getEntity().getType())) {
            return;
        }
        Entity entity = event.getEntity();
        Material type = event.getLocation().getBlock().getType();
        UUID uuid = entity.getUniqueId();
        if (entity.getPortalCooldown() > 0) {
            return;
        }
        World fromWorld = event.getLocation().getWorld();
        World overWorld = Util.getWorld(fromWorld);
        if (overWorld == null || !this.plugin.getIWM().inWorld(overWorld)) {
            return;
        }
        if (!Flags.ENTITY_PORTAL_TELEPORT.isSetForWorld(overWorld)) {
            return;
        }
        this.teleportOrigin.put(uuid, fromWorld);
        if (!Bukkit.getAllowNether() && type.equals((Object)Material.NETHER_PORTAL)) {
            this.portalProcess(new EntityPortalEvent(entity, event.getLocation(), event.getLocation(), 0), World.Environment.NETHER);
            return;
        }
        if (!Bukkit.getAllowEnd() && (type.equals((Object)Material.END_PORTAL) || type.equals((Object)Material.END_GATEWAY))) {
            this.portalProcess(new EntityPortalEvent(entity, event.getLocation(), event.getLocation(), 0), World.Environment.THE_END);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityExitPortal(EntityPortalExitEvent event) {
        this.inTeleport.remove(event.getEntity().getUniqueId());
        this.teleportOrigin.remove(event.getEntity().getUniqueId());
    }

    private void portalProcess(EntityPortalEvent event, World.Environment environment) {
        World fromWorld = event.getFrom().getWorld();
        World overWorld = Util.getWorld(fromWorld);
        if (fromWorld == null || overWorld == null) {
            event.setCancelled(true);
            return;
        }
        if (!this.isAllowedInConfig(overWorld, environment)) {
            event.setCancelled(true);
            return;
        }
        if (!this.isAllowedOnServer(environment)) {
            event.setCancelled(true);
        }
        if (this.inTeleport.contains(event.getEntity().getUniqueId())) {
            return;
        }
        this.inTeleport.add(event.getEntity().getUniqueId());
        if (fromWorld.equals((Object)overWorld) && !this.isIslandWorld(overWorld, environment)) {
            this.handleToStandardNetherOrEnd(event, overWorld, environment);
            return;
        }
        if (!fromWorld.equals((Object)overWorld) && !this.isIslandWorld(overWorld, environment)) {
            this.handleFromStandardNetherOrEnd(event, overWorld, environment);
            return;
        }
        World toWorld = !fromWorld.getEnvironment().equals((Object)environment) ? this.getNetherEndWorld(overWorld, environment) : overWorld;
        event.setTo(this.calculateLocation(event.getFrom(), fromWorld, toWorld, environment, this.isMakePortals(overWorld, environment)));
        this.getIsland(event.getTo()).ifPresent(island -> event.setSearchRadius(this.calculateSearchRadius(event.getTo(), (Island)island)));
        if (this.isPastingMissingIslands(overWorld) && this.isAllowedInConfig(overWorld, environment) && this.isIslandWorld(overWorld, environment) && this.getNetherEndWorld(overWorld, environment) != null && this.getIsland(event.getTo()).filter(island -> !this.hasPartnerIsland((Island)island, environment)).map(island -> {
            event.setCancelled(true);
            return true;
        }).orElse(false).booleanValue()) {
            return;
        }
        if (!event.isCancelled()) {
            return;
        }
        if (environment.equals((Object)World.Environment.THE_END)) {
            event.getEntity().setVelocity(new Vector(0, 0, 0));
            event.getEntity().setFallDistance(0.0f);
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (!event.getEntity().getWorld().equals((Object)toWorld)) {
                ClosestSafeSpotTeleport.builder(this.plugin).entity(event.getEntity()).location(event.getTo()).portal().successRunnable(() -> {
                    event.getEntity().setVelocity(new Vector(0, 0, 0));
                    event.getEntity().setFallDistance(0.0f);
                }).build();
            }
        });
    }

    private void handleToStandardNetherOrEnd(EntityPortalEvent event, World overWorld, World.Environment environment) {
        World toWorld = Objects.requireNonNull(this.getNetherEndWorld(overWorld, environment));
        Location spawnPoint = toWorld.getSpawnLocation();
        if (World.Environment.NETHER.equals((Object)toWorld.getEnvironment()) && this.plugin.getIWM().getWorldSettings(overWorld).isMakeNetherPortals()) {
            spawnPoint = event.getFrom().toVector().toLocation(toWorld);
        }
        if (World.Environment.THE_END.equals((Object)toWorld.getEnvironment()) && spawnPoint.getBlockX() == 0 && spawnPoint.getBlockZ() == 0) {
            spawnPoint = new Location(toWorld, 100.0, 50.0, 0.0);
            toWorld.setSpawnLocation(100, 50, 0);
        }
        if (this.isAllowedOnServer(environment)) {
            event.setTo(spawnPoint);
        } else {
            ClosestSafeSpotTeleport.builder(this.plugin).entity(event.getEntity()).location(spawnPoint).portal().build();
        }
    }

    private void handleFromStandardNetherOrEnd(EntityPortalEvent event, World overWorld, World.Environment environment) {
        if (World.Environment.NETHER.equals((Object)environment) && this.plugin.getIWM().getWorldSettings(overWorld).isMakeNetherPortals()) {
            event.setTo(event.getFrom().toVector().toLocation(overWorld));
            this.getIsland(event.getTo()).ifPresent(island -> event.setSearchRadius(this.calculateSearchRadius(event.getTo(), (Island)island)));
        } else {
            Location spawnLocation = this.getSpawnLocation(overWorld);
            event.setTo(spawnLocation == null ? event.getFrom().toVector().toLocation(overWorld) : spawnLocation);
        }
        if (!this.isAllowedOnServer(environment)) {
            event.setCancelled(true);
            ClosestSafeSpotTeleport.builder(this.plugin).entity(event.getEntity()).location(event.getTo()).portal().build();
        }
    }
}

