/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.teleports;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.blueprints.Blueprint;
import world.bentobox.bentobox.blueprints.BlueprintPaster;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBundle;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.listeners.teleports.AbstractTeleportListener;
import world.bentobox.bentobox.util.Util;
import world.bentobox.bentobox.util.teleport.ClosestSafeSpotTeleport;

public class PlayerTeleportListener
extends AbstractTeleportListener
implements Listener {
    public PlayerTeleportListener(@NonNull BentoBox plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerPortal(EntityPortalEnterEvent event) {
        if (!EntityType.PLAYER.equals((Object)event.getEntity().getType())) {
            return;
        }
        Entity entity = event.getEntity();
        Material type = event.getLocation().getBlock().getType();
        UUID uuid = entity.getUniqueId();
        if (this.inPortal.contains(uuid) || !this.plugin.getIWM().inWorld(Util.getWorld(event.getLocation().getWorld()))) {
            return;
        }
        this.inPortal.add(uuid);
        this.teleportOrigin.put(uuid, event.getLocation().getWorld());
        if (!Bukkit.getAllowNether() && type.equals((Object)Material.NETHER_PORTAL)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.inPortal.contains(uuid)) {
                    PlayerPortalEvent en = new PlayerPortalEvent((Player)entity, event.getLocation(), null, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL, 0, false, 0);
                    this.portalProcess(en, World.Environment.NETHER);
                }
            }, 40L);
            return;
        }
        if (!Bukkit.getAllowEnd() && (type.equals((Object)Material.END_PORTAL) || type.equals((Object)Material.END_GATEWAY))) {
            PlayerPortalEvent en = new PlayerPortalEvent((Player)entity, event.getLocation(), null, type.equals((Object)Material.END_PORTAL) ? PlayerTeleportEvent.TeleportCause.END_PORTAL : PlayerTeleportEvent.TeleportCause.END_GATEWAY, 0, false, 0);
            this.portalProcess(en, World.Environment.THE_END);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onExitPortal(PlayerMoveEvent event) {
        if (!this.inPortal.contains(event.getPlayer().getUniqueId())) {
            return;
        }
        if (event.getTo() != null && !event.getTo().getBlock().getType().equals((Object)Material.NETHER_PORTAL)) {
            this.inPortal.remove(event.getPlayer().getUniqueId());
            this.inTeleport.remove(event.getPlayer().getUniqueId());
            this.teleportOrigin.remove(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerExitPortal(PlayerRespawnEvent event) {
        if (!this.teleportOrigin.containsKey(event.getPlayer().getUniqueId())) {
            return;
        }
        World fromWorld = (World)this.teleportOrigin.get(event.getPlayer().getUniqueId());
        World overWorld = Util.getWorld(fromWorld);
        if (overWorld == null || !this.plugin.getIWM().inWorld(overWorld)) {
            return;
        }
        this.getIsland(overWorld, event.getPlayer()).ifPresentOrElse(island -> {
            if (!island.onIsland(event.getRespawnLocation())) {
                Location location = island.getSpawnPoint(World.Environment.NORMAL);
                if (location == null) {
                    location = island.getProtectionCenter();
                }
                event.setRespawnLocation(location);
            }
        }, () -> {
            Location spawnLocation = this.getSpawnLocation(overWorld);
            if (spawnLocation != null) {
                event.setRespawnLocation(spawnLocation);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerPortalEvent(PlayerPortalEvent event) {
        switch (event.getCause()) {
            case NETHER_PORTAL: {
                this.portalProcess(event, World.Environment.NETHER);
                break;
            }
            case END_PORTAL: 
            case END_GATEWAY: {
                this.portalProcess(event, World.Environment.THE_END);
                break;
            }
        }
    }

    private void portalProcess(PlayerPortalEvent event, World.Environment environment) {
        World fromWorld = event.getFrom().getWorld();
        World overWorld = Util.getWorld(fromWorld);
        if (overWorld == null || !this.plugin.getIWM().inWorld(overWorld)) {
            return;
        }
        if (!this.isAllowedInConfig(overWorld, environment)) {
            event.setCancelled(true);
            return;
        }
        if (!this.isAllowedOnServer(environment)) {
            event.setCancelled(true);
        }
        if (this.inTeleport.contains(event.getPlayer().getUniqueId())) {
            return;
        }
        this.inTeleport.add(event.getPlayer().getUniqueId());
        if (fromWorld.equals((Object)overWorld) && !this.isIslandWorld(overWorld, environment)) {
            this.handleToStandardNetherOrEnd(event, overWorld, environment);
            return;
        }
        if (!fromWorld.equals((Object)overWorld) && !this.isIslandWorld(overWorld, environment)) {
            this.handleFromStandardNetherOrEnd(event, overWorld, environment);
            return;
        }
        World toWorld = !fromWorld.getEnvironment().equals((Object)environment) ? this.getNetherEndWorld(overWorld, environment) : overWorld;
        event.setCanCreatePortal(this.isMakePortals(overWorld, environment));
        event.setCreationRadius(2);
        event.setTo(this.calculateLocation(event.getFrom(), fromWorld, toWorld, environment, event.getCanCreatePortal()));
        this.getIsland(event.getTo()).ifPresent(island -> event.setSearchRadius(this.calculateSearchRadius(event.getTo(), (Island)island)));
        if (this.isPastingMissingIslands(overWorld) && this.isAllowedInConfig(overWorld, environment) && this.isIslandWorld(overWorld, environment) && this.getNetherEndWorld(overWorld, environment) != null && this.getIsland(event.getTo()).filter(island -> !this.hasPartnerIsland((Island)island, environment)).map(island -> {
            event.setCancelled(true);
            this.pasteNewIsland(event.getPlayer(), event.getTo(), (Island)island, environment);
            return true;
        }).orElse(false).booleanValue()) {
            return;
        }
        if (!event.isCancelled() && event.getCanCreatePortal()) {
            return;
        }
        if (World.Environment.THE_END.equals((Object)environment)) {
            event.getPlayer().setVelocity(new Vector(0, 0, 0));
            event.getPlayer().setFallDistance(0.0f);
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (!event.getPlayer().getWorld().equals((Object)toWorld)) {
                ClosestSafeSpotTeleport.builder(this.plugin).entity((Entity)event.getPlayer()).location(event.getTo()).portal().successRunnable(() -> {
                    event.getPlayer().setVelocity(new Vector(0, 0, 0));
                    event.getPlayer().setFallDistance(0.0f);
                }).build();
            }
        });
    }

    void handleToStandardNetherOrEnd(PlayerPortalEvent event, World overWorld, World.Environment environment) {
        World toWorld = Objects.requireNonNull(this.getNetherEndWorld(overWorld, environment));
        Location spawnPoint = toWorld.getSpawnLocation();
        if (World.Environment.NETHER.equals((Object)environment) && this.plugin.getIWM().getWorldSettings(overWorld).isMakeNetherPortals()) {
            spawnPoint = event.getFrom().toVector().toLocation(toWorld);
        }
        if (World.Environment.THE_END.equals((Object)environment) && spawnPoint.getBlockX() == 0 && spawnPoint.getBlockZ() == 0) {
            spawnPoint = new Location(toWorld, 100.0, 50.0, 0.0);
            toWorld.setSpawnLocation(100, 50, 0);
        }
        if (this.isAllowedOnServer(environment)) {
            event.setTo(spawnPoint);
        } else {
            ClosestSafeSpotTeleport.builder(this.plugin).entity((Entity)event.getPlayer()).location(spawnPoint).portal().build();
        }
    }

    private void handleFromStandardNetherOrEnd(PlayerPortalEvent event, World overWorld, World.Environment environment) {
        if (World.Environment.NETHER.equals((Object)environment) && this.plugin.getIWM().getWorldSettings(overWorld).isMakeNetherPortals()) {
            event.setTo(event.getFrom().toVector().toLocation(overWorld));
            this.getIsland(event.getTo()).ifPresent(island -> event.setSearchRadius(this.calculateSearchRadius(event.getTo(), (Island)island)));
            event.setCanCreatePortal(true);
        } else {
            Location toLocation = this.getIsland(overWorld, event.getPlayer()).map(island -> island.getSpawnPoint(World.Environment.NORMAL)).orElseGet(() -> {
                Location spawnLocation = this.getSpawnLocation(overWorld);
                return spawnLocation == null ? event.getFrom().toVector().toLocation(overWorld) : spawnLocation;
            });
            event.setTo(toLocation);
        }
        if (!this.isAllowedOnServer(environment)) {
            event.setCancelled(true);
            ClosestSafeSpotTeleport.builder(this.plugin).entity((Entity)event.getPlayer()).location(event.getTo()).portal().build();
        }
    }

    private void pasteNewIsland(Player player, Location to, Island island, World.Environment environment) {
        this.plugin.getIWM().getAddon(island.getWorld()).ifPresent(addon -> {
            BlueprintBundle blueprintBundle = this.plugin.getBlueprintsManager().getDefaultBlueprintBundle((GameModeAddon)addon);
            if (blueprintBundle != null) {
                Blueprint bluePrint = this.plugin.getBlueprintsManager().getBlueprints((GameModeAddon)addon).get(blueprintBundle.getBlueprint(environment));
                if (bluePrint != null) {
                    new BlueprintPaster(this.plugin, bluePrint, to.getWorld(), island).paste().thenAccept(state -> ClosestSafeSpotTeleport.builder(this.plugin).entity((Entity)player).location(island.getSpawnPoint(environment) == null ? to : island.getSpawnPoint(environment)).portal().build());
                } else {
                    this.plugin.logError("Could not paste default island in nether or end. Is there a nether-island or end-island blueprint?");
                }
            }
        });
    }
}

