/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.events.BentoBoxReadyEvent;
import world.bentobox.bentobox.api.events.island.IslandDeleteChunksEvent;
import world.bentobox.bentobox.api.events.island.IslandDeletedEvent;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.database.objects.IslandDeletion;
import world.bentobox.bentobox.managers.IslandChunkDeletionManager;
import world.bentobox.bentobox.util.Util;

public class IslandDeletionManager
implements Listener {
    private final BentoBox plugin;
    private final Database<IslandDeletion> handler;
    private final Set<Location> inDeletion;
    private final IslandChunkDeletionManager islandChunkDeletionManager;

    public IslandDeletionManager(BentoBox plugin) {
        this.plugin = plugin;
        this.handler = new Database<IslandDeletion>(plugin, IslandDeletion.class);
        this.inDeletion = new HashSet<Location>();
        this.islandChunkDeletionManager = new IslandChunkDeletionManager(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBentoBoxReady(BentoBoxReadyEvent e) {
        List<IslandDeletion> toBeDeleted = this.handler.loadObjects();
        ArrayList toBeRemoved = new ArrayList();
        if (!toBeDeleted.isEmpty()) {
            this.plugin.log("There are " + toBeDeleted.size() + " islands pending deletion.");
            toBeDeleted.forEach(di -> {
                if (di.getLocation() == null || di.getLocation().getWorld() == null) {
                    this.plugin.logError("Island queued for deletion refers to a non-existent game world. Skipping...");
                    toBeRemoved.add(di);
                } else {
                    this.plugin.log("Resuming deletion of island at " + di.getLocation().getWorld().getName() + " " + Util.xyz(di.getLocation().toVector()));
                    this.inDeletion.add(di.getLocation());
                    this.islandChunkDeletionManager.add((IslandDeletion)di);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onIslandDelete(IslandDeleteChunksEvent e) {
        this.inDeletion.add(e.getDeletedIslandInfo().getLocation());
        this.handler.saveObjectAsync(e.getDeletedIslandInfo());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onIslandDeleted(IslandDeletedEvent e) {
        this.inDeletion.remove(e.getDeletedIslandInfo().getLocation());
        this.handler.deleteID(e.getDeletedIslandInfo().getUniqueId());
    }

    public boolean inDeletion(Location location) {
        return this.inDeletion.contains(location);
    }

    public IslandChunkDeletionManager getIslandChunkDeletionManager() {
        return this.islandChunkDeletionManager;
    }
}

