/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.PufferFish;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.logs.LogEntry;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.database.json.BentoboxTypeAdapterFactory;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.database.objects.IslandDeletion;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.managers.island.IslandCache;
import world.bentobox.bentobox.multilib.MultiLib;
import world.bentobox.bentobox.util.Util;
import world.bentobox.bentobox.util.teleport.SafeSpotTeleport;

public class IslandsManager {
    private final BentoBox plugin;
    private final Map<World, Island> spawns = new ConcurrentHashMap<World, Island>();
    private final Map<World, Location> last = new ConcurrentHashMap<World, Location>();
    private static Database<Island> handler;
    private @NonNull IslandCache islandCache;
    private final @NonNull List<String> deletedIslands;
    private boolean isSaveTaskRunning;
    private final Set<UUID> goingHome;

    public IslandsManager(@NonNull BentoBox plugin) {
        this.plugin = plugin;
        handler = new Database<Island>(plugin, Island.class);
        this.islandCache = new IslandCache(handler);
        this.deletedIslands = new ArrayList<String>();
        this.goingHome = new HashSet<UUID>();
        MultiLib.onString((Plugin)plugin, "bentobox-updateIsland", id -> {
            Island island = handler.loadObject((String)id);
            if (island != null) {
                this.islandCache.updateMultiLibIsland(island);
            }
        });
        MultiLib.onString((Plugin)plugin, "bentobox-deleteIsland", id -> {
            IslandDeletion idd = (IslandDeletion)this.getGson().fromJson(id, IslandDeletion.class);
            plugin.getIslandDeletionManager().getIslandChunkDeletionManager().add(idd);
        });
        MultiLib.onString((Plugin)plugin, "bentobox-newIsland", id -> {
            Island island = handler.loadObject((String)id);
            if (island != null) {
                this.islandCache.addIsland(island);
            }
        });
        MultiLib.onString((Plugin)plugin, "bentobox-setspawn", sp -> {
            World world;
            String[] split = sp.split(",");
            if (split.length == 1) {
                World world2 = Bukkit.getWorld((String)split[0]);
                this.clearSpawn(world2);
            } else if (split.length == 2 && (world = Bukkit.getWorld((String)split[0])) != null) {
                this.getIslandById(split[1]).ifPresent(this::setSpawn);
            }
        });
    }

    public void setHandler(@NonNull Database<Island> h) {
        handler = h;
    }

    public boolean isSafeLocation(@NonNull Location l) {
        Block ground = l.getBlock().getRelative(BlockFace.DOWN);
        Block space1 = l.getBlock();
        Block space2 = l.getBlock().getRelative(BlockFace.UP);
        return this.checkIfSafe(l.getWorld(), ground.getType(), space1.getType(), space2.getType());
    }

    public CompletableFuture<Boolean> isSafeLocationAsync(@NonNull Location l) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Util.getChunkAtAsync(l).thenRun(() -> {
            Block ground = l.getBlock().getRelative(BlockFace.DOWN);
            Block space1 = l.getBlock();
            Block space2 = l.getBlock().getRelative(BlockFace.UP);
            result.complete(this.checkIfSafe(l.getWorld(), ground.getType(), space1.getType(), space2.getType()));
        });
        return result;
    }

    public boolean checkIfSafe(@Nullable World world, @NonNull Material ground, @NonNull Material space1, @NonNull Material space2) {
        if (world == null || !ground.isSolid() || space1.isSolid() && !Tag.SIGNS.isTagged((Keyed)space1) || space2.isSolid() && !Tag.SIGNS.isTagged((Keyed)space2)) {
            return false;
        }
        if ((space1.equals((Object)Material.WATER) || space2.equals((Object)Material.WATER)) && this.plugin.getIWM().isWaterNotSafe(world)) {
            return false;
        }
        if (ground.equals((Object)Material.LAVA) || space1.equals((Object)Material.LAVA) || space2.equals((Object)Material.LAVA) || Tag.SIGNS.isTagged((Keyed)ground) || Tag.TRAPDOORS.isTagged((Keyed)ground) || Tag.BANNERS.isTagged((Keyed)ground) || Tag.PRESSURE_PLATES.isTagged((Keyed)ground) || Tag.FENCE_GATES.isTagged((Keyed)ground) || Tag.DOORS.isTagged((Keyed)ground) || Tag.FENCES.isTagged((Keyed)ground) || Tag.BUTTONS.isTagged((Keyed)ground) || Tag.ITEMS_BOATS.isTagged((Keyed)ground) || Tag.ITEMS_CHEST_BOATS.isTagged((Keyed)ground) || Tag.CAMPFIRES.isTagged((Keyed)ground) || Tag.FIRE.isTagged((Keyed)ground) || Tag.FIRE.isTagged((Keyed)space1) || space1.equals((Object)Material.END_PORTAL) || space2.equals((Object)Material.END_PORTAL) || space1.equals((Object)Material.END_GATEWAY) || space2.equals((Object)Material.END_GATEWAY)) {
            return false;
        }
        return switch (ground) {
            case Material.ANVIL, Material.BARRIER, Material.CACTUS, Material.END_PORTAL, Material.END_ROD, Material.FIRE, Material.FLOWER_POT, Material.LADDER, Material.LEVER, Material.TALL_GRASS, Material.PISTON_HEAD, Material.MOVING_PISTON, Material.TORCH, Material.WALL_TORCH, Material.TRIPWIRE, Material.WATER, Material.COBWEB, Material.NETHER_PORTAL, Material.MAGMA_BLOCK -> false;
            default -> true;
        };
    }

    public @Nullable Island createIsland(@NonNull Location location) {
        return this.createIsland(location, null);
    }

    public @Nullable Island createIsland(@NonNull Location location, @Nullable UUID owner) {
        return this.createIsland(location, owner, this.plugin.getIWM().getIslandProtectionRange(location.getWorld()));
    }

    public Island createIsland(@NonNull Location location, @Nullable UUID owner, int protectionRange) {
        Island island = new Island(location, owner, protectionRange);
        String gmName = this.plugin.getIWM().getAddon(location.getWorld()).map(gm -> gm.getDescription().getName()).orElse("");
        island.setGameMode(gmName);
        island.setUniqueId(gmName + island.getUniqueId());
        if (this.islandCache.addIsland(island)) {
            IslandsManager.saveIsland(island).thenAccept(b -> {
                if (b.equals(Boolean.TRUE)) {
                    MultiLib.notify("bentobox-newIsland", island.getUniqueId());
                }
            });
            return island;
        }
        return null;
    }

    public void deleteIsland(@NonNull Island island, boolean removeBlocks, @Nullable UUID involvedPlayer) {
        IslandBaseEvent event = IslandEvent.builder().island(island).involvedPlayer(involvedPlayer).reason(IslandEvent.Reason.DELETE).build();
        if (event.getNewEvent().map(IslandBaseEvent::isCancelled).orElse(event.isCancelled()).booleanValue()) {
            return;
        }
        island.setOwner(null);
        island.setFlag(Flags.LOCK, 0);
        if (removeBlocks) {
            this.removePlayersFromIsland(island);
            island.setDeletable(true);
            if (!this.plugin.getSettings().isKeepPreviousIslandOnReset()) {
                this.islandCache.deleteIslandFromCache(island);
                IslandDeletion id = new IslandDeletion(island);
                this.plugin.getIslandDeletionManager().getIslandChunkDeletionManager().add(id);
                MultiLib.notify("bentobox-deleteIsland", this.getGson().toJson((Object)id));
                handler.deleteObject(island);
            } else {
                handler.saveObject(island);
                IslandEvent.builder().deletedIslandInfo(new IslandDeletion(island)).reason(IslandEvent.Reason.DELETED).build();
            }
        }
    }

    public boolean deleteIslandId(String uniqueId) {
        if (handler.objectExists(uniqueId)) {
            handler.deleteID(uniqueId);
            return true;
        }
        return false;
    }

    private Gson getGson() {
        GsonBuilder builder = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().enableComplexMapKeySerialization().setPrettyPrinting();
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new BentoboxTypeAdapterFactory(this.plugin));
        builder.disableHtmlEscaping();
        return builder.create();
    }

    public int getIslandCount() {
        return this.islandCache.size();
    }

    public long getIslandCount(@NonNull World world) {
        return this.islandCache.size(world);
    }

    public @Nullable Island getIsland(@NonNull World world, @Nullable User user) {
        return user == null || user.getUniqueId() == null ? null : this.getIsland(world, user.getUniqueId());
    }

    public @NonNull List<Island> getIslands(@NonNull World world, @NonNull User user) {
        return this.getIslands(world, user.getUniqueId());
    }

    public @NonNull List<Island> getIslands(@NonNull World world, UUID uniqueId) {
        return this.islandCache.getIslands(world, uniqueId);
    }

    public @NonNull List<Island> getIslands(UUID uniqueId) {
        return this.islandCache.getIslands(uniqueId);
    }

    public @NonNull Set<Island> getOwnedIslands(@NonNull World world, @NonNull User user) {
        if (user.getUniqueId() == null) {
            return Collections.emptySet();
        }
        return this.getOwnedIslands(world, user.getUniqueId());
    }

    public @NonNull Set<Island> getOwnedIslands(@NonNull World world, @NonNull UUID uniqueId) {
        return this.islandCache.getIslands(world, uniqueId).stream().filter(island -> uniqueId.equals(island.getOwner())).collect(Collectors.toSet());
    }

    public @Nullable Island getIsland(@NonNull World world, @NonNull UUID uuid) {
        return this.islandCache.getIsland(world, uuid);
    }

    public Optional<Island> getIslandAt(@NonNull Location location) {
        return this.plugin.getIWM().inWorld(location) ? Optional.ofNullable(this.islandCache.getIslandAt(location)) : Optional.empty();
    }

    public boolean isIslandAt(@NonNull Location location) {
        return this.plugin.getIWM().inWorld(location) && this.islandCache.isIslandAt(location);
    }

    public @NonNull Collection<Island> getIslands() {
        return handler.loadObjects().stream().toList();
    }

    public CompletableFuture<List<Island>> getIslandsASync() {
        return handler.loadObjectsASync();
    }

    public @NonNull Collection<Island> getIslands(@NonNull World world) {
        return handler.loadObjects().stream().filter(i -> world.equals((Object)i.getWorld())).toList();
    }

    public Optional<Island> loadIsland(String uniqueID) {
        return Optional.ofNullable(handler.loadObject(uniqueID));
    }

    public @NonNull IslandCache getIslandCache() {
        return this.islandCache;
    }

    public void setIslandCache(@NonNull IslandCache islandCache) {
        this.islandCache = islandCache;
    }

    public @Nullable Location getIslandLocation(@NonNull World world, @NonNull UUID uuid) {
        Island island = this.getIsland(world, uuid);
        return island != null ? island.getProtectionCenter() : null;
    }

    public Location getLast(@NonNull World world) {
        return this.last.get(world);
    }

    public int getMaxMembers(@NonNull Island island, int rank) {
        Integer change;
        int islandMax;
        if (island.getOwner() == null) {
            island.setMaxMembers(null);
            IslandsManager.updateIsland(island);
            return 0;
        }
        int worldDefault = this.plugin.getIWM().getMaxTeamSize(island.getWorld());
        String perm = "team.maxsize";
        if (rank == 200) {
            worldDefault = this.plugin.getIWM().getMaxCoopSize(island.getWorld());
            perm = "coop.maxsize";
        } else if (rank == 400) {
            worldDefault = this.plugin.getIWM().getMaxTrustSize(island.getWorld());
            perm = "trust.maxsize";
        }
        int n = islandMax = island.getMaxMembers(rank) == null ? worldDefault : island.getMaxMembers(rank);
        if (island.getOwner() != null && Bukkit.getPlayer((UUID)island.getOwner()) != null) {
            User owner = User.getInstance(island.getOwner());
            islandMax = owner.getPermissionValue(this.plugin.getIWM().getPermissionPrefix(island.getWorld()) + perm, islandMax);
        }
        Integer n2 = change = islandMax == worldDefault ? null : Integer.valueOf(islandMax);
        if (!Objects.equals(island.getMaxMembers().get(rank), change)) {
            island.setMaxMembers(rank, change);
            IslandsManager.updateIsland(island);
        }
        return islandMax;
    }

    public void setMaxMembers(@NonNull Island island, int rank, Integer maxMembers) {
        island.setMaxMembers(rank, maxMembers);
    }

    public int getMaxHomes(@NonNull Island island) {
        Integer change;
        int islandMax;
        int n = islandMax = island.getMaxHomes() == null ? this.plugin.getIWM().getMaxHomes(island.getWorld()) : island.getMaxHomes().intValue();
        if (island.getOwner() != null && Bukkit.getPlayer((UUID)island.getOwner()) != null) {
            User owner = User.getInstance(island.getOwner());
            islandMax = owner.getPermissionValue(this.plugin.getIWM().getPermissionPrefix(island.getWorld()) + "island.maxhomes", islandMax);
        }
        Integer n2 = change = islandMax == this.plugin.getIWM().getMaxHomes(island.getWorld()) ? null : Integer.valueOf(islandMax);
        if (!Objects.equals(island.getMaxHomes(), change)) {
            island.setMaxHomes(change);
            IslandsManager.updateIsland(island);
        }
        return islandMax;
    }

    public void setMaxHomes(@NonNull Island island, @Nullable Integer maxHomes) {
        island.setMaxHomes(maxHomes);
    }

    public Optional<Island> getProtectedIslandAt(@NonNull Location location) {
        return this.getIslandAt(location).filter(i -> i.onIsland(location));
    }

    private CompletableFuture<Location> getAsyncSafeHomeLocation(@NonNull World world, @NonNull User user, String homeName) {
        Location l;
        CompletableFuture<Location> result = new CompletableFuture<Location>();
        Location islandLoc = this.getIslandLocation(world, user.getUniqueId());
        if (!this.plugin.getIWM().inWorld(world) || islandLoc == null) {
            result.complete(null);
            return result;
        }
        String name = this.getIslands(world, user).stream().filter(i -> !homeName.isBlank() && i.getName() != null && !i.getName().isBlank() && i.getName().equalsIgnoreCase(homeName)).findFirst().map(island -> {
            this.setPrimaryIsland(user.getUniqueId(), (Island)island);
            return "";
        }).orElse(homeName);
        Location defaultHome = this.getHomeLocation(world, user);
        Location namedHome = homeName.isBlank() ? null : this.getHomeLocation(world, user, name);
        Location location = l = namedHome != null ? namedHome : defaultHome;
        if (l != null) {
            Util.getChunkAtAsync(l).thenRun(() -> {
                if (this.isSafeLocation(l)) {
                    result.complete(l);
                    return;
                }
                Location lPlusOne = l.clone().add(new Vector(0, 1, 0));
                if (this.isSafeLocation(lPlusOne)) {
                    this.setHomeLocation(user, lPlusOne, name);
                    result.complete(lPlusOne);
                    return;
                }
                this.tryIsland(result, islandLoc, user, name);
            });
            return result;
        }
        this.tryIsland(result, islandLoc, user, name);
        return result;
    }

    private void tryIsland(CompletableFuture<Location> result, Location islandLoc, @NonNull User user, String name) {
        Util.getChunkAtAsync(islandLoc).thenRun(() -> {
            World w = islandLoc.getWorld();
            if (this.isSafeLocation(islandLoc)) {
                this.setHomeLocation(user, islandLoc, name);
                result.complete(islandLoc.clone().add(new Vector(0.5, 0.0, 0.5)));
                return;
            }
            Location dl = islandLoc.clone().add(new Vector(0.5, 5.0, 2.5));
            if (this.isSafeLocation(dl)) {
                this.setHomeLocation(user, dl, name);
                result.complete(dl);
                return;
            }
            dl = islandLoc.clone().add(new Vector(0.5, 5.0, 0.5));
            if (this.isSafeLocation(dl)) {
                this.setHomeLocation(user, dl, name);
                result.complete(dl);
                return;
            }
            for (int y = islandLoc.getBlockY(); y < w.getMaxHeight(); ++y) {
                dl = new Location(w, islandLoc.getX() + 0.5, (double)y, islandLoc.getZ() + 0.5);
                if (!this.isSafeLocation(dl)) continue;
                this.setHomeLocation(user, dl, name);
                result.complete(dl);
                return;
            }
            result.complete(null);
        });
    }

    public boolean setHomeLocation(@NonNull User user, Location location) {
        return this.setHomeLocation(user.getUniqueId(), location, "");
    }

    public boolean setHomeLocation(@NonNull User user, Location location, String name) {
        return this.setHomeLocation(user.getUniqueId(), location, name);
    }

    public boolean setHomeLocation(@NonNull UUID uuid, Location location, String name) {
        return this.setHomeLocation(this.getIsland(location.getWorld(), uuid), location, name);
    }

    public boolean setHomeLocation(@NonNull UUID uuid, Location location) {
        return this.setHomeLocation(uuid, location, "");
    }

    public boolean setHomeLocation(@Nullable Island island, Location location, String name) {
        if (!(island == null || island.getHome(name) != null && island.getHome(name).equals((Object)location))) {
            island.addHome(name, location);
            IslandsManager.updateIsland(island);
            return true;
        }
        return false;
    }

    public @Nullable Location getHomeLocation(@NonNull World world, @NonNull User user) {
        return this.getPrimaryIsland(world, user.getUniqueId()).getHome("");
    }

    public @Nullable Location getHomeLocation(@NonNull World world, @NonNull UUID uuid) {
        Island is = this.getPrimaryIsland(world, uuid);
        return is == null ? null : is.getHome("");
    }

    public @Nullable Location getHomeLocation(@NonNull World world, @NonNull User user, String name) {
        return this.getHomeLocation(world, user.getUniqueId(), name);
    }

    public @Nullable Location getHomeLocation(@NonNull World world, @NonNull UUID uuid, String name) {
        return this.getIslands(world, uuid).stream().filter(is -> is.getHomes().containsKey(name)).map(is -> is.getHome(name)).findFirst().orElse(null);
    }

    public @NonNull Location getHomeLocation(@NonNull Island island) {
        return this.getHomeLocation(island, "");
    }

    public @NonNull Location getHomeLocation(@NonNull Island island, @NonNull String name) {
        return Objects.requireNonNullElse(island.getHome(name), island.getProtectionCenter());
    }

    public boolean removeHomeLocation(@NonNull Island island, @NonNull String name) {
        return island.removeHome(name);
    }

    public boolean renameHomeLocation(@NonNull Island island, @NonNull String oldName, @NonNull String newName) {
        return island.renameHome(oldName, newName);
    }

    public @NonNull Map<String, Location> getHomeLocations(@NonNull Island island) {
        return island.getHomes();
    }

    public boolean isHomeLocation(@NonNull Island island, @NonNull String name) {
        return island.getHomes().containsKey(name.toLowerCase());
    }

    public int getNumberOfHomesIfAdded(@NonNull Island island, @NonNull String name) {
        return this.isHomeLocation(island, name) ? this.getHomeLocations(island).size() : this.getHomeLocations(island).size() + 1;
    }

    public @NonNull Optional<Island> getSpawn(@NonNull World world) {
        return Optional.ofNullable(this.spawns.get(world));
    }

    public @Nullable Location getSpawnPoint(@NonNull World world) {
        return this.getSpawn(world).map(i -> i.getSpawnPoint(world.getEnvironment())).orElse(null);
    }

    public boolean hasIsland(@NonNull World world, @NonNull User user) {
        return this.islandCache.hasIsland(world, user.getUniqueId());
    }

    public boolean hasIsland(@NonNull World world, @NonNull UUID uuid) {
        return this.islandCache.hasIsland(world, uuid);
    }

    public CompletableFuture<Boolean> homeTeleportAsync(@NonNull World world, @NonNull Player player) {
        return this.homeTeleportAsync(world, player, "", false);
    }

    public CompletableFuture<Boolean> homeTeleportAsync(@NonNull World world, @NonNull Player player, String name) {
        return this.homeTeleportAsync(world, player, name, false);
    }

    public CompletableFuture<Boolean> homeTeleportAsync(@NonNull World world, @NonNull Player player, boolean newIsland) {
        return this.homeTeleportAsync(world, player, "", newIsland);
    }

    private CompletableFuture<Boolean> homeTeleportAsync(@NonNull World world, @NonNull Player player, String name, boolean newIsland) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        User user = User.getInstance(player);
        user.sendMessage("commands.island.go.teleport", new String[0]);
        this.goingHome.add(user.getUniqueId());
        this.readyPlayer(player);
        this.getAsyncSafeHomeLocation(world, user, name).thenAccept(home -> {
            Island island = this.getIsland(world, user);
            if (home == null) {
                new SafeSpotTeleport.Builder(this.plugin).entity((Entity)player).island(island).homeName(name).thenRun(() -> this.teleported(world, user, name, newIsland, island)).ifFail(() -> {
                    this.plugin.logError(user.getName() + " could not be teleported to home because a safe spot could not be found on island " + String.valueOf(island.getCenter()));
                    this.goingHome.remove(user.getUniqueId());
                }).buildFuture().thenAccept(result::complete);
                return;
            }
            Util.teleportAsync((Entity)Objects.requireNonNull(player), home).thenAccept(b -> {
                if (Boolean.TRUE.equals(b)) {
                    this.teleported(world, user, name, newIsland, island);
                    result.complete(true);
                } else {
                    this.goingHome.remove(user.getUniqueId());
                    result.complete(false);
                }
            });
        });
        return result;
    }

    private void teleported(World world, User user, String name, boolean newIsland, Island island) {
        if (!name.isEmpty()) {
            user.sendMessage("commands.island.go.teleported", "[number]", name);
        }
        this.goingHome.remove(user.getUniqueId());
        if (newIsland) {
            if (IslandEvent.builder().involvedPlayer(user.getUniqueId()).reason(IslandEvent.Reason.NEW_ISLAND).island(island).location(island.getCenter()).build().isCancelled()) {
                return;
            }
            if (this.plugin.getIWM().isOnJoinResetEnderChest(world)) {
                user.getPlayer().getEnderChest().clear();
            }
            if (this.plugin.getIWM().isOnJoinResetInventory(world)) {
                user.getPlayer().getInventory().clear();
            }
            if (this.plugin.getSettings().isUseEconomy() && this.plugin.getIWM().isOnJoinResetMoney(world)) {
                this.plugin.getVault().ifPresent(vault -> vault.withdraw(user, vault.getBalance(user)));
            }
            if (this.plugin.getIWM().isOnJoinResetHealth(world)) {
                Util.resetHealth(user.getPlayer());
            }
            if (this.plugin.getIWM().isOnJoinResetHunger(world)) {
                user.getPlayer().setFoodLevel(20);
            }
            if (this.plugin.getIWM().isOnJoinResetXP(world)) {
                user.getPlayer().setLevel(0);
                user.getPlayer().setExp(0.0f);
                user.getPlayer().setTotalExperience(0);
            }
            user.setGameMode(this.plugin.getIWM().getDefaultGameMode(world));
            Util.runCommands(user, user.getName(), this.plugin.getIWM().getOnJoinCommands(world), "join");
        }
        this.goingHome.remove(user.getUniqueId());
    }

    public void spawnTeleport(@NonNull World world, @NonNull Player player) {
        User user = User.getInstance(player);
        Optional<Location> spawnTo = this.getSpawn(world).map(island -> {
            Location spawnPoint = island.getSpawnPoint(World.Environment.NORMAL);
            return spawnPoint != null ? spawnPoint : island.getCenter();
        });
        if (spawnTo.isEmpty()) {
            user.sendMessage("commands.island.spawn.no-spawn", new String[0]);
        } else {
            this.readyPlayer(player);
            user.sendMessage("commands.island.spawn.teleporting", new String[0]);
            new SafeSpotTeleport.Builder(this.plugin).entity((Entity)player).location(spawnTo.get()).build();
        }
    }

    private void readyPlayer(@NonNull Player player) {
        Entity boat;
        player.setGliding(false);
        if (player.isInsideVehicle() && (boat = player.getVehicle()) instanceof Boat) {
            Boat boaty = (Boat)boat;
            player.leaveVehicle();
            boat.remove();
            player.getInventory().addItem(new ItemStack[]{new ItemStack(boaty.getBoatMaterial())});
            player.updateInventory();
        }
    }

    public boolean isAtSpawn(Location playerLoc) {
        return this.getSpawn(playerLoc.getWorld()).map(i -> i.onIsland(playerLoc)).orElse(false);
    }

    public void setSpawn(@NonNull Island spawn) {
        if (spawn.getWorld() != null) {
            spawn.setSpawn(true);
            this.spawns.put(Util.getWorld(spawn.getWorld()), spawn);
            MultiLib.notify("bentobox-setspawn", String.valueOf(spawn.getWorld().getUID()) + "," + spawn.getUniqueId());
        }
    }

    public void clearSpawn(World world) {
        if (this.spawns.containsKey(world)) {
            this.spawns.get(world).setSpawn(false);
            this.spawns.remove(world);
            MultiLib.notify("bentobox-setspawn", world.getUID().toString());
        }
    }

    @Deprecated(since="2.0", forRemoval=true)
    public boolean isOwner(@NonNull World world, @NonNull UUID uniqueId) {
        return this.hasIsland(world, uniqueId);
    }

    public void load() throws IOException {
        this.islandCache.clear();
        for (Island island : handler.loadObjects()) {
            if (island == null) {
                this.plugin.logWarning("Null island when loading...");
                continue;
            }
            if (!island.isDeleted()) {
                if (!this.plugin.getSettings().isOverrideSafetyCheck() && this.plugin.getIWM().getAddon(island.getWorld()).map(GameModeAddon::isEnforceEqualRanges).orElse(true).booleanValue() && island.getWorld() != null && this.plugin.getIWM().inWorld(island.getWorld()) && island.getRange() != this.plugin.getIWM().getIslandDistance(island.getWorld())) {
                    throw new IOException("Island distance mismatch!\nWorld '" + island.getWorld().getName() + "' distance " + this.plugin.getIWM().getIslandDistance(island.getWorld()) + " != island range " + island.getRange() + "!\nIsland ID in database is " + island.getUniqueId() + ".\nIsland distance in config.yml cannot be changed mid-game! Fix config.yml or clean database.");
                }
                if (!this.plugin.getSettings().isOverrideSafetyCheck() && this.plugin.getIWM().getAddon(island.getWorld()).map(GameModeAddon::isFixIslandCenter).orElse(true).booleanValue()) {
                    this.fixIslandCenter(island);
                }
                this.islandCache.addIsland(island, true);
                if (island.isSpawn()) {
                    this.setSpawn(island);
                } else {
                    island.getFlags().keySet().removeIf(f -> f.startsWith("NULL_FLAG"));
                }
            }
            if (island.getGameMode() != null) continue;
            island.setGameMode(this.plugin.getIWM().getAddon(island.getWorld()).map(gm -> gm.getDescription().getName()).orElse(""));
        }
    }

    boolean fixIslandCenter(Island island) {
        World world = island.getWorld();
        if (world == null || island.getCenter() == null || !this.plugin.getIWM().inWorld(world)) {
            return false;
        }
        int distance = this.plugin.getIWM().getIslandDistance(island.getWorld()) * 2;
        long x = (long)island.getCenter().getBlockX() - (long)this.plugin.getIWM().getIslandXOffset(world) - (long)this.plugin.getIWM().getIslandStartX(world);
        long z = (long)island.getCenter().getBlockZ() - (long)this.plugin.getIWM().getIslandZOffset(world) - (long)this.plugin.getIWM().getIslandStartZ(world);
        if (x % (long)distance != 0L || z % (long)distance != 0L) {
            x = Math.round((double)x / (double)distance) * (long)distance + (long)this.plugin.getIWM().getIslandXOffset(world) + (long)this.plugin.getIWM().getIslandStartX(world);
            z = Math.round((double)z / (double)distance) * (long)distance + (long)this.plugin.getIWM().getIslandZOffset(world) + (long)this.plugin.getIWM().getIslandStartZ(world);
            island.setCenter(new Location(world, (double)x, (double)island.getCenter().getBlockY(), (double)z));
            return true;
        }
        return false;
    }

    public boolean locationIsOnIsland(Player player, Location loc) {
        if (player == null) {
            return false;
        }
        return player.isOp() || this.getIslandAt(loc).filter(i -> i.onIsland(loc)).map(i -> i.inTeam(player.getUniqueId())).orElse(false) != false;
    }

    public boolean userIsOnIsland(World world, User user) {
        if (user == null || !user.isPlayer() || world == null) {
            return false;
        }
        return user.getLocation().getWorld() == world && this.getProtectedIslandAt(user.getLocation()).map(i -> i.getMembers().entrySet().stream().anyMatch(en -> ((UUID)en.getKey()).equals(user.getUniqueId()) && (Integer)en.getValue() > 0)).orElse(false) != false;
    }

    public void removePlayer(World world, User user) {
        this.removePlayer(world, user.getUniqueId());
    }

    public void removePlayer(World world, UUID uuid) {
        this.islandCache.removePlayer(world, uuid).forEach(handler::saveObjectAsync);
    }

    public void removePlayer(Island island, UUID uuid) {
        this.islandCache.removePlayer(island, uuid);
    }

    public void removePlayersFromIsland(Island island) {
        World w = island.getWorld();
        Bukkit.getOnlinePlayers().stream().filter(p -> p.getGameMode().equals((Object)this.plugin.getIWM().getDefaultGameMode(island.getWorld()))).filter(p -> island.onIsland(p.getLocation())).forEach(p -> {
            if (!island.inTeam(p.getUniqueId()) && (this.hasIsland(w, p.getUniqueId()) || this.inTeam(w, p.getUniqueId()))) {
                this.homeTeleportAsync(w, (Player)p);
            } else {
                this.getSpawn(w).map(i -> i.getSpawnPoint(w.getEnvironment())).filter(Objects::nonNull).ifPresentOrElse(sp -> Util.teleportAsync((Entity)p, sp), () -> this.plugin.logWarning("Spawn exists but its location is null!"));
            }
        });
    }

    public boolean isSaveTaskRunning() {
        return this.isSaveTaskRunning;
    }

    public void saveAll() {
        this.saveAll(false);
    }

    public void saveAll(boolean schedule) {
        if (!schedule) {
            for (Island island : this.islandCache.getCachedIslands()) {
                if (!island.isChanged()) continue;
                try {
                    IslandsManager.saveIsland(island);
                }
                catch (Exception e) {
                    this.plugin.logError("Could not save island to database when running sync! " + e.getMessage());
                }
            }
            return;
        }
        this.isSaveTaskRunning = true;
        final LinkedList<Island> queue = new LinkedList<Island>(this.islandCache.getCachedIslands());
        new BukkitRunnable(){

            public void run() {
                for (int i = 0; i < IslandsManager.this.plugin.getSettings().getMaxSavedIslandsPerTick(); ++i) {
                    Island island = (Island)queue.poll();
                    if (island == null) {
                        IslandsManager.this.isSaveTaskRunning = false;
                        this.cancel();
                        return;
                    }
                    if (!island.isChanged()) continue;
                    try {
                        IslandsManager.saveIsland(island);
                        continue;
                    }
                    catch (Exception e) {
                        IslandsManager.this.plugin.logError("Could not save island to database when running sync! " + e.getMessage());
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void setJoinTeam(Island teamIsland, UUID playerUUID) {
        teamIsland.addMember(playerUUID);
        this.islandCache.addPlayer(playerUUID, teamIsland);
        teamIsland.log(new LogEntry.Builder(LogEntry.LogType.JOINED).data(playerUUID.toString(), "player").build());
        IslandsManager.updateIsland(teamIsland);
    }

    public void setLast(Location last) {
        this.last.put(last.getWorld(), last);
    }

    public void shutdown() {
        this.plugin.log("Removing coops from islands...");
        this.islandCache.getCachedIslands().forEach(i -> i.getMembers().values().removeIf(p -> p == 200));
        this.plugin.log("Saving islands - this has to be done sync so it may take a while with a lot of islands...");
        this.saveAll();
        this.plugin.log("Islands saved.");
        this.islandCache.clear();
        this.plugin.log("Closing database.");
        handler.close();
    }

    public boolean inTeam(World world, @NonNull UUID playerUUID) {
        return this.islandCache.getIslands(world, playerUUID).stream().anyMatch(island -> island.getMemberSet().size() > 1 && island.inTeam(playerUUID));
    }

    public void setOwner(World world, User user, UUID targetUUID) {
        this.setOwner(user, targetUUID, this.getIsland(world, user.getUniqueId()), 900);
    }

    public void setOwner(User user, UUID targetUUID, Island island, int rank) {
        if (rank >= 1000) {
            this.plugin.logWarning("Setowner: previous owner's rank cannot be higher than SubOwner");
            rank = 900;
        }
        if (rank > 0 && island.getOwner() != null) {
            island.setRank(island.getOwner(), rank);
        }
        this.islandCache.setOwner(island, targetUUID);
        user.sendMessage("commands.island.team.setowner.name-is-the-owner", "[name]", this.plugin.getPlayers().getName(targetUUID));
        this.plugin.getIWM().getAddon(island.getWorld()).ifPresent(addon -> {
            int range;
            User target = User.getInstance(targetUUID);
            target.sendMessage("commands.island.team.setowner.you-are-the-owner", new String[0]);
            if (target.isOnline() && target.getEffectivePermissions().parallelStream().map(PermissionAttachmentInfo::getPermission).anyMatch(p -> p.startsWith(addon.getPermissionPrefix() + "island.range")) && (range = target.getPermissionValue(addon.getPermissionPrefix() + "island.range", this.plugin.getIWM().getIslandProtectionRange(Util.getWorld(island.getWorld())))) != island.getProtectionRange()) {
                user.sendMessage("commands.admin.setrange.range-updated", "[number]", String.valueOf(range));
                target.sendMessage("commands.admin.setrange.range-updated", "[number]", String.valueOf(range));
                this.plugin.log("Setowner: Island protection range changed from " + island.getProtectionRange() + " to " + range + " for " + user.getName() + " due to permission.");
                int oldRange = island.getProtectionRange();
                island.setProtectionRange(range);
                IslandEvent.builder().island(island).location(island.getCenter()).reason(IslandEvent.Reason.RANGE_CHANGE).involvedPlayer(targetUUID).admin(true).protectionRange(range, oldRange).build();
            }
        });
    }

    public void clearArea(Location loc) {
        if (!this.plugin.getIWM().inWorld(loc)) {
            return;
        }
        loc.getWorld().getNearbyEntities(loc, (double)this.plugin.getSettings().getClearRadius(), (double)this.plugin.getSettings().getClearRadius(), (double)this.plugin.getSettings().getClearRadius()).stream().filter(LivingEntity.class::isInstance).filter(en -> Util.isHostileEntity(en) && !this.plugin.getIWM().getRemoveMobsWhitelist(loc.getWorld()).contains(en.getType()) && !(en instanceof PufferFish) && ((LivingEntity)en).getRemoveWhenFarAway()).filter(en -> en.customName() == null).forEach(Entity::remove);
    }

    public void clearRank(int rank, UUID uniqueId) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.clearRankSync(rank, uniqueId));
    }

    void clearRankSync(int rank, UUID uniqueId) {
        this.islandCache.getCachedIslands().forEach(i -> i.getMembers().entrySet().removeIf(e -> ((UUID)e.getKey()).equals(uniqueId) && (Integer)e.getValue() == rank));
    }

    public static void updateIsland(Island island) {
        if (handler != null && handler.objectExists(island.getUniqueId())) {
            island.clearChanged();
            IslandsManager.saveIsland(island).thenAccept(b -> MultiLib.notify("bentobox-updateIsland", island.getUniqueId()));
        }
    }

    public static CompletableFuture<Boolean> saveIsland(Island island) {
        return handler.saveObjectAsync(island);
    }

    public @NonNull Optional<Island> getIslandById(String uniqueId) {
        return Optional.ofNullable(this.islandCache.getIslandById(uniqueId));
    }

    public @NonNull Optional<Island> getIslandById(String uniqueId, boolean cache) {
        return Optional.ofNullable(this.islandCache.getIslandById(uniqueId, cache));
    }

    public boolean isIslandId(String uniqueId) {
        return this.islandCache.isIslandId(uniqueId);
    }

    public void resetAllFlags(World world) {
        this.islandCache.resetAllFlags(world);
        this.saveAll();
    }

    public void resetFlag(World world, Flag flag) {
        this.islandCache.resetFlag(world, flag);
        this.saveAll();
    }

    public boolean isGoingHome(User user) {
        return this.goingHome.contains(user.getUniqueId());
    }

    public int getNumberOfConcurrentIslands(UUID uuid, World world) {
        return this.islandCache.getIslands(world, uuid).size();
    }

    public void setPrimaryIsland(UUID uuid, Island i) {
        this.getIslandCache().setPrimaryIsland(uuid, i);
    }

    public Island getPrimaryIsland(World world, UUID uuid) {
        return this.getIslandCache().getIsland(world, uuid);
    }
}

