/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.multilib.bukkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import world.bentobox.bentobox.multilib.DataStorageImpl;
import world.bentobox.bentobox.multilib.MultiLibImpl;
import world.bentobox.bentobox.multilib.bukkit.BukkitDataStorageImpl;
import world.bentobox.bentobox.multilib.bukkit.StoredData;

public class BukkitImpl
implements MultiLibImpl {
    private final Map<UUID, StoredData> data = new HashMap<UUID, StoredData>();
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    private final BukkitDataStorageImpl dataStorage = new BukkitDataStorageImpl();
    private final Map<String, List<BiConsumer<byte[], BiConsumer<String, byte[]>>>> notificationListeners = new ConcurrentHashMap<String, List<BiConsumer<byte[], BiConsumer<String, byte[]>>>>();

    public BukkitImpl() {
        final JavaPlugin plugin = JavaPlugin.getProvidingPlugin(this.getClass());
        plugin.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onDisable(PluginDisableEvent event) {
                if (event.getPlugin() == plugin) {
                    BukkitImpl.this.data.forEach((key, value) -> value.save());
                }
            }
        }, (Plugin)plugin);
    }

    @Override
    public boolean isChunkExternal(World world, int cx, int cz) {
        return false;
    }

    @Override
    public boolean isChunkExternal(Location location) {
        return false;
    }

    @Override
    public boolean isChunkExternal(Entity entity) {
        return false;
    }

    @Override
    public boolean isChunkExternal(Block block) {
        return false;
    }

    @Override
    public boolean isChunkExternal(Chunk chunk) {
        return false;
    }

    @Override
    public boolean isChunkLocal(World world, int cx, int cz) {
        return true;
    }

    @Override
    public boolean isChunkLocal(Location location) {
        return true;
    }

    @Override
    public boolean isChunkLocal(Entity entity) {
        return true;
    }

    @Override
    public boolean isChunkLocal(Block block) {
        return true;
    }

    @Override
    public boolean isChunkLocal(Chunk chunk) {
        return true;
    }

    @Override
    public boolean isExternalPlayer(Player player) {
        return false;
    }

    @Override
    public boolean isLocalPlayer(Player player) {
        return true;
    }

    @Override
    @NotNull
    public String getLocalServerName() {
        return "bukkit";
    }

    @Override
    public String getExternalServerName(Player player) {
        return null;
    }

    @Override
    public String getData(Player player, String key) {
        return this.data.containsKey(player.getUniqueId()) ? this.data.get(player.getUniqueId()).getData(player, key) : null;
    }

    @Override
    public void setData(Player player, String key, String value) {
        this.data.computeIfAbsent(player.getUniqueId(), playerKey -> new StoredData(player.getUniqueId(), player.getLastLogin(), this.scheduler)).setData(player, key, value);
    }

    @Override
    public String getPersistentData(Player player, String key) {
        return this.data.containsKey(player.getUniqueId()) ? this.data.get(player.getUniqueId()).getPersistentData(key) : null;
    }

    @Override
    public void setPersistentData(Player player, String key, String value) {
        this.data.computeIfAbsent(player.getUniqueId(), playerKey -> new StoredData(player.getUniqueId(), player.getLastLogin(), this.scheduler)).setPersistentData(key, value);
    }

    @Override
    public void on(Plugin plugin, String channel, Consumer<byte[]> callback) {
        this.notificationListeners.computeIfAbsent(channel, key -> new ArrayList()).add((data, reply) -> callback.accept((byte[])data));
    }

    @Override
    public void on(Plugin plugin, String channel, BiConsumer<byte[], BiConsumer<String, byte[]>> callbackWithReply) {
        this.notificationListeners.computeIfAbsent(channel, key -> new ArrayList()).add(callbackWithReply);
    }

    @Override
    public void notify(String channel, byte[] data) {
    }

    @Override
    public void notify(Chunk chunk, String channel, byte[] data) {
    }

    @Override
    public void notifyOwningServer(Chunk chunk, String channel, byte[] data) {
        this.processNotification(channel, data);
    }

    @Override
    public void notifyOwningServer(Player player, String channel, byte[] data) {
        this.processNotification(channel, data);
    }

    private void processNotification(String channel, byte[] data) {
        this.notificationListeners.getOrDefault(channel, Collections.emptyList()).forEach(listener -> listener.accept(data, (replyChannel, replyData) -> this.processNotification((String)replyChannel, (byte[])replyData)));
    }

    @Override
    public void chatOnOtherServers(Player player, String message) {
    }

    @Override
    public Collection<? extends Player> getAllOnlinePlayers() {
        return Bukkit.getOnlinePlayers();
    }

    @Override
    public DataStorageImpl getDataStorage() {
        return this.dataStorage;
    }
}

