/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.panels;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.builders.PanelBuilder;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.Blueprint;
import world.bentobox.bentobox.blueprints.conversation.DescriptionPrompt;
import world.bentobox.bentobox.blueprints.conversation.NameConversationPrefix;
import world.bentobox.bentobox.blueprints.conversation.NamePrompt;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBundle;
import world.bentobox.bentobox.panels.IconChanger;
import world.bentobox.bentobox.util.Util;

public class BlueprintManagementPanel {
    private final BentoBox plugin;
    private final Blueprint normalBlueprint;
    private final Blueprint netherBlueprint;
    private final Blueprint endBlueprint;
    private final Map<Integer, World.Environment> slotToEnvironment;
    private final Map<World.Environment, Blueprint> environmentToBlueprint;
    private static final int MAX_WORLD_SLOT = 9;
    private static final int MIN_WORLD_SLOT = 0;
    public static final int MAX_BP_SLOT = 35;
    private static final String INSTRUCTION = "instruction";
    private Map.Entry<Integer, Blueprint> selected;
    private final Map<Integer, Blueprint> blueprints = new HashMap<Integer, Blueprint>();
    private final User user;
    private final GameModeAddon addon;

    public BlueprintManagementPanel(@NonNull BentoBox plugin, @NonNull User user, @NonNull GameModeAddon addon) {
        this.plugin = plugin;
        this.user = user;
        this.addon = addon;
        this.normalBlueprint = new Blueprint().setIcon(Material.GREEN_STAINED_GLASS_PANE).setName(user.getTranslation("general.worlds.overworld", new String[0])).setDescription(this.t(INSTRUCTION));
        this.netherBlueprint = new Blueprint().setIcon(Material.RED_STAINED_GLASS_PANE).setName(user.getTranslation("general.worlds.nether", new String[0])).setDescription(this.t(INSTRUCTION));
        this.endBlueprint = new Blueprint().setIcon(Material.YELLOW_STAINED_GLASS_PANE).setName(user.getTranslation("general.worlds.the-end", new String[0])).setDescription(this.t(INSTRUCTION));
        this.slotToEnvironment = Map.of(3, World.Environment.NORMAL, 5, World.Environment.NETHER, 7, World.Environment.THE_END);
        this.environmentToBlueprint = Map.of(World.Environment.NORMAL, this.normalBlueprint, World.Environment.NETHER, this.netherBlueprint, World.Environment.THE_END, this.endBlueprint);
    }

    private String t(String t) {
        return this.user.getTranslation("commands.admin.blueprint.management." + t, new String[0]);
    }

    private String t(String t, String ... vars) {
        return this.user.getTranslation("commands.admin.blueprint.management." + t, vars);
    }

    public void openPanel() {
        PanelBuilder pb = new PanelBuilder().name(this.t("title")).user(this.user).size(45);
        pb.item(36, this.getNewBundle(this.addon));
        Comparator sortByDisplayName = (p, o) -> p.getDisplayName().compareToIgnoreCase(o.getDisplayName());
        this.plugin.getBlueprintsManager().getBlueprintBundles(this.addon).values().stream().limit(36L).sorted(sortByDisplayName).forEach(bb -> {
            PanelItem item = new PanelItemBuilder().name(bb.getDisplayName()).description(this.t("edit"), this.t("rename")).icon(bb.getIcon()).clickHandler((panel, u, clickType, slot) -> {
                u.closeInventory();
                if (clickType.equals((Object)ClickType.RIGHT)) {
                    this.askForName((Conversable)u.getPlayer(), this.addon, (BlueprintBundle)bb);
                } else {
                    this.openBB((BlueprintBundle)bb);
                }
                return true;
            }).build();
            if (bb.getSlot() < 0 || bb.getSlot() > 35) {
                bb.setSlot(0);
            }
            if (pb.slotOccupied(bb.getSlot())) {
                int slot2 = BlueprintManagementPanel.getFirstAvailableSlot(pb);
                if (slot2 == -1) {
                    this.plugin.logError("Too many blueprint bundles to show!");
                    pb.item(item);
                } else {
                    pb.item(slot2, item);
                }
            } else {
                pb.item(bb.getSlot(), item);
            }
        });
        pb.build();
    }

    private static int getFirstAvailableSlot(PanelBuilder pb) {
        for (int i = 0; i < 35; ++i) {
            if (pb.slotOccupied(i)) continue;
            return i;
        }
        return -1;
    }

    public void openBB(BlueprintBundle bb) {
        int index = 18;
        for (Blueprint bp : this.plugin.getBlueprintsManager().getBlueprints(this.addon).values()) {
            this.blueprints.put(index++, bp);
        }
        PanelBuilder pb = new PanelBuilder().name(bb.getDisplayName()).user(this.user).size(45).listener(new IconChanger(this.plugin, this.addon, this, bb));
        pb.item(0, this.getBundleIcon(bb));
        this.slotToEnvironment.forEach((k, v) -> {
            String bpName = bb.getBlueprint((World.Environment)v);
            pb.item(k - 1, this.getWorldInstrTile((World.Environment)v));
            pb.item((int)k, this.getBlueprintItem(this.addon, (int)k, bb, this.plugin.getBlueprintsManager().getBlueprints(this.addon).getOrDefault(bpName, this.environmentToBlueprint.get(v))));
        });
        for (int i = 9; i < 18; ++i) {
            pb.item(i, new PanelItemBuilder().icon(Material.BLACK_STAINED_GLASS_PANE).name(" ").build());
        }
        this.blueprints.entrySet().stream().limit(18L).forEach(b -> pb.item(this.getBlueprintItem(this.addon, (Integer)b.getKey(), bb, (Blueprint)b.getValue())));
        if (bb.getUniqueId().equals("default")) {
            pb.item(36, this.getNoTrashIcon());
            pb.item(39, this.getNoPermissionIcon());
        } else {
            pb.item(36, this.getTrashIcon(this.addon, bb));
            pb.item(39, this.getPermissionIcon(this.addon, bb));
        }
        if (this.plugin.getSettings().getIslandNumber() > 1) {
            pb.item(42, this.getTimesIcon(bb));
        }
        pb.item(40, this.getSlotIcon(this.addon, bb));
        pb.item(44, new PanelItemBuilder().icon(Material.OAK_DOOR).name(this.t("back")).clickHandler((panel, u, clickType, slot) -> {
            this.openPanel();
            return true;
        }).build());
        pb.build();
    }

    private PanelItem getTimesIcon(BlueprintBundle bb) {
        return new PanelItemBuilder().icon(Material.CLOCK).name(this.t("times")).description(bb.getTimes() == 0 ? this.t("unlimited-times") : this.t("maximum-times", "[number]", String.valueOf(bb.getTimes()))).clickHandler((panel, u, clickType, slot) -> {
            u.getPlayer().playSound(u.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            if (clickType == ClickType.LEFT) {
                bb.setTimes(bb.getTimes() + 1);
            } else if (clickType == ClickType.RIGHT && bb.getTimes() > 0) {
                bb.setTimes(bb.getTimes() - 1);
            }
            this.plugin.getBlueprintsManager().saveBlueprintBundle(this.addon, bb);
            panel.getInventory().setItem(42, this.getTimesIcon(bb).getItem());
            return true;
        }).build();
    }

    private PanelItem getSlotIcon(GameModeAddon addon, BlueprintBundle bb) {
        return new PanelItemBuilder().name(this.t("slot", "[number]", String.valueOf(bb.getSlot()))).description(this.t("slot-instructions")).icon(Material.IRON_TRAPDOOR).clickHandler((panel, u, clickType, slot) -> {
            if (clickType.isLeftClick()) {
                bb.setSlot(bb.getSlot() + 1);
                if (bb.getSlot() > 35) {
                    bb.setSlot(0);
                }
            } else if (clickType.isRightClick()) {
                bb.setSlot(bb.getSlot() - 1);
                if (bb.getSlot() < 0) {
                    bb.setSlot(35);
                }
            }
            u.getPlayer().playSound(u.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.plugin.getBlueprintsManager().saveBlueprintBundle(addon, bb);
            panel.getInventory().setItem(40, this.getSlotIcon(addon, bb).getItem());
            return true;
        }).build();
    }

    protected PanelItem getBundleIcon(BlueprintBundle bb) {
        return new PanelItemBuilder().name(this.t("edit-description")).description(bb.getDescription().stream().map(Util::translateColorCodes).toList()).icon(bb.getIcon()).clickHandler((panel, u, clickType, slot) -> {
            u.closeInventory();
            this.askForDescription((Conversable)u.getPlayer(), this.addon, bb);
            return true;
        }).build();
    }

    private PanelItem getWorldInstrTile(World.Environment env) {
        Material icon;
        return new PanelItemBuilder().name(this.t("world-name-syntax", "[name]", switch (env) {
            case World.Environment.NORMAL -> {
                icon = Material.GRASS_BLOCK;
                yield this.normalBlueprint.getName();
            }
            case World.Environment.NETHER -> {
                icon = Material.NETHERRACK;
                yield this.netherBlueprint.getName();
            }
            case World.Environment.THE_END -> {
                icon = Material.END_STONE;
                yield this.endBlueprint.getName();
            }
            default -> {
                icon = Material.STONE;
                yield Util.prettifyText(env.name());
            }
        })).description(this.t("world-instructions")).glow(true).icon(icon).build();
    }

    private PanelItem getTrashIcon(@NonNull GameModeAddon addon, BlueprintBundle bb) {
        return new PanelItemBuilder().name(this.t("trash")).description(this.t("trash-instructions")).icon(Material.TNT).clickHandler((panel, u, clickType, slot) -> {
            if (clickType.equals((Object)ClickType.RIGHT)) {
                u.getPlayer().playSound(u.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
                this.plugin.getBlueprintsManager().deleteBlueprintBundle(addon, bb);
                this.openPanel();
            }
            return true;
        }).build();
    }

    private PanelItem getNoTrashIcon() {
        return new PanelItemBuilder().name(this.t("no-trash")).description(this.t("no-trash-instructions")).icon(Material.TNT).build();
    }

    private PanelItem getPermissionIcon(@NonNull GameModeAddon addon, BlueprintBundle bb) {
        return new PanelItemBuilder().icon(Material.PAINTING).name(this.t("permission")).description(bb.isRequirePermission() ? this.t("perm-required") : this.t("perm-not-required")).description((String)(bb.isRequirePermission() ? this.t("perm-format") + addon.getPermissionPrefix() + "island.create." + bb.getUniqueId() : "")).clickHandler((panel, u, clickType, slot) -> {
            u.getPlayer().playSound(u.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            bb.setRequirePermission(!bb.isRequirePermission());
            this.plugin.getBlueprintsManager().saveBlueprintBundle(addon, bb);
            panel.getInventory().setItem(39, this.getPermissionIcon(addon, bb).getItem());
            return true;
        }).build();
    }

    private PanelItem getNoPermissionIcon() {
        return new PanelItemBuilder().icon(Material.PAINTING).name(this.t("no-permission")).description(this.t("no-perm-required")).build();
    }

    protected PanelItem getBlueprintItem(GameModeAddon addon, int pos, BlueprintBundle bb, Blueprint blueprint) {
        ArrayList<String> desc = blueprint.getDescription() == null ? new ArrayList() : blueprint.getDescription();
        desc = desc.stream().map(Util::translateColorCodes).collect(Collectors.toList());
        if (!(blueprint.equals(this.endBlueprint) || blueprint.equals(this.normalBlueprint) || blueprint.equals(this.netherBlueprint))) {
            if (pos > 0 && pos < 9) {
                desc.add(this.t("remove"));
            } else {
                desc.add(this.t("blueprint-instruction"));
            }
        }
        return new PanelItemBuilder().name(blueprint.getDisplayName() == null ? blueprint.getName() : blueprint.getDisplayName()).description(desc).icon(blueprint.getIcon()).glow(this.selected != null && pos == this.selected.getKey()).clickHandler((panel, u, clickType, slot) -> {
            if (slot > 0 && slot < 9) {
                if (clickType.equals((Object)ClickType.RIGHT)) {
                    u.getPlayer().playSound(u.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
                    bb.clearBlueprint(this.slotToEnvironment.get(slot));
                    this.plugin.getBlueprintsManager().saveBlueprintBundle(addon, bb);
                    this.openBB(bb);
                } else if (this.selected == null) {
                    u.sendMessage("commands.admin.blueprint.management.select-first", new String[0]);
                    u.getPlayer().playSound(u.getLocation(), Sound.BLOCK_ANVIL_HIT, 1.0f, 1.0f);
                } else {
                    u.getPlayer().playSound(u.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
                    Blueprint bp = this.selected.getValue();
                    bb.setBlueprint(this.slotToEnvironment.get(slot), bp);
                    this.plugin.getBlueprintsManager().saveBlueprintBundle(addon, bb);
                    this.openBB(bb);
                }
            } else if (this.blueprints.containsKey(slot)) {
                if (clickType.equals((Object)ClickType.RIGHT)) {
                    u.closeInventory();
                    this.askForBlueprintName((Conversable)u.getPlayer(), addon, blueprint, bb);
                    return true;
                }
                this.selected = this.selected != null && slot == this.selected.getKey() ? null : new AbstractMap.SimpleEntry<Integer, Blueprint>(slot, this.blueprints.get(slot));
                u.getPlayer().playSound(u.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 2.0f);
                this.openBB(bb);
            }
            return true;
        }).build();
    }

    private PanelItem getNewBundle(@NonNull GameModeAddon addon) {
        return new PanelItemBuilder().name(this.t("new-bundle")).description(this.t("new-bundle-instructions")).icon(Material.GREEN_BANNER).clickHandler((panel, u, clickType, slot) -> {
            u.closeInventory();
            this.askForName((Conversable)u.getPlayer(), addon, null);
            return true;
        }).build();
    }

    public void askForName(Conversable whom, GameModeAddon addon, BlueprintBundle bb) {
        new ConversationFactory((Plugin)BentoBox.getInstance()).withModality(true).withLocalEcho(false).withPrefix((ConversationPrefix)new NameConversationPrefix()).withTimeout(90).withFirstPrompt((Prompt)new NamePrompt(addon, bb)).withEscapeSequence(this.t("name.quit")).buildConversation(whom).begin();
    }

    public void askForBlueprintName(Conversable whom, GameModeAddon addon, Blueprint bp, BlueprintBundle bb) {
        new ConversationFactory((Plugin)BentoBox.getInstance()).withModality(true).withLocalEcho(false).withPrefix((ConversationPrefix)new NameConversationPrefix()).withTimeout(90).withFirstPrompt((Prompt)new NamePrompt(addon, bp, bb)).withEscapeSequence(this.t("name.quit")).buildConversation(whom).begin();
    }

    public void askForDescription(Conversable whom, GameModeAddon addon, BlueprintBundle bb) {
        new ConversationFactory((Plugin)BentoBox.getInstance()).withModality(true).withLocalEcho(false).withPrefix((ConversationPrefix)new NameConversationPrefix()).withTimeout(90).withFirstPrompt((Prompt)new DescriptionPrompt(addon, bb)).buildConversation(whom).begin();
    }

    public Map.Entry<Integer, Blueprint> getSelected() {
        return this.selected;
    }
}

