/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.panels.settings;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.World;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.flags.clicklisteners.WorldToggleClick;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.Tab;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.panels.settings.SettingsTab;

public class WorldDefaultSettingsTab
extends SettingsTab
implements Tab {
    public WorldDefaultSettingsTab(World world, User user) {
        super(world, user, Flag.Type.PROTECTION);
    }

    @Override
    public PanelItem getIcon() {
        PanelItemBuilder pib = new PanelItemBuilder();
        pib.icon(Material.STONE_BRICKS);
        pib.name(this.getName());
        pib.description(this.user.getTranslation("protection.panel.WORLD_DEFAULTS.description", new String[0]));
        return pib.build();
    }

    @Override
    public String getName() {
        return this.user.getTranslation("protection.panel.WORLD_DEFAULTS.title", "[world_name]", this.plugin.getIWM().getFriendlyName(this.world));
    }

    @Override
    public String getPermission() {
        return this.plugin.getIWM().getPermissionPrefix(this.world) + "admin.set-world-defaults";
    }

    @Override
    public @NonNull List<PanelItem> getPanelItems() {
        return this.getFlags().stream().map(f -> {
            PanelItem i = f.toPanelItem(this.plugin, this.user, this.world, this.island, false);
            i.setClickHandler(new WorldToggleClick(f.getID()));
            String worldSetting = f.isSetForWorld(this.world) ? this.user.getTranslation("protection.panel.flag-item.setting-active", new String[0]) : this.user.getTranslation("protection.panel.flag-item.setting-disabled", new String[0]);
            i.setDescription(Arrays.asList(this.user.getTranslation("protection.panel.flag-item.setting-layout", "[description]", this.user.getTranslation(f.getDescriptionReference(), new String[0]), "[setting]", worldSetting).split("\n")));
            return i;
        }).toList();
    }
}

