/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.addons;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.generator.ChunkGenerator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.multilib.MultiLib;
import world.bentobox.bentobox.util.Util;

public abstract class GameModeAddon
extends Addon {
    protected World islandWorld;
    protected @Nullable World netherWorld;
    protected @Nullable World endWorld;
    protected @Nullable CompositeCommand playerCommand;
    protected @Nullable CompositeCommand adminCommand;

    public abstract void createWorlds();

    public abstract WorldSettings getWorldSettings();

    public boolean inWorld(Location loc) {
        return Util.sameWorld(loc.getWorld(), this.islandWorld);
    }

    public boolean inWorld(World world) {
        if (world == null) {
            return false;
        }
        return Util.sameWorld(world, this.islandWorld);
    }

    public World getOverWorld() {
        return this.islandWorld;
    }

    public @Nullable World getNetherWorld() {
        return this.netherWorld;
    }

    public @Nullable World getEndWorld() {
        return this.endWorld;
    }

    public @NonNull Optional<CompositeCommand> getPlayerCommand() {
        return Optional.ofNullable(this.playerCommand);
    }

    public @NonNull Optional<CompositeCommand> getAdminCommand() {
        return Optional.ofNullable(this.adminCommand);
    }

    public abstract @Nullable ChunkGenerator getDefaultWorldGenerator(String var1, String var2);

    public void saveWorldSettings() {
        MultiLib.notify("bentobox-config-update", "");
    }

    public boolean isUsesNewChunkGeneration() {
        return false;
    }

    public boolean isFixIslandCenter() {
        return true;
    }

    public boolean isEnforceEqualRanges() {
        return true;
    }
}

