/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.blueprints;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintCommand;
import world.bentobox.bentobox.api.user.User;

public class AdminBlueprintListCommand
extends CompositeCommand {
    public AdminBlueprintListCommand(AdminBlueprintCommand parent) {
        super(parent, "list", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.blueprint.list");
        this.setDescription("commands.admin.blueprint.list.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (!args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        File blueprints = new File(((Addon)this.getAddon()).getDataFolder(), "blueprints");
        if (!blueprints.exists()) {
            user.sendMessage("commands.admin.blueprint.list.no-blueprints", new String[0]);
            return false;
        }
        FilenameFilter blueprintFilter = (dir, name) -> name.endsWith(".blu");
        List<String> blueprintList = Arrays.stream(Objects.requireNonNull(blueprints.list(blueprintFilter))).map(name -> name.substring(0, name.length() - ".blu".length())).toList();
        if (blueprintList.isEmpty()) {
            user.sendMessage("commands.admin.blueprint.list.no-blueprints", new String[0]);
            return false;
        }
        user.sendMessage("commands.admin.blueprint.list.available-blueprints", new String[0]);
        blueprintList.forEach(user::sendRawMessage);
        return true;
    }
}

