/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.range;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class AdminRangeDisplayCommand
extends CompositeCommand {
    private static final String DISPLAY = "display";
    private static final String SHOW = "show";
    private static final String HIDE = "hide";
    public static final Particle PARTICLE = Particle.DUST;
    private static final Particle PARTICLE2 = Particle.DUST;
    private final Map<User, Integer> displayRanges = new HashMap<User, Integer>();

    public AdminRangeDisplayCommand(CompositeCommand parent) {
        super(parent, DISPLAY, SHOW, HIDE);
    }

    @Override
    public void setup() {
        this.setPermission("admin.range.display");
        this.setDescription("commands.admin.range.display.description");
        this.setOnlyPlayer(true);
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (!this.displayRanges.containsKey(user)) {
            switch (label) {
                case "display": 
                case "show": {
                    this.showZones(user);
                    break;
                }
                case "hide": {
                    user.sendMessage("commands.admin.range.display.already-off", new String[0]);
                    break;
                }
                default: {
                    this.showHelp(this, user);
                    break;
                }
            }
        } else {
            switch (label) {
                case "display": 
                case "hide": {
                    this.hideZones(user);
                    break;
                }
                case "show": {
                    user.sendMessage("commands.admin.range.display.already-on", new String[0]);
                    break;
                }
                default: {
                    this.showHelp(this, user);
                }
            }
        }
        return true;
    }

    private void showZones(User user) {
        user.sendMessage("commands.admin.range.display.showing", new String[0]);
        user.sendMessage("commands.admin.range.display.hint", new String[0]);
        this.displayRanges.put(user, Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.getPlugin(), () -> {
            if (!user.getPlayer().isOnline()) {
                this.hideZones(user);
            }
            this.getIslands().getIslandAt(user.getLocation()).ifPresent(island -> {
                this.drawZone(user, Particle.BLOCK_MARKER, Material.BARRIER.createBlockData(), (Island)island, island.getProtectionRange());
                if (island.getProtectionRange() != this.getPlugin().getIWM().getIslandProtectionRange(this.getWorld())) {
                    this.drawZone(user, PARTICLE2, new Particle.DustOptions(Color.GREEN, 1.0f), (Island)island, this.getPlugin().getIWM().getIslandProtectionRange(this.getWorld()));
                }
                this.drawZone(user, PARTICLE, new Particle.DustOptions(Color.GRAY, 1.0f), (Island)island, island.getRange());
            });
        }, 20L, 30L));
    }

    private void hideZones(User user) {
        user.sendMessage("commands.admin.range.display.hiding", new String[0]);
        Bukkit.getScheduler().cancelTask(this.displayRanges.get(user).intValue());
        this.displayRanges.remove(user);
    }

    private void drawZone(User user, Particle particle, Object dustOptions, Island island, int range) {
        Location center = island.getProtectionCenter();
        int playerY = user.getPlayer().getLocation().getBlockY() + 1;
        for (int stage = -1; stage <= 1; ++stage) {
            for (int i = -range; i <= range; ++i) {
                user.spawnParticle(particle, dustOptions, (double)center.getBlockX() + (double)i, (double)playerY + (double)stage, (double)center.getBlockZ() + (double)range);
                user.spawnParticle(particle, dustOptions, (double)center.getBlockX() + (double)i, (double)playerY + (double)stage, (double)center.getBlockZ() - (double)range);
                user.spawnParticle(particle, dustOptions, (double)center.getBlockX() + (double)range, (double)playerY + (double)stage, (double)center.getBlockZ() + (double)i);
                user.spawnParticle(particle, dustOptions, (double)center.getBlockX() - (double)range, (double)playerY + (double)stage, (double)center.getBlockZ() + (double)i);
            }
        }
    }
}

