/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.World;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.DelayedTeleportCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.util.Util;

public class IslandGoCommand
extends DelayedTeleportCommand {
    public IslandGoCommand(CompositeCommand islandCommand) {
        super(islandCommand, "go", "home", "h");
    }

    @Override
    public void setup() {
        this.setPermission("island.home");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.go.parameters");
        this.setDescription("commands.island.go.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (this.getIslands().isGoingHome(user)) {
            user.sendMessage("commands.island.go.in-progress", new String[0]);
            return false;
        }
        List<Island> islands = this.getIslands().getIslands(this.getWorld(), user.getUniqueId());
        if (islands.isEmpty()) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        if (this.checkReserved(user, islands)) {
            return false;
        }
        if (this.getIWM().inWorld(user.getWorld()) && Flags.PREVENT_TELEPORT_WHEN_FALLING.isSetForWorld(user.getWorld()) && user.getPlayer().getFallDistance() > 0.0f) {
            user.sendMessage(Flags.PREVENT_TELEPORT_WHEN_FALLING.getHintReference(), new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        Map<String, IslandInfo> names = IslandGoCommand.getNameIslandMap(user, this.getWorld());
        if (!args.isEmpty()) {
            String name = String.join((CharSequence)" ", args);
            if (!names.containsKey(name)) {
                user.sendMessage("commands.island.go.unknown-home", new String[0]);
                user.sendMessage("commands.island.sethome.homes-are", new String[0]);
                names.keySet().forEach(n -> user.sendMessage("commands.island.sethome.home-list-syntax", "[name]", (String)n));
                return false;
            }
            IslandInfo info = names.get(name);
            this.getIslands().setPrimaryIsland(user.getUniqueId(), info.island);
            if (!info.islandName) {
                this.delayCommand(user, () -> this.getIslands().homeTeleportAsync(this.getWorld(), user.getPlayer(), name).thenAccept(r -> {
                    if (r.booleanValue()) {
                        this.getIslands().setPrimaryIsland(user.getUniqueId(), info.island);
                    } else {
                        user.sendMessage("commands.island.go.failure", new String[0]);
                        this.getPlugin().logError(user.getName() + " could not teleport to their island - async teleport issue");
                    }
                }));
                return true;
            }
        }
        this.delayCommand(user, () -> this.getIslands().homeTeleportAsync(this.getWorld(), user.getPlayer()));
        return true;
    }

    private boolean checkReserved(User user, List<Island> islands) {
        for (Island island : islands) {
            if (!island.isReserved()) continue;
            this.getParent().getSubCommand("create").ifPresent(createCmd -> createCmd.call(user, createCmd.getLabel(), Collections.emptyList()));
            return true;
        }
        return false;
    }

    public static Map<String, IslandInfo> getNameIslandMap(User user, World world) {
        HashMap<String, IslandInfo> islandMap = new HashMap<String, IslandInfo>();
        int index = 0;
        for (Island island : BentoBox.getInstance().getIslands().getIslands(world, user.getUniqueId())) {
            ++index;
            if (island.getName() != null && !island.getName().isBlank()) {
                islandMap.put(Util.stripColor(island.getName()), new IslandInfo(island, true));
            } else {
                String text = Util.stripColor(user.getTranslation("protection.flags.ENTER_EXIT_MESSAGES.island", "[name]", user.getName(), "[display_name]", user.getDisplayName()) + " " + index);
                islandMap.put(text, new IslandInfo(island, true));
            }
            island.getHomes().keySet().stream().filter(n -> !n.isBlank()).forEach(n -> islandMap.put((String)n, new IslandInfo(island, false)));
        }
        return islandMap;
    }

    public record IslandInfo(Island island, boolean islandName) {
    }
}

