/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.events.island;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.island.IslandBanEvent;
import world.bentobox.bentobox.api.events.island.IslandCreateEvent;
import world.bentobox.bentobox.api.events.island.IslandCreatedEvent;
import world.bentobox.bentobox.api.events.island.IslandDeleteChunksEvent;
import world.bentobox.bentobox.api.events.island.IslandDeleteEvent;
import world.bentobox.bentobox.api.events.island.IslandDeletedEvent;
import world.bentobox.bentobox.api.events.island.IslandEnterEvent;
import world.bentobox.bentobox.api.events.island.IslandExitEvent;
import world.bentobox.bentobox.api.events.island.IslandExpelEvent;
import world.bentobox.bentobox.api.events.island.IslandGeneralEvent;
import world.bentobox.bentobox.api.events.island.IslandInfoEvent;
import world.bentobox.bentobox.api.events.island.IslandLockEvent;
import world.bentobox.bentobox.api.events.island.IslandNameEvent;
import world.bentobox.bentobox.api.events.island.IslandNewIslandEvent;
import world.bentobox.bentobox.api.events.island.IslandPreCreateEvent;
import world.bentobox.bentobox.api.events.island.IslandPreclearEvent;
import world.bentobox.bentobox.api.events.island.IslandProtectionRangeChangeEvent;
import world.bentobox.bentobox.api.events.island.IslandRankChangeEvent;
import world.bentobox.bentobox.api.events.island.IslandRegisteredEvent;
import world.bentobox.bentobox.api.events.island.IslandReservedEvent;
import world.bentobox.bentobox.api.events.island.IslandResetEvent;
import world.bentobox.bentobox.api.events.island.IslandResettedEvent;
import world.bentobox.bentobox.api.events.island.IslandUnbanEvent;
import world.bentobox.bentobox.api.events.island.IslandUnlockEvent;
import world.bentobox.bentobox.api.events.island.IslandUnregisteredEvent;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBundle;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.database.objects.IslandDeletion;

public class IslandEvent
extends IslandBaseEvent {
    private final Reason reason;
    private static final HandlerList handlers = new HandlerList();

    @Override
    public @NonNull HandlerList getHandlers() {
        return IslandEvent.getHandlerList();
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public IslandEvent(Island island, UUID playerUUID, boolean admin, Location location, Reason reason) {
        super(island, playerUUID, admin, location);
        this.reason = reason;
    }

    public Reason getReason() {
        return this.reason;
    }

    public static IslandEventBuilder builder() {
        return new IslandEventBuilder();
    }

    public static enum Reason {
        BAN,
        PRECREATE,
        CREATE,
        CREATED,
        DELETE,
        DELETE_CHUNKS,
        DELETED,
        ENTER,
        EXIT,
        LOCK,
        NEW_ISLAND,
        PRECLEAR,
        RESET,
        RESETTED,
        UNBAN,
        UNLOCK,
        UNKNOWN,
        UNREGISTERED,
        REGISTERED,
        EXPEL,
        RESERVED,
        RANGE_CHANGE,
        RANK_CHANGE,
        NAME,
        INFO;

    }

    public static class IslandEventBuilder {
        private Island island;
        private UUID player;
        private Reason reason = Reason.UNKNOWN;
        private boolean admin;
        private Location location;
        private IslandDeletion deletedIslandInfo;
        private BlueprintBundle blueprintBundle;
        private Event rawEvent;
        private int newRange;
        private int oldRange;
        private Island oldIsland;
        private int oldRank;
        private int newRank;
        private String previousName;
        private Addon addon;

        public IslandEventBuilder island(Island island) {
            this.island = island;
            return this;
        }

        public IslandEventBuilder oldIsland(Island oldIsland) {
            this.oldIsland = oldIsland;
            return this;
        }

        public IslandEventBuilder admin(boolean admin) {
            this.admin = admin;
            return this;
        }

        public IslandEventBuilder reason(Reason reason) {
            this.reason = reason;
            return this;
        }

        public IslandEventBuilder involvedPlayer(UUID player) {
            this.player = player;
            return this;
        }

        public IslandEventBuilder location(Location center) {
            this.location = center;
            return this;
        }

        public IslandEventBuilder rawEvent(Event event) {
            this.rawEvent = event;
            return this;
        }

        public IslandEventBuilder deletedIslandInfo(IslandDeletion deletedIslandInfo) {
            this.deletedIslandInfo = deletedIslandInfo;
            return this;
        }

        public @NonNull IslandEventBuilder blueprintBundle(@NonNull BlueprintBundle blueprintBundle) {
            this.blueprintBundle = blueprintBundle;
            return this;
        }

        public @NonNull IslandEventBuilder protectionRange(int newRange, int oldRange) {
            this.newRange = newRange;
            this.oldRange = oldRange;
            return this;
        }

        public @NonNull IslandEventBuilder rankChange(int oldRank, int newRank) {
            this.oldRank = oldRank;
            this.newRank = newRank;
            return this;
        }

        public IslandEventBuilder previousName(@Nullable String previousName) {
            this.previousName = previousName;
            return this;
        }

        public IslandEventBuilder addon(Addon addon) {
            this.addon = addon;
            return this;
        }

        private IslandBaseEvent getEvent() {
            return switch (this.reason.ordinal()) {
                case 19 -> new IslandExpelEvent(this.island, this.player, this.admin, this.location);
                case 0 -> new IslandBanEvent(this.island, this.player, this.admin, this.location);
                case 1 -> new IslandPreCreateEvent(this.player);
                case 2 -> new IslandCreateEvent(this.island, this.player, this.admin, this.location, this.blueprintBundle);
                case 3 -> new IslandCreatedEvent(this.island, this.player, this.admin, this.location);
                case 4 -> new IslandDeleteEvent(this.island, this.player, this.admin, this.location);
                case 5 -> new IslandDeleteChunksEvent(this.island, this.player, this.admin, this.location, this.deletedIslandInfo);
                case 6 -> new IslandDeletedEvent(this.island, this.player, this.admin, this.location, this.deletedIslandInfo);
                case 7 -> new IslandEnterEvent(this.island, this.player, this.admin, this.location, this.oldIsland, this.rawEvent);
                case 8 -> new IslandExitEvent(this.island, this.player, this.admin, this.location, this.oldIsland, this.rawEvent);
                case 9 -> new IslandLockEvent(this.island, this.player, this.admin, this.location);
                case 12 -> new IslandResetEvent(this.island, this.player, this.admin, this.location, this.blueprintBundle, this.oldIsland);
                case 13 -> new IslandResettedEvent(this.island, this.player, this.admin, this.location, this.oldIsland);
                case 14 -> new IslandUnbanEvent(this.island, this.player, this.admin, this.location);
                case 15 -> new IslandUnlockEvent(this.island, this.player, this.admin, this.location);
                case 18 -> new IslandRegisteredEvent(this.island, this.player, this.admin, this.location);
                case 17 -> new IslandUnregisteredEvent(this.island, this.player, this.admin, this.location);
                case 21 -> new IslandProtectionRangeChangeEvent(this.island, this.player, this.admin, this.location, this.newRange, this.oldRange);
                case 11 -> new IslandPreclearEvent(this.island, this.player, this.admin, this.location, this.oldIsland);
                case 20 -> new IslandReservedEvent(this.island, this.player, this.admin, this.location);
                case 22 -> new IslandRankChangeEvent(this.island, this.player, this.admin, this.location, this.oldRank, this.newRank);
                case 10 -> new IslandNewIslandEvent(this.island, this.player, this.admin, this.location);
                case 23 -> new IslandNameEvent(this.island, this.player, this.admin, this.location, this.previousName);
                case 24 -> new IslandInfoEvent(this.island, this.player, this.admin, this.location, this.addon);
                default -> new IslandGeneralEvent(this.island, this.player, this.admin, this.location);
            };
        }

        public IslandBaseEvent build() {
            Bukkit.getPluginManager().callEvent((Event)new IslandEvent(this.island, this.player, this.admin, this.location, this.reason));
            IslandBaseEvent newEvent = this.getEvent();
            Bukkit.getPluginManager().callEvent((Event)newEvent);
            return newEvent;
        }
    }
}

