/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.events.team;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.team.TeamDeleteEvent;
import world.bentobox.bentobox.api.events.team.TeamGeneralEvent;
import world.bentobox.bentobox.api.events.team.TeamInfoEvent;
import world.bentobox.bentobox.api.events.team.TeamInviteEvent;
import world.bentobox.bentobox.api.events.team.TeamJoinEvent;
import world.bentobox.bentobox.api.events.team.TeamJoinedEvent;
import world.bentobox.bentobox.api.events.team.TeamKickEvent;
import world.bentobox.bentobox.api.events.team.TeamLeaveEvent;
import world.bentobox.bentobox.api.events.team.TeamRejectEvent;
import world.bentobox.bentobox.api.events.team.TeamSetownerEvent;
import world.bentobox.bentobox.api.events.team.TeamUninviteEvent;
import world.bentobox.bentobox.database.objects.Island;

public class TeamEvent {
    public static TeamEventBuilder builder() {
        return new TeamEventBuilder();
    }

    public static class TeamEventBuilder {
        private Island island;
        private UUID player;
        private Reason reason = Reason.UNKNOWN;
        private boolean admin;
        private Location location;

        public TeamEventBuilder island(Island island) {
            this.island = island;
            return this;
        }

        public TeamEventBuilder admin(boolean admin) {
            this.admin = admin;
            return this;
        }

        public TeamEventBuilder reason(Reason reason) {
            this.reason = reason;
            return this;
        }

        public TeamEventBuilder involvedPlayer(UUID player) {
            this.player = player;
            return this;
        }

        public TeamEventBuilder location(Location center) {
            this.location = center;
            return this;
        }

        private IslandBaseEvent getEvent() {
            return switch (this.reason.ordinal()) {
                case 1 -> new TeamJoinEvent(this.island, this.player, this.admin, this.location);
                case 10 -> new TeamJoinedEvent(this.island, this.player, this.admin, this.location);
                case 0 -> new TeamInviteEvent(this.island, this.player, this.admin, this.location);
                case 3 -> new TeamLeaveEvent(this.island, this.player, this.admin, this.location);
                case 2 -> new TeamRejectEvent(this.island, this.player, this.admin, this.location);
                case 4 -> new TeamKickEvent(this.island, this.player, this.admin, this.location);
                case 5 -> new TeamSetownerEvent(this.island, this.player, this.admin, this.location);
                case 6 -> new TeamInfoEvent(this.island, this.player, this.admin, this.location);
                case 7 -> new TeamDeleteEvent(this.island, this.player, this.admin, this.location);
                case 9 -> new TeamUninviteEvent(this.island, this.player, this.admin, this.location);
                default -> new TeamGeneralEvent(this.island, this.player, this.admin, this.location);
            };
        }

        public IslandBaseEvent build() {
            IslandBaseEvent newEvent = this.getEvent();
            Bukkit.getPluginManager().callEvent((Event)newEvent);
            return newEvent;
        }
    }

    public static enum Reason {
        INVITE,
        JOIN,
        REJECT,
        LEAVE,
        KICK,
        SETOWNER,
        INFO,
        DELETE,
        UNKNOWN,
        UNINVITE,
        JOINED;

    }
}

