/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.panels.reader;

import com.google.common.base.Enums;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.inventory.ClickType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.reader.ItemTemplateRecord;
import world.bentobox.bentobox.api.panels.reader.PanelTemplateRecord;
import world.bentobox.bentobox.util.ItemParser;

public class TemplateReader {
    private static final String TITLE = "title";
    private static final String ICON = "icon";
    private static final String DESCRIPTION = "description";
    private static final String BACKGROUND = "background";
    private static final String BORDER = "border";
    private static final String FORCE_SHOWN = "force-shown";
    private static final String FALLBACK = "fallback";
    private static final String YML = ".yml";
    private static final String ACTIONS = "actions";
    private static final String TOOLTIP = "tooltip";
    private static final String CLICK_TYPE = "click-type";
    private static final String CONTENT = "content";
    private static final String TYPE = "type";
    private static final Map<String, PanelTemplateRecord> loadedPanels = new HashMap<String, PanelTemplateRecord>();

    private TemplateReader() {
    }

    public static PanelTemplateRecord readTemplatePanel(@NonNull String panelName, @NonNull File panelLocation) {
        return TemplateReader.readTemplatePanel(panelName, panelName, panelLocation);
    }

    public static PanelTemplateRecord readTemplatePanel(@NonNull String panelName, @NonNull String templateName, @NonNull File panelLocation) {
        PanelTemplateRecord rec;
        String panelKey;
        if (!panelLocation.exists()) {
            BentoBox.getInstance().logError("Panel Template reader: Folder does not exist");
            return null;
        }
        File file = new File(panelLocation, (String)(templateName.endsWith(YML) ? templateName : templateName + YML));
        String absolutePath = file.getAbsolutePath();
        if (!file.exists()) {
            String keyword = "panels/";
            int index = absolutePath.indexOf(keyword);
            if (index != -1) {
                BentoBox.getInstance().saveResource(absolutePath.substring(index), false);
            } else {
                BentoBox.getInstance().logError(file.getAbsolutePath() + " does not exist for panel template");
                return null;
            }
        }
        if (loadedPanels.containsKey(panelKey = absolutePath + ":" + panelName)) {
            return loadedPanels.get(panelKey);
        }
        try {
            YamlConfiguration config = new YamlConfiguration();
            config.load(file);
            rec = TemplateReader.readPanelTemplate(config.getConfigurationSection(panelName));
            loadedPanels.put(panelKey, rec);
        }
        catch (IOException | InvalidConfigurationException e) {
            BentoBox.getInstance().logError("Error loading template");
            BentoBox.getInstance().logStacktrace(e);
            rec = null;
        }
        return rec;
    }

    private static PanelTemplateRecord readPanelTemplate(@Nullable ConfigurationSection configurationSection) {
        if (configurationSection == null) {
            BentoBox.getInstance().logError("No configuration section!");
            return null;
        }
        String title = configurationSection.getString(TITLE);
        Panel.Type type = (Panel.Type)((Object)Enums.getIfPresent(Panel.Type.class, (String)configurationSection.getString(TYPE, "INVENTORY")).or((Object)Panel.Type.INVENTORY));
        PanelTemplateRecord.TemplateItem borderItem = null;
        if (configurationSection.isConfigurationSection(BORDER)) {
            ConfigurationSection borderSection = configurationSection.getConfigurationSection(BORDER);
            if (borderSection != null) {
                borderItem = new PanelTemplateRecord.TemplateItem(ItemParser.parse(borderSection.getString(ICON, Material.AIR.name())), borderSection.getString(TITLE, null), borderSection.getString(DESCRIPTION, null));
            }
        } else if (configurationSection.isString(BORDER)) {
            borderItem = new PanelTemplateRecord.TemplateItem(ItemParser.parse(configurationSection.getString(BORDER, Material.AIR.name())));
        }
        PanelTemplateRecord.TemplateItem backgroundItem = null;
        if (configurationSection.isConfigurationSection(BACKGROUND)) {
            ConfigurationSection backgroundSection = configurationSection.getConfigurationSection(BACKGROUND);
            if (backgroundSection != null) {
                backgroundItem = new PanelTemplateRecord.TemplateItem(ItemParser.parse(backgroundSection.getString(ICON, Material.AIR.name())), backgroundSection.getString(TITLE, null), backgroundSection.getString(DESCRIPTION, null));
            }
        } else if (configurationSection.isString(BACKGROUND)) {
            backgroundItem = new PanelTemplateRecord.TemplateItem(ItemParser.parse(configurationSection.getString(BACKGROUND, Material.AIR.name())));
        }
        HashMap<String, ItemTemplateRecord> panelItemDataMap = new HashMap<String, ItemTemplateRecord>();
        ConfigurationSection reusable = configurationSection.getConfigurationSection("reusable");
        if (reusable != null) {
            reusable.getKeys(false).forEach(key -> TemplateReader.readPanelItemTemplate(reusable.getConfigurationSection(key), key, panelItemDataMap));
        }
        boolean[] forcedRows = TemplateReader.readForcedRows(configurationSection);
        PanelTemplateRecord template = new PanelTemplateRecord(type, title, borderItem, backgroundItem, forcedRows);
        ConfigurationSection content = configurationSection.getConfigurationSection(CONTENT);
        if (content == null) {
            return template;
        }
        for (int rowIndex = 0; rowIndex < 6; ++rowIndex) {
            ConfigurationSection line;
            if (!content.isConfigurationSection(String.valueOf(rowIndex + 1)) || (line = content.getConfigurationSection(String.valueOf(rowIndex + 1))) == null) continue;
            for (int columnIndex = 0; columnIndex < 9; ++columnIndex) {
                if (line.isConfigurationSection(String.valueOf(columnIndex + 1))) {
                    template.addButtonTemplate(rowIndex, columnIndex, TemplateReader.readPanelItemTemplate(line.getConfigurationSection(String.valueOf(columnIndex + 1)), null, panelItemDataMap));
                    continue;
                }
                if (!line.isString(String.valueOf(columnIndex + 1))) continue;
                template.addButtonTemplate(rowIndex, columnIndex, (ItemTemplateRecord)panelItemDataMap.get(line.getString(String.valueOf(columnIndex + 1))));
            }
        }
        panelItemDataMap.clear();
        return template;
    }

    private static boolean[] readForcedRows(@Nullable ConfigurationSection section) {
        boolean[] forceShow = new boolean[6];
        if (section != null && section.contains(FORCE_SHOWN)) {
            if (section.isInt(FORCE_SHOWN)) {
                int value = section.getInt(FORCE_SHOWN);
                if (value > 0 && value < 7) {
                    forceShow[value - 1] = true;
                }
            } else if (section.isList(FORCE_SHOWN)) {
                section.getIntegerList(FORCE_SHOWN).forEach(number -> {
                    if (number > 0 && number < 7) {
                        forceShow[number.intValue() - 1] = true;
                    }
                });
            }
        }
        return forceShow;
    }

    private static @Nullable ItemTemplateRecord readPanelItemTemplate(@Nullable ConfigurationSection section) {
        return TemplateReader.readPanelItemTemplate(section, null, null);
    }

    private static @Nullable ItemTemplateRecord readPanelItemTemplate(@Nullable ConfigurationSection section, String itemKey, Map<String, ItemTemplateRecord> reusableItemMap) {
        List actionList;
        ConfigurationSection dataSection;
        if (section == null) {
            return null;
        }
        ItemTemplateRecord fallback = section.isConfigurationSection(FALLBACK) ? TemplateReader.readPanelItemTemplate(section.getConfigurationSection(FALLBACK)) : (section.isString(FALLBACK) && reusableItemMap != null ? reusableItemMap.get(section.getString(FALLBACK)) : null);
        ItemTemplateRecord itemRecord = new ItemTemplateRecord(ItemParser.parse(section.getString(ICON)), section.getString(TITLE, null), section.getString(DESCRIPTION, null), fallback);
        if (section.isConfigurationSection("data") && (dataSection = section.getConfigurationSection("data")) != null) {
            dataSection.getKeys(false).forEach(key -> itemRecord.addData((String)key, dataSection.get(key)));
        }
        if (section.isConfigurationSection(ACTIONS)) {
            ConfigurationSection actionSection = section.getConfigurationSection(ACTIONS);
            if (actionSection != null) {
                actionSection.getKeys(false).forEach(actionKey -> {
                    ClickType clickType = (ClickType)Enums.getIfPresent(ClickType.class, (String)actionKey.toUpperCase()).orNull();
                    ConfigurationSection actionDataSection = actionSection.getConfigurationSection(actionKey);
                    if (clickType != null) {
                        if (actionDataSection != null) {
                            ItemTemplateRecord.ActionRecords actionData = new ItemTemplateRecord.ActionRecords(clickType, actionDataSection.getString(TYPE), actionDataSection.getString(CONTENT), actionDataSection.getString(TOOLTIP));
                            itemRecord.addAction(actionData);
                        }
                    } else if (actionDataSection != null && actionDataSection.contains(CLICK_TYPE)) {
                        clickType = (ClickType)Enums.getIfPresent(ClickType.class, (String)actionDataSection.getString(CLICK_TYPE, "UNKNOWN").toUpperCase()).or((Object)ClickType.UNKNOWN);
                        ItemTemplateRecord.ActionRecords actionData = new ItemTemplateRecord.ActionRecords(clickType, (String)actionKey, actionDataSection.getString(CONTENT), actionDataSection.getString(TOOLTIP));
                        itemRecord.addAction(actionData);
                    }
                });
            }
        } else if (section.isList(ACTIONS) && !(actionList = section.getMapList(ACTIONS)).isEmpty()) {
            actionList.forEach(valueMap -> {
                ClickType clickType = (ClickType)Enums.getIfPresent(ClickType.class, (String)String.valueOf(valueMap.get(CLICK_TYPE)).toUpperCase()).orNull();
                if (clickType != null) {
                    ItemTemplateRecord.ActionRecords actionData = new ItemTemplateRecord.ActionRecords(clickType, valueMap.containsKey(TYPE) ? String.valueOf(valueMap.get(TYPE)) : null, valueMap.containsKey(CONTENT) ? String.valueOf(valueMap.get(CONTENT)) : null, valueMap.containsKey(TOOLTIP) ? String.valueOf(valueMap.get(TOOLTIP)) : null);
                    itemRecord.addAction(actionData);
                }
            });
        }
        if (reusableItemMap != null && itemKey != null) {
            reusableItemMap.put(itemKey, itemRecord);
        }
        return itemRecord;
    }

    public static void clearPanels() {
        loadedPanels.clear();
    }
}

