/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.clicklisteners;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.event.inventory.ClickType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.Tab;
import world.bentobox.bentobox.api.panels.TabbedPanel;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.hooks.LangUtilsHook;
import world.bentobox.bentobox.util.Util;

public class GeoMobLimitTab
implements Tab,
PanelItem.ClickHandler {
    private static final List<EntityType> LIVING_ENTITY_TYPES = Arrays.stream(EntityType.values()).filter(EntityType::isAlive).filter(t -> !t.equals((Object)EntityType.PLAYER) && !t.equals((Object)EntityType.GIANT) && !t.equals((Object)EntityType.ARMOR_STAND)).sorted(Comparator.comparing(Enum::name)).toList();
    private final BentoBox plugin = BentoBox.getInstance();
    private final User user;
    private final EntityLimitTabType type;
    private final World world;
    private TabbedPanel parent;

    public GeoMobLimitTab(@NonNull User user, @NonNull EntityLimitTabType type, World world) {
        this.user = user;
        this.type = type;
        this.world = world;
    }

    @Override
    public boolean onClick(Panel panel, User user, ClickType clickType, int slot) {
        TabbedPanel tp = (TabbedPanel)panel;
        int index = tp.getActivePage() * 36 + slot - 9;
        EntityType c = LIVING_ENTITY_TYPES.get(index);
        if (this.type == EntityLimitTabType.MOB_LIMIT) {
            if (this.plugin.getIWM().getMobLimitSettings(this.world).contains(c.name())) {
                this.plugin.getIWM().getMobLimitSettings(this.world).remove(c.name());
            } else {
                this.plugin.getIWM().getMobLimitSettings(this.world).add(c.name());
            }
        } else if (this.plugin.getIWM().getGeoLimitSettings(this.world).contains(c.name())) {
            this.plugin.getIWM().getGeoLimitSettings(this.world).remove(c.name());
        } else {
            this.plugin.getIWM().getGeoLimitSettings(this.world).add(c.name());
        }
        panel.getInventory().setItem(slot, this.getPanelItem(c, user).getItem());
        this.plugin.getIWM().getAddon(Util.getWorld(this.world)).ifPresent(GameModeAddon::saveWorldSettings);
        return true;
    }

    @Override
    public PanelItem getIcon() {
        if (this.type == EntityLimitTabType.MOB_LIMIT) {
            return new PanelItemBuilder().icon(Material.IRON_BOOTS).name(this.getName()).build();
        }
        return new PanelItemBuilder().icon(Material.CHAINMAIL_CHESTPLATE).name(this.getName()).build();
    }

    @Override
    public String getName() {
        return this.type == EntityLimitTabType.MOB_LIMIT ? this.user.getTranslation("protection.flags.LIMIT_MOBS.name", new String[0]) : this.user.getTranslation("protection.flags.GEO_LIMIT_MOBS.name", new String[0]);
    }

    @Override
    public List<@Nullable PanelItem> getPanelItems() {
        return LIVING_ENTITY_TYPES.stream().map(c -> this.getPanelItem((EntityType)c, this.user)).toList();
    }

    @Override
    public String getPermission() {
        return "";
    }

    private PanelItem getPanelItem(EntityType c, User user) {
        PanelItemBuilder pib = new PanelItemBuilder();
        pib.name(LangUtilsHook.getEntityName(c, user));
        pib.clickHandler(this);
        if (this.type == EntityLimitTabType.MOB_LIMIT) {
            if (!BentoBox.getInstance().getIWM().getMobLimitSettings(this.world).contains(c.name())) {
                pib.icon(Material.GREEN_SHULKER_BOX);
                pib.description(user.getTranslation("protection.flags.LIMIT_MOBS.can", new String[0]));
            } else {
                pib.icon(Material.RED_SHULKER_BOX);
                pib.description(user.getTranslation("protection.flags.LIMIT_MOBS.cannot", new String[0]));
            }
        } else if (BentoBox.getInstance().getIWM().getGeoLimitSettings(this.world).contains(c.name())) {
            pib.icon(Material.GREEN_SHULKER_BOX);
            pib.description(user.getTranslation("protection.panel.flag-item.setting-active", new String[0]));
        } else {
            pib.icon(Material.RED_SHULKER_BOX);
            pib.description(user.getTranslation("protection.panel.flag-item.setting-disabled", new String[0]));
        }
        return pib.build();
    }

    @Override
    public TabbedPanel getParentPanel() {
        return this.parent;
    }

    @Override
    public void setParentPanel(TabbedPanel parent) {
        this.parent = parent;
    }

    public static enum EntityLimitTabType {
        GEO_LIMIT,
        MOB_LIMIT;

    }
}

