/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.protection;

import java.util.Optional;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrushableBlock;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.util.Util;

public class BlockInteractionListener
extends FlagListener {
    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (!e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || e.getClickedBlock() == null) {
            return;
        }
        this.checkClickedBlock((Event)e, e.getPlayer(), e.getClickedBlock());
        if (e.getItem() != null && !e.getItem().getType().equals((Object)Material.AIR)) {
            Block targetedBlock;
            if (Tag.ITEMS_BOATS.isTagged((Keyed)e.getItem().getType())) {
                this.checkIsland((Event)e, e.getPlayer(), e.getClickedBlock().getLocation(), Flags.BOAT);
            } else if (e.getItem().getType().name().endsWith("_SPAWN_EGG")) {
                this.checkIsland((Event)e, e.getPlayer(), e.getClickedBlock().getLocation(), Flags.SPAWN_EGGS);
            } else if (e.getItem().getType() == Material.ENDER_PEARL) {
                this.checkIsland((Event)e, e.getPlayer(), e.getClickedBlock().getLocation(), Flags.ENDER_PEARL);
            } else if (e.getItem().getType() == Material.BONE_MEAL) {
                this.checkIsland((Event)e, e.getPlayer(), e.getClickedBlock().getLocation(), Flags.PLACE_BLOCKS);
            } else if (e.getItem().getType() == Material.GLASS_BOTTLE && (targetedBlock = e.getPlayer().getTargetBlockExact(5, FluidCollisionMode.ALWAYS)) != null && (Material.WATER.equals((Object)targetedBlock.getType()) || targetedBlock.getBlockData() instanceof Waterlogged)) {
                this.checkIsland((Event)e, e.getPlayer(), e.getClickedBlock().getLocation(), Flags.BREWING);
            }
        }
    }

    private void checkClickedBlock(Event e, Player player, Block block) {
        if (this.checkSpecialCases(e, player, block) || this.checkTags(e, player, block)) {
            return;
        }
        Material type = block.getType();
        Location loc = block.getLocation();
        switch (type) {
            case BEACON: {
                this.checkIsland(e, player, loc, Flags.BEACON);
                break;
            }
            case BELL: {
                this.checkIsland(e, player, loc, Flags.BELL_RINGING);
                break;
            }
            case BREWING_STAND: {
                this.checkIsland(e, player, loc, Flags.BREWING);
                break;
            }
            case BEEHIVE: 
            case BEE_NEST: {
                this.checkIsland(e, player, loc, Flags.HIVE);
                break;
            }
            case BARREL: {
                this.checkIsland(e, player, loc, Flags.BARREL);
                break;
            }
            case CANDLE: {
                this.checkIsland(e, player, loc, Flags.CANDLES);
                break;
            }
            case CRAFTER: {
                this.checkIsland(e, player, loc, Flags.CRAFTER);
                break;
            }
            case CHEST: 
            case CHEST_MINECART: {
                this.checkIsland(e, player, loc, Flags.CHEST);
                break;
            }
            case TRAPPED_CHEST: {
                this.checkIsland(e, player, loc, Flags.TRAPPED_CHEST);
                break;
            }
            case FLOWER_POT: {
                this.checkIsland(e, player, loc, Flags.FLOWER_POT);
                break;
            }
            case COMPOSTER: {
                this.checkIsland(e, player, loc, Flags.COMPOSTER);
                break;
            }
            case DISPENSER: {
                this.checkIsland(e, player, loc, Flags.DISPENSER);
                break;
            }
            case DROPPER: {
                this.checkIsland(e, player, loc, Flags.DROPPER);
                break;
            }
            case HOPPER: 
            case HOPPER_MINECART: {
                this.checkIsland(e, player, loc, Flags.HOPPER);
                break;
            }
            case BLAST_FURNACE: 
            case CAMPFIRE: 
            case FURNACE_MINECART: 
            case FURNACE: 
            case SMOKER: {
                this.checkIsland(e, player, loc, Flags.FURNACE);
                break;
            }
            case ENCHANTING_TABLE: {
                this.checkIsland(e, player, loc, Flags.ENCHANTING);
                break;
            }
            case ENDER_CHEST: {
                this.checkIsland(e, player, loc, Flags.ENDER_CHEST);
                break;
            }
            case JUKEBOX: {
                this.checkIsland(e, player, loc, Flags.JUKEBOX);
                break;
            }
            case NOTE_BLOCK: {
                this.checkIsland(e, player, loc, Flags.NOTE_BLOCK);
                break;
            }
            case CRAFTING_TABLE: 
            case CARTOGRAPHY_TABLE: 
            case GRINDSTONE: 
            case STONECUTTER: 
            case LOOM: {
                this.checkIsland(e, player, loc, Flags.CRAFTING);
                break;
            }
            case LEVER: {
                this.checkIsland(e, player, loc, Flags.LEVER);
                break;
            }
            case REDSTONE_WIRE: 
            case REPEATER: 
            case COMPARATOR: 
            case DAYLIGHT_DETECTOR: {
                this.checkIsland(e, player, loc, Flags.REDSTONE);
                break;
            }
            case DRAGON_EGG: {
                this.checkIsland(e, player, loc, Flags.DRAGON_EGG);
                break;
            }
            case END_PORTAL_FRAME: 
            case RESPAWN_ANCHOR: {
                this.checkIsland(e, player, loc, Flags.PLACE_BLOCKS);
                break;
            }
            case GLOW_ITEM_FRAME: 
            case ITEM_FRAME: {
                this.checkIsland(e, player, loc, Flags.ITEM_FRAME);
                break;
            }
            case SWEET_BERRY_BUSH: {
                this.checkIsland(e, player, loc, Flags.HARVEST);
                break;
            }
            case CAVE_VINES: {
                this.checkIsland(e, player, loc, Flags.BREAK_BLOCKS);
                break;
            }
            case CAKE: {
                this.checkIsland(e, player, loc, Flags.CAKE);
                break;
            }
            case CHISELED_BOOKSHELF: {
                this.checkIsland(e, player, loc, Flags.BOOKSHELF);
                break;
            }
            case LAVA_CAULDRON: {
                if (!BlockInteractionListener.holds(player, Material.BUCKET)) break;
                this.checkIsland(e, player, loc, Flags.COLLECT_LAVA);
                break;
            }
            case WATER_CAULDRON: {
                if (BlockInteractionListener.holds(player, Material.BUCKET)) {
                    this.checkIsland(e, player, loc, Flags.COLLECT_WATER);
                    break;
                }
                if (!BlockInteractionListener.holds(player, Material.GLASS_BOTTLE) && !BlockInteractionListener.holds(player, Material.POTION)) break;
                this.checkIsland(e, player, loc, Flags.BREWING);
                break;
            }
            case POWDER_SNOW_CAULDRON: {
                if (!BlockInteractionListener.holds(player, Material.BUCKET)) break;
                this.checkIsland(e, player, loc, Flags.COLLECT_POWDERED_SNOW);
                break;
            }
            case CAULDRON: {
                if (BlockInteractionListener.holds(player, Material.WATER_BUCKET) || BlockInteractionListener.holds(player, Material.LAVA_BUCKET) || BlockInteractionListener.holds(player, Material.POWDER_SNOW_BUCKET)) {
                    this.checkIsland(e, player, loc, Flags.BUCKET);
                    break;
                }
                if (!BlockInteractionListener.holds(player, Material.POTION)) break;
                this.checkIsland(e, player, loc, Flags.BREWING);
                break;
            }
        }
    }

    private boolean checkTags(Event e, Player player, Block block) {
        Sign sign;
        BlockState blockState;
        Material type = block.getType();
        Location loc = block.getLocation();
        if (Tag.ANVIL.isTagged((Keyed)type)) {
            this.checkIsland(e, player, loc, Flags.ANVIL);
            return true;
        }
        if (Tag.BUTTONS.isTagged((Keyed)type)) {
            this.checkIsland(e, player, loc, Flags.BUTTON);
            return true;
        }
        if (Tag.BEDS.isTagged((Keyed)type)) {
            this.checkIsland(e, player, loc, Flags.BED);
            return true;
        }
        if (Tag.DOORS.isTagged((Keyed)type)) {
            this.checkIsland(e, player, loc, Flags.DOOR);
            return true;
        }
        if (Tag.SHULKER_BOXES.isTagged((Keyed)type)) {
            this.checkIsland(e, player, loc, Flags.SHULKER_BOX);
            return true;
        }
        if (Tag.TRAPDOORS.isTagged((Keyed)type)) {
            this.checkIsland(e, player, loc, Flags.TRAPDOOR);
            return true;
        }
        if ((Tag.ALL_HANGING_SIGNS.isTagged((Keyed)type) || Tag.SIGNS.isTagged((Keyed)type)) && (blockState = block.getState()) instanceof Sign && !(sign = (Sign)blockState).isWaxed()) {
            this.checkIsland(e, player, loc, Flags.SIGN_EDITING);
            return true;
        }
        if (Tag.FENCE_GATES.isTagged((Keyed)type)) {
            this.checkIsland(e, player, loc, Flags.GATE);
            return true;
        }
        if (Tag.ITEMS_CHEST_BOATS.isTagged((Keyed)type)) {
            this.checkIsland(e, player, loc, Flags.CHEST);
            return true;
        }
        return false;
    }

    private boolean checkSpecialCases(Event e, Player player, Block block) {
        Material type = block.getType();
        Location loc = block.getLocation();
        if (Tag.FLOWER_POTS.isTagged((Keyed)type)) {
            this.checkIsland(e, player, loc, Flags.FLOWER_POT);
            return true;
        }
        if (Util.isVersionAtLeast("1.21.10")) {
            if (Tag.COPPER_GOLEM_STATUES.isTagged((Keyed)type)) {
                this.checkIsland(e, player, loc, Flags.BREAK_BLOCKS);
                return true;
            }
            if (Tag.COPPER_CHESTS.isTagged((Keyed)type)) {
                this.checkIsland(e, player, loc, Flags.CHEST);
                return true;
            }
        }
        if (block.getState() instanceof BrushableBlock && BlockInteractionListener.holds(player, Material.BRUSH)) {
            this.checkIsland(e, player, loc, Flags.BREAK_BLOCKS);
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        this.checkClickedBlock((Event)e, e.getPlayer(), e.getBlock());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDragonEggTeleport(BlockFromToEvent e) {
        Block block = e.getBlock();
        if (!block.getType().equals((Object)Material.DRAGON_EGG) || !this.getIWM().inWorld(block.getLocation())) {
            return;
        }
        Optional<Island> fromIsland = this.getIslands().getProtectedIslandAt(block.getLocation());
        Optional<Island> toIsland = this.getIslands().getProtectedIslandAt(e.getToBlock().getLocation());
        fromIsland.ifPresent(from -> e.setCancelled(toIsland.map(to -> to != from).orElse(true).booleanValue()));
    }

    private static boolean holds(Player player, Material material) {
        return player.getInventory().getItemInMainHand().getType().equals((Object)material) || player.getInventory().getItemInOffHand().getType().equals((Object)material);
    }
}

