/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.worldsettings;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.inventory.ClickType;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.events.flags.InvincibleVistorFlagDamageRemovalEvent;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.builders.PanelBuilder;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;
import world.bentobox.bentobox.util.teleport.SafeSpotTeleport;

public class InvincibleVisitorsListener
extends FlagListener
implements PanelItem.ClickHandler {
    @Override
    public boolean onClick(Panel panel, User user, ClickType clickType, int slot) {
        if (!user.inWorld()) {
            user.sendMessage("general.errors.wrong-world", new String[0]);
            return true;
        }
        World w = Objects.requireNonNull(Util.getWorld(user.getWorld()));
        String reqPerm = this.getIWM().getPermissionPrefix(w) + "admin.settings.INVINCIBLE_VISITORS";
        if (!user.hasPermission(reqPerm)) {
            user.sendMessage("general.errors.no-permission", "[permission]", reqPerm);
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
            return true;
        }
        String ivPanelName = user.getTranslation("protection.flags.INVINCIBLE_VISITORS.name", new String[0]);
        if (panel.getName().equals(ivPanelName)) {
            if (BentoBox.getInstance().onTimeout(user, panel)) {
                return true;
            }
            String itemName = panel.getItems().get(slot).getName();
            EntityDamageEvent.DamageCause c = this.getEnum(user, itemName);
            if (c == null) {
                user.sendMessage("general.errors.general", new String[0]);
                user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
                BentoBox.getInstance().logError("Inv Visitor click did not match translated name: " + itemName);
                return true;
            }
            if (this.getIWM().getIvSettings(user.getWorld()).contains(c.name())) {
                this.getIWM().getIvSettings(user.getWorld()).remove(c.name());
            } else {
                this.getIWM().getIvSettings(user.getWorld()).add(c.name());
            }
            panel.getInventory().setItem(slot, this.getPanelItem(c, user).getItem());
            BentoBox.getInstance().getIWM().getAddon(Util.getWorld(user.getWorld())).ifPresent(GameModeAddon::saveWorldSettings);
        } else {
            this.openPanel(user, ivPanelName);
        }
        return true;
    }

    private EntityDamageEvent.DamageCause getEnum(User user, String itemName) {
        return Arrays.stream(EntityDamageEvent.DamageCause.values()).filter(dc -> this.getTranslation(user, dc.name()).equals(itemName)).findFirst().orElse(null);
    }

    private void openPanel(User user, String ivPanelName) {
        user.closeInventory();
        PanelBuilder pb = new PanelBuilder();
        pb.user(user).name(ivPanelName);
        Arrays.stream(EntityDamageEvent.DamageCause.values()).map(c -> this.getPanelItem((EntityDamageEvent.DamageCause)c, user)).sorted(Comparator.comparing(PanelItem::getName)).forEach(pb::item);
        pb.build();
    }

    private PanelItem getPanelItem(EntityDamageEvent.DamageCause c, User user) {
        PanelItemBuilder pib = new PanelItemBuilder();
        pib.name(this.getTranslation(user, c.name()));
        pib.clickHandler(this);
        if (this.getIWM().getIvSettings(user.getWorld()).contains(c.name())) {
            pib.icon(Material.GREEN_SHULKER_BOX);
            pib.description(user.getTranslation("protection.panel.flag-item.setting-active", new String[0]));
        } else {
            pib.icon(Material.RED_SHULKER_BOX);
            pib.description(user.getTranslation("protection.panel.flag-item.setting-disabled", new String[0]));
        }
        return pib.build();
    }

    private String getTranslation(User user, String name) {
        String translation = user.getTranslationOrNothing("enums.DamageCause." + name, new String[0]);
        return translation.isEmpty() ? Util.prettifyText(name) : translation;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onVisitorGetDamage(EntityDamageEvent e) {
        Player p;
        block10: {
            block9: {
                World world = e.getEntity().getWorld();
                Entity entity = e.getEntity();
                if (!(entity instanceof Player)) break block9;
                p = (Player)entity;
                if (this.getIWM().inWorld(world) && !p.hasMetadata("NPC") && this.getIWM().getIvSettings(world).contains(e.getCause().name()) && !this.getIslands().userIsOnIsland(world, User.getInstance(p)) && !this.PVPAllowed(p.getLocation())) break block10;
            }
            return;
        }
        InvincibleVistorFlagDamageRemovalEvent event = new InvincibleVistorFlagDamageRemovalEvent(p, e.getCause());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        e.setCancelled(true);
        if (e.getCause().equals((Object)EntityDamageEvent.DamageCause.VOID)) {
            if (this.getIslands().getIslandAt(p.getLocation()).isPresent()) {
                this.getIslands().getIslandAt(p.getLocation()).ifPresent(island -> new SafeSpotTeleport.Builder(this.getPlugin()).entity((Entity)p).location(island.getProtectionCenter().toVector().toLocation(p.getWorld())).build());
            } else if (this.getIslands().hasIsland(p.getWorld(), p.getUniqueId())) {
                this.getIslands().homeTeleportAsync(p.getWorld(), p);
            } else {
                e.setCancelled(false);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onVisitorTargeting(EntityTargetLivingEntityEvent e) {
        block3: {
            block2: {
                World world = e.getEntity().getWorld();
                LivingEntity livingEntity = e.getTarget();
                if (!(livingEntity instanceof Player)) break block2;
                Player p = (Player)livingEntity;
                if (this.getIWM().inWorld(world) && !e.getTarget().hasMetadata("NPC") && !this.getIslands().userIsOnIsland(world, User.getInstance((CommandSender)e.getTarget())) && !this.PVPAllowed(p.getLocation()) && e.getReason() != EntityTargetEvent.TargetReason.TARGET_DIED && this.getIWM().getIvSettings(world).contains(EntityDamageEvent.DamageCause.ENTITY_ATTACK.name())) break block3;
            }
            return;
        }
        e.setCancelled(true);
    }
}

