/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.lists.Flags;

public class FlagsManager {
    private final @NonNull BentoBox plugin;
    private final Map<@NonNull Flag, @Nullable Addon> flags = new HashMap<Flag, Addon>();
    private final Map<@NonNull Listener, @NonNull Boolean> registeredListeners = new HashMap<Listener, Boolean>();

    public FlagsManager(@NonNull BentoBox plugin) {
        this.plugin = plugin;
        Flags.values().forEach(f -> this.registerFlag(null, (Flag)f));
    }

    public boolean registerFlag(@NonNull Flag flag) {
        return this.registerFlag(null, flag);
    }

    public boolean registerFlag(@Nullable Addon addon, @NonNull Flag flag) {
        for (Flag fl : this.flags.keySet()) {
            if (!fl.getID().equals(flag.getID())) continue;
            return false;
        }
        this.flags.put(flag, addon);
        flag.getListener().ifPresent(this::registerListener);
        return true;
    }

    public void registerListeners() {
        this.registeredListeners.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).forEach(this::registerListener);
    }

    private void registerListener(@NonNull Listener l) {
        if (!this.registeredListeners.computeIfAbsent(l, k -> false).booleanValue()) {
            Bukkit.getPluginManager().registerEvents(l, (Plugin)this.plugin);
            this.registeredListeners.put(l, true);
        }
    }

    public @NonNull List<Flag> getFlags() {
        return new ArrayList<Flag>(this.flags.keySet());
    }

    public @NonNull Optional<Flag> getFlag(@NonNull String id) {
        return this.flags.keySet().stream().filter(flag -> flag.getID().equals(id)).findFirst();
    }

    public void unregister(@NonNull Addon addon) {
        this.flags.entrySet().stream().filter(e -> addon.equals(e.getValue())).map(Map.Entry::getKey).forEach(f -> f.getListener().ifPresent(HandlerList::unregisterAll));
        this.flags.values().removeIf(addon::equals);
    }

    public void unregister(@NonNull Flag flag) {
        flag.getListener().ifPresent(HandlerList::unregisterAll);
        this.flags.remove(flag);
    }
}

