/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.panels.customizable;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.TemplatedPanel;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.panels.builders.TemplatedPanelBuilder;
import world.bentobox.bentobox.api.panels.reader.ItemTemplateRecord;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBundle;
import world.bentobox.bentobox.panels.customizable.AbstractPanel;
import world.bentobox.bentobox.util.Util;

public class IslandCreationPanel
extends AbstractPanel {
    private static final String BUNDLES = "BUNDLE";
    private static final String ISLAND_CREATION_COMMANDS = "ISLAND_CREATION_COMMANDS";
    private static final String BUNDLE_BUTTON_REF = "panels.island_creation.buttons.bundle.";
    private final List<BlueprintBundle> elementList;
    private final World world;
    private final boolean reset;

    private IslandCreationPanel(@NonNull CompositeCommand command, @NonNull User user, @NonNull String label, boolean reset) {
        super(command, user);
        this.mainLabel = label;
        this.world = command.getWorld();
        this.reset = reset;
        this.elementList = this.plugin.getBlueprintsManager().getBlueprintBundles((GameModeAddon)command.getAddon()).values().stream().sorted(Comparator.comparingInt(BlueprintBundle::getSlot).thenComparing(BlueprintBundle::getUniqueId)).filter(bundle -> !bundle.isRequirePermission() || this.user.hasPermission(command.getPermissionPrefix() + "island.create." + bundle.getUniqueId())).toList();
    }

    @Override
    protected void build() {
        if (this.elementList.isEmpty()) {
            this.plugin.logError("There are no available phases for selection!");
            this.user.sendMessage("no-phases", "[gamemode]", this.plugin.getDescription().getName());
            return;
        }
        TemplatedPanelBuilder panelBuilder = new TemplatedPanelBuilder();
        if (this.doesCustomPanelExists((GameModeAddon)this.command.getAddon(), "island_creation_panel")) {
            panelBuilder.template("island_creation_panel", new File(((Addon)this.command.getAddon()).getDataFolder(), "panels"));
        } else {
            panelBuilder.template("island_creation_panel", new File(this.plugin.getDataFolder(), "panels"));
        }
        panelBuilder.user(this.user);
        panelBuilder.world(this.user.getWorld());
        panelBuilder.registerTypeBuilder(BUNDLES, this::createBundleButton);
        panelBuilder.registerTypeBuilder("NEXT", this::createNextButton);
        panelBuilder.registerTypeBuilder("PREVIOUS", this::createPreviousButton);
        panelBuilder.build();
    }

    @Override
    protected @Nullable PanelItem createNextButton(@NonNull ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        int size = this.elementList.size();
        if (size <= slot.amountMap().getOrDefault(BUNDLES, 1) || 1.0 * (double)size / (double)slot.amountMap().getOrDefault(BUNDLES, 1).intValue() <= (double)(this.pageIndex + 1)) {
            return null;
        }
        int nextPageIndex = this.pageIndex + 2;
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            ItemStack clone = template.icon().clone();
            if (((Boolean)template.dataMap().getOrDefault("indexing", false)).booleanValue()) {
                clone.setAmount(nextPageIndex);
            }
            builder.icon(clone);
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.command.getWorld(), template.title(), new String[0]));
        }
        if (template.description() != null) {
            builder.description(this.user.getTranslation(this.command.getWorld(), template.description(), "[number]", String.valueOf(nextPageIndex)));
        }
        builder.clickHandler((panel, user, clickType, i) -> {
            template.actions().forEach(action -> {
                if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && "NEXT".equalsIgnoreCase(action.actionType())) {
                    ++this.pageIndex;
                    this.build();
                }
            });
            return true;
        });
        List tooltips = template.actions().stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.command.getWorld(), action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(template.actions().size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }

    @Override
    protected @Nullable PanelItem createPreviousButton(@NonNull ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.pageIndex == 0) {
            return null;
        }
        int previousPageIndex = this.pageIndex;
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            ItemStack clone = template.icon().clone();
            if (((Boolean)template.dataMap().getOrDefault("indexing", false)).booleanValue()) {
                clone.setAmount(previousPageIndex);
            }
            builder.icon(clone);
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.command.getWorld(), template.title(), new String[0]));
        }
        if (template.description() != null) {
            builder.description(this.user.getTranslation(this.command.getWorld(), template.description(), "[number]", String.valueOf(previousPageIndex)));
        }
        builder.clickHandler((panel, user, clickType, i) -> {
            template.actions().forEach(action -> {
                if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && "PREVIOUS".equalsIgnoreCase(action.actionType())) {
                    --this.pageIndex;
                    this.build();
                }
            });
            return true;
        });
        List tooltips = template.actions().stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.command.getWorld(), action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(template.actions().size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }

    private @Nullable PanelItem createBundleButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.elementList.isEmpty()) {
            return null;
        }
        int index = this.pageIndex * slot.amountMap().getOrDefault(BUNDLES, 1) + slot.slot();
        BlueprintBundle blueprintBundle = index >= this.elementList.size() ? null : this.elementList.get(index);
        if (template.dataMap().containsKey("unique_id")) {
            blueprintBundle = this.elementList.stream().filter(bundle -> bundle.getUniqueId().equals(template.dataMap().get("unique_id"))).findFirst().orElse(blueprintBundle);
        }
        return this.createBundleButton(template, blueprintBundle);
    }

    private PanelItem createBundleButton(ItemTemplateRecord template, BlueprintBundle bundle) {
        if (bundle == null) {
            return null;
        }
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            builder.icon(template.icon().clone());
        } else {
            builder.icon(bundle.getIcon());
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.command.getWorld(), template.title(), "[name]", bundle.getDisplayName()));
        } else {
            builder.name(this.user.getTranslation("panels.island_creation.buttons.bundle.name", "[name]", bundle.getDisplayName()));
        }
        if (template.description() != null) {
            builder.description(this.user.getTranslation(this.command.getWorld(), template.description(), "[description]", String.join((CharSequence)"\n", bundle.getDescription())));
        } else {
            builder.description(this.user.getTranslation("panels.island_creation.buttons.bundle.description", "[description]", String.join((CharSequence)"\n", bundle.getDescription())));
        }
        boolean usedUp = false;
        if (this.plugin.getSettings().getIslandNumber() > 1) {
            int maxTimes = bundle.getTimes();
            if (maxTimes > 0) {
                long uses = this.plugin.getIslands().getIslands(this.world, this.user).stream().filter(is -> is.getMetaData("bundle").map(mdv -> bundle.getDisplayName().equalsIgnoreCase(mdv.asString()) && (!this.reset || !is.isPrimary(this.user.getUniqueId()))).orElse(false)).count();
                builder.description(this.user.getTranslation("panels.island_creation.buttons.bundle.uses", "[number]", String.valueOf(uses), "[max]", String.valueOf(maxTimes)));
                if (uses >= (long)maxTimes) {
                    usedUp = true;
                }
            } else {
                builder.description(this.user.getTranslation("panels.island_creation.buttons.bundle.unlimited", new String[0]));
            }
        }
        if (usedUp) {
            if (this.plugin.getSettings().isHideUsedBlueprints()) {
                return null;
            }
        } else {
            List<ItemTemplateRecord.ActionRecords> actions = template.actions().stream().filter(action -> "SELECT".equalsIgnoreCase(action.actionType()) || "COMMANDS".equalsIgnoreCase(action.actionType())).toList();
            builder.clickHandler((panel, user, clickType, i) -> {
                actions.forEach(action -> {
                    if (clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) {
                        if ("SELECT".equalsIgnoreCase(action.actionType())) {
                            user.closeInventory();
                            this.command.execute(user, this.mainLabel, Collections.singletonList(bundle.getUniqueId()));
                        } else if ("COMMANDS".equalsIgnoreCase(action.actionType())) {
                            Util.runCommands(user, Arrays.stream(action.content().replaceAll(Pattern.quote("[label]"), this.command.getTopLabel()).split("\n")).toList(), ISLAND_CREATION_COMMANDS);
                        }
                    }
                });
                return true;
            });
            List tooltips = actions.stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.command.getWorld(), action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(actions.size())));
            if (!tooltips.isEmpty()) {
                builder.description("");
                builder.description(tooltips);
            }
        }
        return builder.build();
    }

    public static void openPanel(@NonNull CompositeCommand command, @NonNull User user, @NonNull String label, boolean reset) {
        new IslandCreationPanel(command, user, label, reset).build();
    }
}

