/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ExpiringSet<E>
implements Set<E>,
AutoCloseable {
    private final ConcurrentMap<E, ScheduledFuture<?>> scheduledTasks;
    private final ScheduledExecutorService scheduler;
    private final long expirationTime;

    public ExpiringSet(long expirationTime, TimeUnit timeUnit) {
        if (expirationTime <= 0L) {
            throw new IllegalArgumentException("Expiration time must be greater than zero.");
        }
        if (timeUnit == null) {
            throw new NullPointerException("TimeUnit cannot be null.");
        }
        this.scheduledTasks = new ConcurrentHashMap();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.expirationTime = timeUnit.toMillis(expirationTime);
    }

    public void shutdownNow() {
        this.scheduler.shutdownNow();
    }

    @Override
    public void close() {
        this.shutdownNow();
    }

    @Override
    public int size() {
        return this.scheduledTasks.size();
    }

    @Override
    public boolean isEmpty() {
        return this.scheduledTasks.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new NullPointerException("Element cannot be null.");
        }
        return this.scheduledTasks.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.scheduledTasks.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.scheduledTasks.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.scheduledTasks.keySet().toArray(a);
    }

    @Override
    public boolean add(E e) {
        ScheduledFuture[] futureHolder;
        if (e == null) {
            throw new NullPointerException("Element cannot be null.");
        }
        futureHolder = new ScheduledFuture[]{this.scheduler.schedule(() -> this.scheduledTasks.remove(e, futureHolder[0]), this.expirationTime, TimeUnit.MILLISECONDS)};
        ScheduledFuture oldFuture = this.scheduledTasks.put(e, futureHolder[0]);
        if (oldFuture != null) {
            oldFuture.cancel(false);
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            throw new NullPointerException("Element cannot be null.");
        }
        ScheduledFuture future = (ScheduledFuture)this.scheduledTasks.remove(o);
        if (future != null) {
            future.cancel(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException("Collection cannot be null.");
        }
        return this.scheduledTasks.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException("The specified collection cannot be null.");
        }
        boolean modified = false;
        for (E element : c) {
            if (element == null) {
                throw new NullPointerException("Collection cannot contain null elements.");
            }
            if (!this.add(element)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException("Collection cannot be null.");
        }
        return this.scheduledTasks.keySet().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException("Collection cannot be null.");
        }
        boolean modified = false;
        for (Object element : c) {
            if (!this.remove(element)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        for (ScheduledFuture future : this.scheduledTasks.values()) {
            future.cancel(false);
        }
        this.scheduledTasks.clear();
    }

    @Override
    public boolean equals(Object obj) {
        return this.scheduledTasks.keySet().equals(obj);
    }

    @Override
    public int hashCode() {
        return this.scheduledTasks.keySet().hashCode();
    }
}

