/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;

public abstract class DelayedTeleportCommand
extends CompositeCommand
implements Listener {
    private static final Map<UUID, DelayedCommand> toBeMonitored = new HashMap<UUID, DelayedCommand>();

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        if (toBeMonitored.containsKey(uuid) && !e.getTo().toVector().equals((Object)toBeMonitored.get(uuid).location().toVector())) {
            this.moved(uuid);
        }
    }

    private void moved(UUID uuid) {
        toBeMonitored.get(uuid).task().cancel();
        toBeMonitored.remove(uuid);
        User.getInstance(uuid).notify("commands.delay.moved-so-command-cancelled", new String[0]);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        if (toBeMonitored.containsKey(uuid)) {
            this.moved(uuid);
        }
    }

    protected DelayedTeleportCommand(Addon addon, String label, String ... aliases) {
        super(addon, label, aliases);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    protected DelayedTeleportCommand(Addon addon, CompositeCommand parent, String label, String ... aliases) {
        super(addon, parent, label, aliases);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    protected DelayedTeleportCommand(CompositeCommand parent, String label, String ... aliases) {
        super(parent, label, aliases);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    public void delayCommand(User user, String message, Runnable confirmed) {
        if (this.getSettings().getDelayTime() < 1 || user.isOp() || user.hasPermission(this.getPermissionPrefix() + "mod.bypasscooldowns") || user.hasPermission(this.getPermissionPrefix() + "mod.bypassdelays")) {
            Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), confirmed);
            return;
        }
        UUID uuid = user.getUniqueId();
        if (toBeMonitored.containsKey(uuid)) {
            toBeMonitored.get(uuid).task().cancel();
            toBeMonitored.remove(uuid);
            user.sendMessage("commands.delay.previous-command-cancelled", new String[0]);
        }
        if (!message.trim().isEmpty()) {
            user.sendRawMessage(message);
        }
        user.sendMessage("commands.delay.stand-still", "[seconds]", String.valueOf(this.getSettings().getDelayTime()));
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), () -> {
            Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), toBeMonitored.get(uuid).runnable());
            toBeMonitored.remove(uuid);
        }, (long)this.getPlugin().getSettings().getDelayTime() * 20L);
        toBeMonitored.put(uuid, new DelayedCommand(confirmed, task, user.getLocation()));
    }

    public void delayCommand(User user, Runnable command) {
        this.delayCommand(user, "", command);
    }

    private record DelayedCommand(Runnable runnable, BukkitTask task, Location location) {
    }
}

