/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.block.BlockFace;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class IslandNearCommand
extends CompositeCommand {
    private static final List<BlockFace> COMPASS_POINTS = Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);

    public IslandNearCommand(CompositeCommand islandCommand) {
        super(islandCommand, "near", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.near");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.near.parameters");
        this.setDescription("commands.island.near.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (!args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        UUID playerUUID = user.getUniqueId();
        if (!this.getIslands().hasIsland(this.getWorld(), playerUUID) && !this.getIslands().inTeam(this.getWorld(), playerUUID)) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        user.sendMessage("commands.island.near.the-following-islands", new String[0]);
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        int dist = this.getIWM().getIslandDistance(this.getWorld()) * 2;
        boolean noNeighbors = true;
        for (BlockFace face : COMPASS_POINTS) {
            assert (island != null);
            String name = this.getIslands().getIslandAt(island.getCenter().getBlock().getRelative(face, dist).getLocation()).map(i -> this.getName(user, (Island)i)).orElse("");
            if (name.isEmpty()) continue;
            noNeighbors = false;
            user.sendMessage("commands.island.near.syntax", "[direction]", user.getTranslation("commands.island.near." + face.name().toLowerCase(Locale.ENGLISH), new String[0]), "[name]", name);
        }
        if (noNeighbors) {
            user.sendMessage("commands.island.near.no-neighbors", new String[0]);
        }
        return true;
    }

    private String getName(User user, Island island) {
        if (island.getName() != null && !island.getName().isEmpty()) {
            return island.getName();
        }
        if (island.isUnowned()) {
            return user.getTranslation("commands.admin.info.unowned", new String[0]);
        }
        return this.getPlayers().getName(island.getOwner());
    }
}

