/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island.team;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandTeamPromoteCommand
extends CompositeCommand {
    private User target;

    public IslandTeamPromoteCommand(CompositeCommand islandTeamCommand, String string) {
        super(islandTeamCommand, string, new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.team.promote");
        this.setOnlyPlayer(true);
        if (this.getLabel().equals("promote")) {
            this.setParametersHelp("commands.island.team.promote.parameters");
            this.setDescription("commands.island.team.promote.description");
        } else {
            this.setParametersHelp("commands.island.team.demote.parameters");
            this.setDescription("commands.island.team.demote.description");
        }
        this.setConfigurableRankCommand();
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        if (!this.getIslands().inTeam(this.getWorld(), user.getUniqueId())) {
            user.sendMessage("general.errors.no-team", new String[0]);
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        int rank = Objects.requireNonNull(island).getRank(user);
        if (rank < island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        this.target = this.getPlayers().getUser(args.getFirst());
        if (this.target == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        if (!island.inTeam(this.target.getUniqueId())) {
            user.sendMessage("commands.island.team.promote.errors.must-be-member", new String[0]);
            return false;
        }
        if (this.target.equals(user)) {
            if (this.getLabel().equals("promote")) {
                user.sendMessage("commands.island.team.promote.errors.cant-promote-yourself", new String[0]);
            } else {
                user.sendMessage("commands.island.team.demote.errors.cant-demote-yourself", new String[0]);
            }
            return false;
        }
        if (island.getRank(this.target) >= island.getRank(user)) {
            if (this.getLabel().equals("promote")) {
                user.sendMessage("commands.island.team.promote.errors.cant-promote", new String[0]);
            } else {
                user.sendMessage("commands.island.team.demote.errors.cant-demote", new String[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        return this.change(user, this.target);
    }

    private boolean change(User user, User target) {
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        assert (island != null);
        int currentRank = island.getRank(target);
        if (this.getLabel().equals("promote")) {
            int nextRank = RanksManager.getInstance().getRankUpValue(currentRank);
            if (nextRank < 1000 && currentRank >= 500 && nextRank > currentRank) {
                island.setRank(target, nextRank);
                String rankName = user.getTranslation(RanksManager.getInstance().getRank(nextRank), new String[0]);
                user.sendMessage("commands.island.team.promote.success", "[name]", target.getName(), "[rank]", rankName, "[display_name]", target.getDisplayName());
                IslandEvent.builder().island(island).involvedPlayer(user.getUniqueId()).admin(false).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(currentRank, nextRank).build();
                return true;
            }
            user.sendMessage("commands.island.team.promote.failure", new String[0]);
            return false;
        }
        int prevRank = RanksManager.getInstance().getRankDownValue(currentRank);
        if (prevRank >= 500 && prevRank < currentRank) {
            island.setRank(target, prevRank);
            String rankName = user.getTranslation(RanksManager.getInstance().getRank(prevRank), new String[0]);
            user.sendMessage("commands.island.team.demote.success", "[name]", target.getName(), "[rank]", rankName, "[display_name]", target.getDisplayName());
            IslandEvent.builder().island(island).involvedPlayer(user.getUniqueId()).admin(false).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(currentRank, prevRank).build();
            return true;
        }
        user.sendMessage("commands.island.team.demote.failure", new String[0]);
        return false;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        if (island != null) {
            List<String> options = island.getMemberSet().stream().map(Bukkit::getOfflinePlayer).map(OfflinePlayer::getName).toList();
            String lastArg = !args.isEmpty() ? args.getLast() : "";
            return Optional.of(Util.tabLimit(options, lastArg));
        }
        return Optional.empty();
    }
}

