/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.user;

import com.google.common.base.Enums;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.events.OfflineMessageEvent;
import world.bentobox.bentobox.api.metadata.MetaDataAble;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.database.objects.Players;
import world.bentobox.bentobox.util.Util;

public class User
implements MetaDataAble {
    private static final Map<UUID, User> users = new HashMap<UUID, User>();
    private static final Map<Particle, Class<?>> VALIDATION_CHECK;
    private static BentoBox plugin;
    private final @Nullable Player player;
    private OfflinePlayer offlinePlayer;
    private final UUID playerUUID;
    private final @Nullable CommandSender sender;
    private Addon addon;

    public static void clearUsers() {
        users.clear();
    }

    public static @NonNull User getInstance(@NonNull CommandSender sender) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            return User.getInstance(p);
        }
        return new User(sender);
    }

    public static @NonNull User getInstance(@NonNull Player player) {
        if (users.containsKey(player.getUniqueId())) {
            return users.get(player.getUniqueId());
        }
        return new User(player);
    }

    public static @NonNull User getInstance(@NonNull UUID uuid) {
        if (users.containsKey(uuid)) {
            return users.get(uuid);
        }
        return new User(uuid);
    }

    public static @NonNull User getInstance(@NonNull OfflinePlayer offlinePlayer) {
        if (users.containsKey(offlinePlayer.getUniqueId())) {
            return users.get(offlinePlayer.getUniqueId());
        }
        return new User(offlinePlayer);
    }

    public static void removePlayer(Player player) {
        if (player != null) {
            users.remove(player.getUniqueId());
        }
    }

    private User(@Nullable CommandSender sender) {
        this.player = null;
        this.playerUUID = null;
        this.sender = sender;
    }

    private User(@NonNull Player player) {
        this.player = player;
        this.offlinePlayer = player;
        this.sender = player;
        this.playerUUID = player.getUniqueId();
        users.put(this.playerUUID, this);
    }

    private User(@NonNull OfflinePlayer offlinePlayer) {
        this.player = offlinePlayer.isOnline() ? offlinePlayer.getPlayer() : null;
        this.playerUUID = offlinePlayer.getUniqueId();
        this.sender = offlinePlayer.isOnline() ? offlinePlayer.getPlayer() : null;
        this.offlinePlayer = offlinePlayer;
    }

    private User(UUID playerUUID) {
        this.player = Bukkit.getPlayer((UUID)playerUUID);
        this.playerUUID = playerUUID;
        this.sender = this.player;
        this.offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUUID);
    }

    public static void setPlugin(BentoBox p) {
        plugin = p;
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.sender == null ? Set.of() : this.sender.getEffectivePermissions();
    }

    public @NonNull PlayerInventory getInventory() {
        return Objects.requireNonNull(this.player, "getInventory can only be called for online players!").getInventory();
    }

    public @NonNull Location getLocation() {
        return Objects.requireNonNull(this.player, "getLocation can only be called for online players!").getLocation();
    }

    public @NonNull String getName() {
        return this.player != null ? this.player.getName() : plugin.getPlayers().getName(this.playerUUID);
    }

    public @NonNull String getDisplayName() {
        return this.player != null ? this.player.getDisplayName() : plugin.getPlayers().getName(this.playerUUID);
    }

    public Component displayName() {
        return this.player != null ? this.player.displayName() : Component.text((String)plugin.getPlayers().getName(this.playerUUID));
    }

    public @NonNull Player getPlayer() {
        return Objects.requireNonNull(this.player, "User is not a player!");
    }

    public boolean isPlayer() {
        return this.player != null;
    }

    public @NonNull OfflinePlayer getOfflinePlayer() {
        return Objects.requireNonNull(this.offlinePlayer, "User is not an OfflinePlayer!");
    }

    public boolean isOfflinePlayer() {
        return this.offlinePlayer != null;
    }

    public @Nullable CommandSender getSender() {
        return this.sender;
    }

    public UUID getUniqueId() {
        return this.playerUUID;
    }

    public boolean hasPermission(@Nullable String permission) {
        return permission == null || permission.isEmpty() || this.isOp() || this.sender != null && this.sender.hasPermission(permission);
    }

    public boolean removePerm(String name) {
        if (this.player == null) {
            return false;
        }
        for (PermissionAttachmentInfo p : this.player.getEffectivePermissions()) {
            if (!p.getPermission().equals(name) || p.getAttachment() == null) continue;
            this.player.removeAttachment(p.getAttachment());
            break;
        }
        this.player.recalculatePermissions();
        return !this.player.hasPermission(name);
    }

    public PermissionAttachment addPerm(String name) {
        assert (this.player != null);
        return this.player.addAttachment((Plugin)plugin, name, true);
    }

    public boolean isOnline() {
        return this.player != null && this.player.isOnline();
    }

    public boolean isOp() {
        if (this.sender != null) {
            return this.sender.isOp();
        }
        if (this.playerUUID != null && this.offlinePlayer != null) {
            return this.offlinePlayer.isOp();
        }
        return false;
    }

    public int getPermissionValue(String permissionPrefix, int defaultValue) {
        if (!this.isPlayer() || this.player == null) {
            return defaultValue;
        }
        if (permissionPrefix.endsWith(".")) {
            permissionPrefix = permissionPrefix.substring(0, permissionPrefix.length() - 1);
        }
        String permPrefix = permissionPrefix + ".";
        List<String> permissions = this.player.getEffectivePermissions().stream().filter(PermissionAttachmentInfo::getValue).map(PermissionAttachmentInfo::getPermission).filter(permission -> permission.startsWith(permPrefix)).toList();
        if (permissions.isEmpty()) {
            return defaultValue;
        }
        return this.iteratePerms(permissions, permPrefix, defaultValue);
    }

    private int iteratePerms(List<String> permissions, String permPrefix, int defaultValue) {
        int value = 0;
        if (this.player == null) {
            return 0;
        }
        for (String permission : permissions) {
            if (permission.contains(permPrefix + "*")) {
                return defaultValue;
            }
            String[] spl = permission.split(permPrefix);
            if (spl.length <= 1) continue;
            if (!NumberUtils.isNumber((String)spl[1])) {
                plugin.logError("Player " + this.player.getName() + " has permission: '" + permission + "' <-- the last part MUST be a number! Ignoring...");
                continue;
            }
            int v = Integer.parseInt(spl[1]);
            if (v < 0) {
                return v;
            }
            value = Math.max(value, v);
        }
        return value;
    }

    public String getTranslation(World world, String reference, String ... variables) {
        String addonPrefix = plugin.getIWM().getAddon(world).map(a -> a.getDescription().getName().toLowerCase(Locale.ENGLISH) + ".").orElse("");
        return Util.translateColorCodes(this.translate(addonPrefix, reference, variables));
    }

    public String getTranslation(String reference, String ... variables) {
        String addonPrefix = this.addon == null ? "" : this.addon.getDescription().getName().toLowerCase(Locale.ENGLISH) + ".";
        return Util.translateColorCodes(this.translate(addonPrefix, reference, variables));
    }

    public String getTranslationNoColor(String reference, String ... variables) {
        String addonPrefix = this.addon == null ? "" : this.addon.getDescription().getName().toLowerCase(Locale.ENGLISH) + ".";
        return this.translate(addonPrefix, reference, variables);
    }

    private String translate(String addonPrefix, String reference, String[] variables) {
        String translation = plugin.getLocalesManager().get(this, addonPrefix + reference);
        if (translation == null && (translation = plugin.getLocalesManager().get(this, reference)) == null) {
            return this.replaceVars(reference, variables);
        }
        if (!reference.startsWith("prefixes.")) {
            return this.replacePrefixes(translation, variables);
        }
        return translation;
    }

    private String replacePrefixes(String translation, String[] variables) {
        for (String prefix : plugin.getLocalesManager().getAvailablePrefixes(this)) {
            String prefixTranslation = this.getTranslation("prefixes." + prefix, new String[0]);
            translation = translation.replace("[prefix_" + prefix + "]", prefixTranslation);
        }
        if (this.player != null) {
            translation = plugin.getPlaceholdersManager().replacePlaceholders(this.player, translation);
        }
        if (variables.length > 1) {
            for (int i = 0; i < variables.length; i += 2) {
                if (variables[i + 1] == null) continue;
                translation = translation.replace(variables[i], variables[i + 1]);
            }
        }
        if (this.addon != null && this.addon.getDescription() != null) {
            translation = translation.replace("[gamemode]", this.addon.getDescription().getName());
        }
        if (this.player != null) {
            translation = translation.replace("[friendly_name]", this.isPlayer() ? plugin.getIWM().getFriendlyName(this.getWorld()) : "[friendly_name]");
        }
        return translation;
    }

    private String replaceVars(String reference, String[] variables) {
        if (this.player != null) {
            reference = plugin.getPlaceholdersManager().replacePlaceholders(this.player, reference);
        }
        if (variables.length % 2 != 0) {
            throw new IllegalArgumentException("Variable replacements must be in pairs (key, value), but got odd number: " + variables.length);
        }
        if (variables.length > 1) {
            for (int i = 0; i < variables.length; i += 2) {
                reference = reference.replace(variables[i], variables[i + 1]);
            }
        }
        return reference;
    }

    public String getTranslationOrNothing(String reference, String ... variables) {
        String translation = this.getTranslation(reference, variables);
        return translation.equals(reference) ? "" : translation;
    }

    public void sendMessage(String reference, String ... variables) {
        String message = this.getTranslation(reference, variables);
        String noColors = message.replaceAll("(?i)\u00a7[0-9A-FK-ORX]", "").trim();
        if (!noColors.isEmpty()) {
            this.sendRawMessage(message);
        }
    }

    public void sendRawMessage(String message) {
        TextComponent baseComponent = new TextComponent();
        Pattern pattern = Pattern.compile("\\[(\\w+): ([^\\]]+)]|\\[\\[(.*?)\\]]");
        Matcher matcher = pattern.matcher(message);
        int lastMatchEnd = 0;
        ClickEvent clickEvent = null;
        HoverEvent hoverEvent = null;
        while (matcher.find()) {
            block22: {
                block21: {
                    if (matcher.start() > lastMatchEnd) {
                        String beforeMatch = message.substring(lastMatchEnd, matcher.start());
                        baseComponent.addExtra(TextComponent.fromLegacy((String)beforeMatch));
                    }
                    if (matcher.group(1) == null || matcher.group(2) == null) break block21;
                    String actionType = matcher.group(1).toUpperCase(Locale.ENGLISH);
                    String actionValue = matcher.group(2);
                    switch (actionType) {
                        case "RUN_COMMAND": 
                        case "SUGGEST_COMMAND": 
                        case "COPY_TO_CLIPBOARD": 
                        case "OPEN_URL": {
                            if (clickEvent == null) {
                                clickEvent = new ClickEvent(ClickEvent.Action.valueOf((String)actionType), actionValue);
                                break;
                            }
                            break block22;
                        }
                        case "HOVER": {
                            if (hoverEvent == null) {
                                hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(actionValue)});
                                break;
                            }
                            break block22;
                        }
                        default: {
                            baseComponent.addExtra(TextComponent.fromLegacy((String)matcher.group(0)));
                            break;
                        }
                    }
                    break block22;
                }
                if (matcher.group(3) != null) {
                    baseComponent.addExtra(TextComponent.fromLegacy((String)("[[" + matcher.group(3) + "]]")));
                }
            }
            lastMatchEnd = matcher.end();
        }
        if (lastMatchEnd < message.length()) {
            String remainingText = message.substring(lastMatchEnd);
            baseComponent.addExtra(TextComponent.fromLegacy((String)remainingText));
        }
        if (clickEvent != null) {
            baseComponent.setClickEvent(clickEvent);
        }
        if (hoverEvent != null) {
            baseComponent.setHoverEvent(hoverEvent);
        }
        if (this.sender != null) {
            this.sender.spigot().sendMessage((BaseComponent)baseComponent);
        } else {
            Bukkit.getPluginManager().callEvent((Event)new OfflineMessageEvent(this.playerUUID, message));
        }
    }

    public void notify(String reference, String ... variables) {
        String message = this.getTranslation(reference, variables);
        if (!Util.stripColor(message).trim().isEmpty() && this.sender != null) {
            plugin.getNotifier().notify(this, message);
        }
    }

    public void notify(World world, String reference, String ... variables) {
        String message = this.getTranslation(world, reference, variables);
        if (!Util.stripColor(message).trim().isEmpty() && this.sender != null) {
            plugin.getNotifier().notify(this, message);
        }
    }

    public void setGameMode(GameMode mode) {
        if (this.player != null) {
            this.player.setGameMode(mode);
        }
    }

    public void teleport(Location location) {
        if (this.player != null) {
            this.player.teleport(location);
        }
    }

    public @NonNull World getWorld() {
        Objects.requireNonNull(this.player, "Cannot be called on a non-player User!");
        return Objects.requireNonNull(this.player.getWorld(), "Player's world cannot be null!");
    }

    public void closeInventory() {
        this.player.closeInventory();
    }

    public Locale getLocale() {
        if (this.sender instanceof Player && !plugin.getPlayers().getLocale(this.playerUUID).isEmpty()) {
            return Locale.forLanguageTag(plugin.getPlayers().getLocale(this.playerUUID));
        }
        return Locale.forLanguageTag(plugin.getSettings().getDefaultLanguage());
    }

    public void updateInventory() {
        this.player.updateInventory();
    }

    public boolean performCommand(String command) {
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent(this.getPlayer(), command);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            return this.getPlayer().performCommand(event.getMessage().startsWith("/") ? event.getMessage().substring(1) : event.getMessage());
        }
        return true;
    }

    public boolean inWorld() {
        return plugin.getIWM().inWorld(this.getLocation());
    }

    public void spawnParticle(Particle particle, @Nullable Object dustOptions, double x, double y, double z) {
        Class<?> expectedClass = VALIDATION_CHECK.get(particle);
        if (expectedClass == null) {
            throw new IllegalArgumentException("Unexpected value: " + String.valueOf(particle) + "\nExpected one of:" + VALIDATION_CHECK.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        }
        if (!expectedClass.isInstance(dustOptions)) {
            throw new IllegalArgumentException("A non-null " + expectedClass.getSimpleName() + " must be provided when using Particle." + String.valueOf(particle) + " as particle.");
        }
        if (this.player != null) {
            Vector vector = new Vector(x, y, z);
            if (this.player.getLocation().toVector().distanceSquared(vector) < (double)(Bukkit.getServer().getViewDistance() * 256 * Bukkit.getServer().getViewDistance())) {
                if (particle.equals(Enums.getIfPresent(Particle.class, (String)"DUST").or((Object)((Particle)Enums.getIfPresent(Particle.class, (String)"REDSTONE").or((Object)Particle.FLAME))))) {
                    this.player.spawnParticle(particle, x, y, z, 1, 0.0, 0.0, 0.0, 1.0, dustOptions);
                } else if (dustOptions != null) {
                    this.player.spawnParticle(particle, x, y, z, 1, dustOptions);
                } else {
                    this.player.spawnParticle(particle, x, y, z, 1);
                }
            }
        }
    }

    public void spawnParticle(Particle particle, Particle.DustOptions dustOptions, double x, double y, double z) {
        this.spawnParticle(particle, (Object)dustOptions, x, y, z);
    }

    public void spawnParticle(Particle particle, Particle.DustOptions dustOptions, int x, int y, int z) {
        this.spawnParticle(particle, dustOptions, (double)x, (double)y, (double)z);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.playerUUID == null ? 0 : this.playerUUID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        if (this.playerUUID == null) {
            return other.playerUUID == null;
        }
        return this.playerUUID.equals(other.playerUUID);
    }

    public void setAddon(Addon addon) {
        this.addon = addon;
    }

    @Override
    public Optional<Map<String, MetaDataValue>> getMetaData() {
        Players p = plugin.getPlayers().getPlayer(this.playerUUID);
        return Objects.requireNonNull(p, "Unknown player for " + String.valueOf(this.playerUUID)).getMetaData();
    }

    @Override
    public void setMetaData(Map<String, MetaDataValue> metaData) {
        Players p = plugin.getPlayers().getPlayer(this.playerUUID);
        Objects.requireNonNull(p, "Unknown player for " + String.valueOf(this.playerUUID)).setMetaData(metaData);
    }

    public String toString() {
        return "User [" + (String)(this.player != null ? "player=" + String.valueOf(this.player) + ", " : "") + (String)(this.offlinePlayer != null ? "offlinePlayer=" + String.valueOf(this.offlinePlayer) + ", " : "") + (String)(this.playerUUID != null ? "playerUUID=" + String.valueOf(this.playerUUID) + ", " : "") + (String)(this.sender != null ? "sender=" + String.valueOf(this.sender) + ", " : "") + (String)(this.addon != null ? "addon=" + String.valueOf(this.addon) + ", " : "") + (String)(this.getLocation() != null ? "getLocation()=" + String.valueOf(this.getLocation()) + ", " : "") + "isPlayer()=" + this.isPlayer() + "]";
    }

    static {
        EnumMap<Particle, Class<Integer>> v = new EnumMap<Particle, Class<Integer>>(Particle.class);
        v.put((Particle)Enums.getIfPresent(Particle.class, (String)"DUST").or((Object)((Particle)Enums.getIfPresent(Particle.class, (String)"REDSTONE").or((Object)Particle.FLAME))), Particle.DustOptions.class);
        if (Enums.getIfPresent(Particle.class, (String)"ITEM").isPresent()) {
            v.put(Particle.ITEM, ItemStack.class);
            v.put(Particle.ITEM_COBWEB, ItemStack.class);
            v.put(Particle.BLOCK, BlockData.class);
            v.put(Particle.DUST_PILLAR, BlockData.class);
            v.put(Particle.ENTITY_EFFECT, Color.class);
        }
        v.put(Particle.FALLING_DUST, BlockData.class);
        v.put(Particle.BLOCK_MARKER, BlockData.class);
        v.put(Particle.DUST_COLOR_TRANSITION, Particle.DustTransition.class);
        v.put(Particle.VIBRATION, Vibration.class);
        v.put(Particle.SCULK_CHARGE, Float.class);
        v.put(Particle.SHRIEK, Integer.class);
        VALIDATION_CHECK = Collections.unmodifiableMap(v);
        plugin = BentoBox.getInstance();
    }
}

