/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.hooks;

import com.onarandombox.MultiverseCore.MultiverseCore;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.hooks.Hook;
import world.bentobox.bentobox.hooks.WorldManagementHook;

public class MultiverseCore4Hook
extends Hook
implements WorldManagementHook {
    public MultiverseCore4Hook() {
        super("Multiverse-Core", Material.COMPASS);
    }

    @Override
    public void registerWorld(World world, boolean islandWorld) {
        MultiverseCore core = (MultiverseCore)Bukkit.getPluginManager().getPlugin("Multiverse-Core");
        if (core == null) {
            return;
        }
        String generator = islandWorld ? this.getGenerator(world) : null;
        try {
            core.getMVWorldManager().addWorld(world.getName(), world.getEnvironment(), String.valueOf(world.getSeed()), world.getWorldType(), Boolean.valueOf(world.canGenerateStructures()), generator);
            core.getMVWorldManager().getMVWorld(world.getName()).setAutoLoad(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getGenerator(World world) {
        return BentoBox.getInstance().getIWM().getAddon(world).map(gm -> gm.getDefaultWorldGenerator(world.getName(), "") != null).orElse(false) != false ? BentoBox.getInstance().getName() : null;
    }

    @Override
    public void unregisterWorld(World world) {
        MultiverseCore core = (MultiverseCore)Bukkit.getPluginManager().getPlugin("Multiverse-Core");
        if (core == null) {
            return;
        }
        core.getMVWorldManager().removeWorldFromConfig(world.getName());
    }

    @Override
    public boolean hook() {
        return true;
    }

    @Override
    public String getFailureCause() {
        return null;
    }
}

