/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.clicklisteners;

import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.event.inventory.ClickType;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.listeners.flags.clicklisteners.CommandRankClickListener;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.managers.RanksManager;

public class CommandCycleClick
implements PanelItem.ClickHandler {
    protected static final String COMMAND_RANK_PREFIX = "COMMAND_RANK:";
    private final BentoBox plugin = BentoBox.getInstance();
    private final String command;
    private final CommandRankClickListener commandRankClickListener;

    public CommandCycleClick(CommandRankClickListener commandRankClickListener, String c) {
        this.commandRankClickListener = commandRankClickListener;
        this.command = c;
    }

    @Override
    public boolean onClick(Panel panel, User user, ClickType click, int slot) {
        World world = panel.getWorld().orElse(user.getWorld());
        Island island = panel.getIsland();
        if (island != null && island.getOwner() != null && island.isAllowed(user, Flags.CHANGE_SETTINGS)) {
            int currentRank = island.getRankCommand(this.command);
            if (click.equals((Object)ClickType.LEFT)) {
                if (currentRank == 1000) {
                    island.setRankCommand(this.command, 500);
                } else {
                    island.setRankCommand(this.command, RanksManager.getInstance().getRankUpValue(currentRank));
                }
                user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
            } else if (click.equals((Object)ClickType.RIGHT)) {
                if (currentRank == 500) {
                    island.setRankCommand(this.command, 1000);
                } else {
                    island.setRankCommand(this.command, RanksManager.getInstance().getRankDownValue(currentRank));
                }
                user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
            } else if (click.equals((Object)ClickType.SHIFT_LEFT) && user.isOp()) {
                this.leftShiftClick(user);
            }
            panel.getInventory().setItem(slot, this.commandRankClickListener.getPanelItem(this.command, user, world).getItem());
        } else {
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
        }
        return true;
    }

    private void leftShiftClick(User user) {
        String configSetting = COMMAND_RANK_PREFIX + this.command;
        if (!this.plugin.getIWM().getHiddenFlags(user.getWorld()).contains(configSetting)) {
            this.plugin.getIWM().getHiddenFlags(user.getWorld()).add(configSetting);
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
        } else {
            this.plugin.getIWM().getHiddenFlags(user.getWorld()).remove(configSetting);
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.0f);
        }
        this.plugin.getIWM().getAddon(user.getWorld()).ifPresent(GameModeAddon::saveWorldSettings);
    }
}

